/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.AsyncMemcacheService;
import com.google.appengine.api.memcache.BaseMemcacheServiceImpl;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheSerialization;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceApiHelper;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.api.memcache.Stats;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class AsyncMemcacheServiceImpl
extends BaseMemcacheServiceImpl
implements AsyncMemcacheService {
    AsyncMemcacheServiceImpl(String namespace) {
        super(namespace);
    }

    static <T, V> Map<T, V> makeMap(Collection<T> keys, V value) {
        LinkedHashMap<T, V> map = new LinkedHashMap<T, V>(keys.size(), 1.0f);
        for (T key : keys) {
            map.put(key, value);
        }
        return map;
    }

    private static ByteString makePbKey(Object key) {
        try {
            return ByteString.copyFrom(MemcacheSerialization.makePbKey(key));
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as a key: '" + key + "'", ex);
        }
    }

    private static MemcacheSerialization.ValueAndFlags serializeValue(Object value) {
        try {
            return MemcacheSerialization.serialize(value);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot use as value: '" + value + "'", ex);
        }
    }

    private Object deserializeItem(Object key, MemcacheServicePb.MemcacheGetResponse.Item item) {
        try {
            return MemcacheSerialization.deserialize(item.getValue().toByteArray(), item.getFlags());
        }
        catch (ClassNotFoundException ex) {
            this.getErrorHandler().handleDeserializationError(new InvalidValueException("Can't find class for value of key '" + key + "'", ex));
            return null;
        }
        catch (IOException ex) {
            throw new InvalidValueException("IO exception parsing value of '" + key + "'", ex);
        }
    }

    private <M extends Message, T> MemcacheServiceApiHelper.RpcResponseHandler<M, T> createRpcResponseHandler(M response, String errorText, MemcacheServiceApiHelper.Transformer<M, T> responseTransformer) {
        return new MemcacheServiceApiHelper.RpcResponseHandler<M, T>(response, errorText, responseTransformer, this.getErrorHandler());
    }

    @Override
    public Future<Boolean> contains(Object key) {
        return this.doGet(key, false, "Memcache contains: exception testing contains (" + key + ")", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, Boolean>(){

            @Override
            public Boolean transform(MemcacheServicePb.MemcacheGetResponse response) {
                return response.getItemCount() > 0;
            }
        }, DefaultValueProviders.falseValue());
    }

    private <T> Future<T> doGet(Object key, boolean forCas, String errorText, MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, T> responseTransfomer, MemcacheServiceApiHelper.Provider<T> defaultValue) {
        MemcacheServicePb.MemcacheGetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheGetRequest.newBuilder();
        requestBuilder.addKey(AsyncMemcacheServiceImpl.makePbKey(key));
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        if (forCas) {
            requestBuilder.setForCas(true);
        }
        return MemcacheServiceApiHelper.makeAsyncCall("Get", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheGetResponse.getDefaultInstance(), errorText, responseTransfomer), defaultValue);
    }

    @Override
    public Future<Object> get(final Object key) {
        return this.doGet(key, false, "Memcache get: exception getting 1 key (" + key + ")", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, Object>(){

            @Override
            public Object transform(MemcacheServicePb.MemcacheGetResponse response) {
                return response.getItemCount() == 0 ? null : AsyncMemcacheServiceImpl.this.deserializeItem(key, response.getItem(0));
            }
        }, DefaultValueProviders.nullValue());
    }

    @Override
    public Future<MemcacheService.IdentifiableValue> getIdentifiable(final Object key) {
        return this.doGet(key, true, "Memcache getIdentifiable: exception getting 1 key (" + key + ")", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, MemcacheService.IdentifiableValue>(){

            @Override
            public MemcacheService.IdentifiableValue transform(MemcacheServicePb.MemcacheGetResponse response) {
                if (response.getItemCount() == 0) {
                    return null;
                }
                MemcacheServicePb.MemcacheGetResponse.Item item = response.getItem(0);
                return new IdentifiableValueImpl(AsyncMemcacheServiceImpl.this.deserializeItem(key, item), item.getCasId());
            }
        }, DefaultValueProviders.nullValue());
    }

    public <K> Future<Map<K, MemcacheService.IdentifiableValue>> getIdentifiables(Collection<K> keys) {
        return this.doGetAll(keys, true, "Memcache getIdentifiables: exception getting multiple keys", new MemcacheServiceApiHelper.Transformer<KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item>, MemcacheService.IdentifiableValue>(){

            @Override
            public MemcacheService.IdentifiableValue transform(KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item> pair) {
                MemcacheServicePb.MemcacheGetResponse.Item item = (MemcacheServicePb.MemcacheGetResponse.Item)pair.value;
                Object value = AsyncMemcacheServiceImpl.this.deserializeItem(pair.key, item);
                return new IdentifiableValueImpl(value, item.getCasId());
            }
        }, DefaultValueProviders.emptyMap());
    }

    public <K> Future<Map<K, Object>> getAll(Collection<K> keys) {
        return this.doGetAll(keys, false, "Memcache getAll: exception getting multiple keys", new MemcacheServiceApiHelper.Transformer<KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item>, Object>(){

            @Override
            public Object transform(KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item> pair) {
                return AsyncMemcacheServiceImpl.this.deserializeItem(pair.key, (MemcacheServicePb.MemcacheGetResponse.Item)pair.value);
            }
        }, DefaultValueProviders.emptyMap());
    }

    private <K, V> Future<Map<K, V>> doGetAll(Collection<K> keys, boolean forCas, String errorText, final MemcacheServiceApiHelper.Transformer<KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item>, V> responseTransfomer, MemcacheServiceApiHelper.Provider<Map<K, V>> defaultValue) {
        MemcacheServicePb.MemcacheGetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheGetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        final HashMap<ByteString, K> byteStringToKey = new HashMap<ByteString, K>(keys.size(), 1.0f);
        for (K key : keys) {
            ByteString pbKey = AsyncMemcacheServiceImpl.makePbKey(key);
            byteStringToKey.put(pbKey, key);
            requestBuilder.addKey(pbKey);
        }
        if (forCas) {
            requestBuilder.setForCas(forCas);
        }
        return MemcacheServiceApiHelper.makeAsyncCall("Get", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheGetResponse.getDefaultInstance(), errorText, new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, Map<K, V>>(){

            @Override
            public Map<K, V> transform(MemcacheServicePb.MemcacheGetResponse response) {
                HashMap result = new HashMap();
                for (MemcacheServicePb.MemcacheGetResponse.Item item : response.getItemList()) {
                    Object key = byteStringToKey.get(item.getKey());
                    Object obj = responseTransfomer.transform(KeyValuePair.of(key, item));
                    result.put(key, obj);
                }
                return result;
            }
        }), defaultValue);
    }

    private Future<Boolean> doPut(final Object key, MemcacheService.IdentifiableValue oldValue, Object value, Expiration expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy policy) {
        MemcacheServicePb.MemcacheSetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheSetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        MemcacheServicePb.MemcacheSetRequest.Item.Builder itemBuilder = MemcacheServicePb.MemcacheSetRequest.Item.newBuilder();
        MemcacheSerialization.ValueAndFlags vaf = AsyncMemcacheServiceImpl.serializeValue(value);
        itemBuilder.setValue(ByteString.copyFrom(vaf.value));
        itemBuilder.setFlags(vaf.flags.ordinal());
        itemBuilder.setKey(AsyncMemcacheServiceImpl.makePbKey(key));
        itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
        itemBuilder.setSetPolicy(policy);
        if (policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS) {
            if (oldValue == null) {
                throw new IllegalArgumentException("oldValue must not be null.");
            }
            if (!(oldValue instanceof IdentifiableValueImpl)) {
                throw new IllegalArgumentException("oldValue is an instance of an unapproved IdentifiableValue implementation.  Perhaps you implemented your own version of IdentifiableValue?  If so, don't do this.");
            }
            itemBuilder.setCasId(((IdentifiableValueImpl)oldValue).getCasId());
        }
        requestBuilder.addItem(itemBuilder);
        return MemcacheServiceApiHelper.makeAsyncCall("Set", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheSetResponse.getDefaultInstance(), String.format("Memcache put: exception setting 1 key (%s) to '%s'", key, value), new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheSetResponse, Boolean>(){

            @Override
            public Boolean transform(MemcacheServicePb.MemcacheSetResponse response) {
                if (response.getSetStatusCount() != 1) {
                    throw new MemcacheServiceException("Memcache put: Set one item, got " + response.getSetStatusCount() + " response statuses");
                }
                MemcacheServicePb.MemcacheSetResponse.SetStatusCode status = response.getSetStatus(0);
                if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR) {
                    throw new MemcacheServiceException("Memcache put: Error setting single item (" + key + ")");
                }
                return status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED;
            }
        }), DefaultValueProviders.falseValue());
    }

    private static MemcacheServicePb.MemcacheSetRequest.SetPolicy convertSetPolicyToPb(MemcacheService.SetPolicy policy) {
        switch (policy) {
            case SET_ALWAYS: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET;
            }
            case ADD_ONLY_IF_NOT_PRESENT: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.ADD;
            }
            case REPLACE_ONLY_IF_PRESENT: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.REPLACE;
            }
        }
        throw new IllegalArgumentException("Unknown policy: " + (Object)((Object)policy));
    }

    @Override
    public Future<Boolean> put(Object key, Object value, Expiration expires, MemcacheService.SetPolicy policy) {
        return this.doPut(key, null, value, expires, AsyncMemcacheServiceImpl.convertSetPolicyToPb(policy));
    }

    @Override
    public Future<Void> put(Object key, Object value, Expiration expires) {
        return VoidFutureWrapper.wrap(this.doPut(key, null, value, expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET));
    }

    @Override
    public Future<Void> put(Object key, Object value) {
        return VoidFutureWrapper.wrap(this.doPut(key, null, value, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET));
    }

    @Override
    public Future<Boolean> putIfUntouched(Object key, MemcacheService.IdentifiableValue oldValue, Object newValue, Expiration expires) {
        return this.doPut(key, oldValue, newValue, expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS);
    }

    @Override
    public Future<Boolean> putIfUntouched(Object key, MemcacheService.IdentifiableValue oldValue, Object newValue) {
        return this.doPut(key, oldValue, newValue, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS);
    }

    @Override
    public <T> Future<Set<T>> putIfUntouched(Map<T, MemcacheService.CasValues> values) {
        return this.doPutAll(values, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS, "putIfUntouched");
    }

    @Override
    public <T> Future<Set<T>> putIfUntouched(Map<T, MemcacheService.CasValues> values, Expiration expiration) {
        return this.doPutAll(values, expiration, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS, "putIfUntouched");
    }

    private <T> Future<Set<T>> doPutAll(Map<T, ?> values, Expiration expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy policy, String operation) {
        MemcacheServicePb.MemcacheSetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheSetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        final ArrayList<T> requestedKeys = new ArrayList<T>(values.size());
        for (Map.Entry<T, ?> entry : values.entrySet()) {
            MemcacheSerialization.ValueAndFlags vaf;
            MemcacheServicePb.MemcacheSetRequest.Item.Builder itemBuilder = MemcacheServicePb.MemcacheSetRequest.Item.newBuilder();
            requestedKeys.add(entry.getKey());
            itemBuilder.setKey(AsyncMemcacheServiceImpl.makePbKey(entry.getKey()));
            if (policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS) {
                MemcacheService.CasValues value = (MemcacheService.CasValues)entry.getValue();
                if (value == null) {
                    throw new IllegalArgumentException(entry.getKey() + " has a null for CasValues");
                }
                vaf = AsyncMemcacheServiceImpl.serializeValue(value.getNewValue());
                if (!(value.getOldValue() instanceof IdentifiableValueImpl)) {
                    throw new IllegalArgumentException(entry.getKey() + " CasValues has an oldValue instance of an unapproved " + "IdentifiableValue implementation.  Perhaps you implemented your own " + "version of IdentifiableValue?  If so, don't do this.");
                }
                itemBuilder.setCasId(((IdentifiableValueImpl)value.getOldValue()).getCasId());
                if (value.getExipration() != null) {
                    itemBuilder.setExpirationTime(value.getExipration().getSecondsValue());
                } else {
                    itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
                }
            } else {
                vaf = AsyncMemcacheServiceImpl.serializeValue(entry.getValue());
                itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
            }
            itemBuilder.setValue(ByteString.copyFrom(vaf.value));
            itemBuilder.setFlags(vaf.flags.ordinal());
            itemBuilder.setSetPolicy(policy);
            requestBuilder.addItem(itemBuilder);
        }
        return MemcacheServiceApiHelper.makeAsyncCall("Set", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheSetResponse.getDefaultInstance(), "Memcache " + operation + ": Unknown exception setting " + values.size() + " keys", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheSetResponse, Set<T>>(){

            @Override
            public Set<T> transform(MemcacheServicePb.MemcacheSetResponse response) {
                if (response.getSetStatusCount() != requestedKeys.size()) {
                    throw new MemcacheServiceException(String.format("Memcache put: Set %d items, got %d response statuses", requestedKeys.size(), response.getSetStatusCount()));
                }
                HashSet result = new HashSet();
                HashSet errors = new HashSet();
                Iterator<MemcacheServicePb.MemcacheSetResponse.SetStatusCode> statusIter = response.getSetStatusList().iterator();
                for (Object requestedKey : requestedKeys) {
                    MemcacheServicePb.MemcacheSetResponse.SetStatusCode status = statusIter.next();
                    if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR) {
                        errors.add(requestedKey);
                        continue;
                    }
                    if (status != MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED) continue;
                    result.add(requestedKey);
                }
                if (!errors.isEmpty()) {
                    StringBuilder builder = new StringBuilder("Memcache put: Set failed to set ");
                    builder.append(errors.size()).append(" keys: ");
                    for (Object err : errors) {
                        builder.append(err).append(", ");
                    }
                    builder.setLength(builder.length() - 2);
                    throw new MemcacheServiceException(builder.toString());
                }
                return result;
            }
        }), DefaultValueProviders.emptySet());
    }

    @Override
    public <T> Future<Set<T>> putAll(Map<T, ?> values, Expiration expires, MemcacheService.SetPolicy policy) {
        return this.doPutAll(values, expires, AsyncMemcacheServiceImpl.convertSetPolicyToPb(policy), "putAll");
    }

    @Override
    public Future<Void> putAll(Map<?, ?> values, Expiration expires) {
        return VoidFutureWrapper.wrap(this.doPutAll(values, expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET, "putAll"));
    }

    @Override
    public Future<Void> putAll(Map<?, ?> values) {
        return VoidFutureWrapper.wrap(this.doPutAll(values, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET, "putAll"));
    }

    @Override
    public Future<Boolean> delete(Object key) {
        return this.delete(key, 0L);
    }

    @Override
    public Future<Boolean> delete(Object key, long millisNoReAdd) {
        MemcacheServicePb.MemcacheDeleteRequest request = MemcacheServicePb.MemcacheDeleteRequest.newBuilder().setNameSpace(this.getEffectiveNamespace()).addItem(MemcacheServicePb.MemcacheDeleteRequest.Item.newBuilder().setKey(AsyncMemcacheServiceImpl.makePbKey(key)).setDeleteTime((int)TimeUnit.SECONDS.convert(millisNoReAdd, TimeUnit.MILLISECONDS))).build();
        return MemcacheServiceApiHelper.makeAsyncCall("Delete", request, this.createRpcResponseHandler(MemcacheServicePb.MemcacheDeleteResponse.getDefaultInstance(), "Memcache delete: Unknown exception deleting key: " + key, new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheDeleteResponse, Boolean>(){

            @Override
            public Boolean transform(MemcacheServicePb.MemcacheDeleteResponse response) {
                return response.getDeleteStatus(0) == MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED;
            }
        }), DefaultValueProviders.falseValue());
    }

    @Override
    public <T> Future<Set<T>> deleteAll(Collection<T> keys) {
        return this.deleteAll(keys, 0L);
    }

    @Override
    public <T> Future<Set<T>> deleteAll(Collection<T> keys, long millisNoReAdd) {
        MemcacheServicePb.MemcacheDeleteRequest.Builder requestBuilder = MemcacheServicePb.MemcacheDeleteRequest.newBuilder().setNameSpace(this.getEffectiveNamespace());
        final ArrayList<T> requestedKeys = new ArrayList<T>(keys.size());
        for (T key : keys) {
            requestedKeys.add(key);
            requestBuilder.addItem(MemcacheServicePb.MemcacheDeleteRequest.Item.newBuilder().setDeleteTime((int)(millisNoReAdd / 1000L)).setKey(AsyncMemcacheServiceImpl.makePbKey(key)));
        }
        return MemcacheServiceApiHelper.makeAsyncCall("Delete", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheDeleteResponse.getDefaultInstance(), "Memcache deleteAll: Unknown exception deleting multiple keys", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheDeleteResponse, Set<T>>(){

            @Override
            public Set<T> transform(MemcacheServicePb.MemcacheDeleteResponse response) {
                LinkedHashSet retval = new LinkedHashSet();
                Iterator requestedKeysIter = requestedKeys.iterator();
                for (MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode deleteStatus : response.getDeleteStatusList()) {
                    Object requestedKey = requestedKeysIter.next();
                    if (deleteStatus != MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED) continue;
                    retval.add(requestedKey);
                }
                return retval;
            }
        }), DefaultValueProviders.emptySet());
    }

    private static MemcacheServicePb.MemcacheIncrementRequest.Builder newIncrementRequestBuilder(Object key, long delta, Long initialValue) {
        MemcacheServicePb.MemcacheIncrementRequest.Builder requestBuilder = MemcacheServicePb.MemcacheIncrementRequest.newBuilder();
        requestBuilder.setKey(AsyncMemcacheServiceImpl.makePbKey(key));
        if (delta > 0L) {
            requestBuilder.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.INCREMENT);
            requestBuilder.setDelta(delta);
        } else {
            requestBuilder.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.DECREMENT);
            requestBuilder.setDelta(-delta);
        }
        if (initialValue != null) {
            requestBuilder.setInitialValue(initialValue);
            requestBuilder.setInitialFlags(MemcacheSerialization.Flag.LONG.ordinal());
        }
        return requestBuilder;
    }

    @Override
    public Future<Long> increment(Object key, long delta) {
        return this.increment(key, delta, null);
    }

    @Override
    public Future<Long> increment(final Object key, long delta, Long initialValue) {
        MemcacheServicePb.MemcacheIncrementRequest request = AsyncMemcacheServiceImpl.newIncrementRequestBuilder(key, delta, initialValue).setNameSpace(this.getEffectiveNamespace()).build();
        return MemcacheServiceApiHelper.makeAsyncCall("Increment", request, new MemcacheServiceApiHelper.RpcResponseHandler<MemcacheServicePb.MemcacheIncrementResponse, Long>(MemcacheServicePb.MemcacheIncrementResponse.getDefaultInstance(), "Memcache increment: exception when incrementing key '" + key + "'", (MemcacheServiceApiHelper.Transformer)new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheIncrementResponse, Long>(){

            @Override
            public Long transform(MemcacheServicePb.MemcacheIncrementResponse response) {
                return response.hasNewValue() ? Long.valueOf(response.getNewValue()) : null;
            }
        }, this.getErrorHandler()){

            @Override
            void handleApiProxyException(Throwable cause) throws Throwable {
                if (cause instanceof ApiProxy.ApplicationException) {
                    this.getLogger().info(((ApiProxy.ApplicationException)cause).getErrorDetail());
                    throw new InvalidValueException("Non-incrementable value for key '" + key + "'");
                }
                super.handleApiProxyException(cause);
            }
        }, DefaultValueProviders.nullValue());
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Collection<T> keys, long delta) {
        return this.incrementAll(keys, delta, null);
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Collection<T> keys, long delta, Long initialValue) {
        return this.incrementAll(AsyncMemcacheServiceImpl.makeMap(keys, delta), initialValue);
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Map<T, Long> offsets) {
        return this.incrementAll(offsets, null);
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Map<T, Long> offsets, Long initialValue) {
        MemcacheServicePb.MemcacheBatchIncrementRequest.Builder requestBuilder = MemcacheServicePb.MemcacheBatchIncrementRequest.newBuilder().setNameSpace(this.getEffectiveNamespace());
        final ArrayList<T> requestedKeys = new ArrayList<T>(offsets.size());
        for (Map.Entry<T, Long> entry : offsets.entrySet()) {
            requestedKeys.add(entry.getKey());
            requestBuilder.addItem(AsyncMemcacheServiceImpl.newIncrementRequestBuilder(entry.getKey(), entry.getValue(), initialValue));
        }
        return MemcacheServiceApiHelper.makeAsyncCall("BatchIncrement", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheBatchIncrementResponse.getDefaultInstance(), "Memcache incrmentAll: exception incrementing multiple keys", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheBatchIncrementResponse, Map<T, Long>>(){

            @Override
            public Map<T, Long> transform(MemcacheServicePb.MemcacheBatchIncrementResponse response) {
                LinkedHashMap result = new LinkedHashMap(requestedKeys.size(), 1.0f);
                Iterator<MemcacheServicePb.MemcacheIncrementResponse> items = response.getItemList().iterator();
                for (Object requestedKey : requestedKeys) {
                    MemcacheServicePb.MemcacheIncrementResponse item = items.next();
                    if (item.getIncrementStatus().equals(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.OK) && item.hasNewValue()) {
                        result.put(requestedKey, item.getNewValue());
                        continue;
                    }
                    result.put(requestedKey, null);
                }
                return result;
            }
        }), new MemcacheServiceApiHelper.Provider<Map<T, Long>>(){

            @Override
            public Map<T, Long> get() {
                return AsyncMemcacheServiceImpl.makeMap(requestedKeys, null);
            }
        });
    }

    @Override
    public Future<Void> clearAll() {
        return MemcacheServiceApiHelper.makeAsyncCall("FlushAll", MemcacheServicePb.MemcacheFlushRequest.getDefaultInstance(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheFlushResponse.getDefaultInstance(), "Memcache clearAll: exception", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheFlushResponse, Void>(){

            @Override
            public Void transform(MemcacheServicePb.MemcacheFlushResponse response) {
                return null;
            }
        }), DefaultValueProviders.nullValue());
    }

    @Override
    public Future<Stats> getStatistics() {
        return MemcacheServiceApiHelper.makeAsyncCall("Stats", MemcacheServicePb.MemcacheStatsRequest.getDefaultInstance(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheStatsResponse.getDefaultInstance(), "Memcache getStatistics: exception", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheStatsResponse, Stats>(){

            @Override
            public Stats transform(MemcacheServicePb.MemcacheStatsResponse response) {
                return new StatsImpl(response.getStats());
            }
        }), DefaultValueProviders.emptyStats());
    }

    private static final class KeyValuePair<K, V> {
        private final K key;
        private final V value;

        private KeyValuePair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        static <K, V> KeyValuePair<K, V> of(K key, V value) {
            return new KeyValuePair<K, V>(key, value);
        }
    }

    private static class VoidFutureWrapper<K>
    extends FutureWrapper<K, Void> {
        private VoidFutureWrapper(Future<K> parent) {
            super(parent);
        }

        private static <K> Future<Void> wrap(Future<K> parent) {
            return new VoidFutureWrapper<K>(parent);
        }

        @Override
        protected Void wrap(K value) {
            return null;
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            return cause;
        }
    }

    private static class DefaultValueProviders {
        private static final MemcacheServiceApiHelper.Provider NULL_PROVIDER = new MemcacheServiceApiHelper.Provider(){

            public Object get() {
                return null;
            }
        };
        private static final MemcacheServiceApiHelper.Provider<Boolean> FALSE_PROVIDER = new MemcacheServiceApiHelper.Provider<Boolean>(){

            @Override
            public Boolean get() {
                return Boolean.FALSE;
            }
        };
        private static final MemcacheServiceApiHelper.Provider SET_PROVIDER = new MemcacheServiceApiHelper.Provider<Set<?>>(){

            @Override
            public Set<?> get() {
                return new HashSet(0, 1.0f);
            }
        };
        private static final MemcacheServiceApiHelper.Provider MAP_PROVIDER = new MemcacheServiceApiHelper.Provider<Map<?, ?>>(){

            @Override
            public Map<?, ?> get() {
                return new HashMap(0, 1.0f);
            }
        };
        private static final MemcacheServiceApiHelper.Provider<Stats> STATS_PROVIDER = new MemcacheServiceApiHelper.Provider<Stats>(){
            final Stats emptyStats = new StatsImpl(null);

            @Override
            public Stats get() {
                return this.emptyStats;
            }
        };

        private DefaultValueProviders() {
        }

        static MemcacheServiceApiHelper.Provider<Boolean> falseValue() {
            return FALSE_PROVIDER;
        }

        static <T> MemcacheServiceApiHelper.Provider<T> nullValue() {
            return NULL_PROVIDER;
        }

        static <T> MemcacheServiceApiHelper.Provider<Set<T>> emptySet() {
            return SET_PROVIDER;
        }

        static <K, V> MemcacheServiceApiHelper.Provider<Map<K, V>> emptyMap() {
            return MAP_PROVIDER;
        }

        static MemcacheServiceApiHelper.Provider<Stats> emptyStats() {
            return STATS_PROVIDER;
        }
    }

    static class IdentifiableValueImpl
    implements MemcacheService.IdentifiableValue {
        private final Object value;
        private final long casId;

        IdentifiableValueImpl(Object value, long casId) {
            this.value = value;
            this.casId = casId;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        long getCasId() {
            return this.casId;
        }
    }

    static class StatsImpl
    implements Stats {
        private final long hits;
        private final long misses;
        private final long bytesFetched;
        private final long items;
        private final long bytesStored;
        private final int maxCachedTime;

        StatsImpl(MemcacheServicePb.MergedNamespaceStats stats) {
            if (stats != null) {
                this.hits = stats.getHits();
                this.misses = stats.getMisses();
                this.bytesFetched = stats.getByteHits();
                this.items = stats.getItems();
                this.bytesStored = stats.getBytes();
                this.maxCachedTime = stats.getOldestItemAge();
            } else {
                this.bytesStored = 0L;
                this.items = 0L;
                this.bytesFetched = 0L;
                this.misses = 0L;
                this.hits = 0L;
                this.maxCachedTime = 0;
            }
        }

        @Override
        public long getHitCount() {
            return this.hits;
        }

        @Override
        public long getMissCount() {
            return this.misses;
        }

        @Override
        public long getBytesReturnedForHits() {
            return this.bytesFetched;
        }

        @Override
        public long getItemCount() {
            return this.items;
        }

        @Override
        public long getTotalItemBytes() {
            return this.bytesStored;
        }

        @Override
        public int getMaxTimeWithoutAccess() {
            return this.maxCachedTime;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Hits: ").append(this.hits).append('\n');
            builder.append("Misses: ").append(this.misses).append('\n');
            builder.append("Bytes Fetched: ").append(this.bytesFetched).append('\n');
            builder.append("Bytes Stored: ").append(this.bytesStored).append('\n');
            builder.append("Items: ").append(this.items).append('\n');
            builder.append("Max Cached Time: ").append(this.maxCachedTime).append('\n');
            return builder.toString();
        }
    }
}

