/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@Beta
public final class CacheStats {
    private final long hitCount;
    private final long missCount;
    private final long createSuccessCount;
    private final long createExceptionCount;
    private final long totalCreateTime;
    private final long evictionCount;

    public CacheStats(long hitCount, long missCount, long createSuccessCount, long createExceptionCount, long totalCreateTime, long evictionCount) {
        Preconditions.checkArgument(hitCount >= 0L);
        Preconditions.checkArgument(missCount >= 0L);
        Preconditions.checkArgument(createSuccessCount >= 0L);
        Preconditions.checkArgument(createExceptionCount >= 0L);
        Preconditions.checkArgument(totalCreateTime >= 0L);
        Preconditions.checkArgument(evictionCount >= 0L);
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.createSuccessCount = createSuccessCount;
        this.createExceptionCount = createExceptionCount;
        this.totalCreateTime = totalCreateTime;
        this.evictionCount = evictionCount;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public long createCount() {
        return this.createSuccessCount + this.createExceptionCount;
    }

    public long createSuccessCount() {
        return this.createSuccessCount;
    }

    public long createExceptionCount() {
        return this.createExceptionCount;
    }

    public double createExceptionRate() {
        long totalCreateCount = this.createSuccessCount + this.createExceptionCount;
        return totalCreateCount == 0L ? 0.0 : (double)this.createExceptionCount / (double)totalCreateCount;
    }

    public long totalCreateTime() {
        return this.totalCreateTime;
    }

    public double averageCreatePenalty() {
        long totalCreateCount = this.createSuccessCount + this.createExceptionCount;
        return totalCreateCount == 0L ? 0.0 : (double)this.totalCreateTime / (double)totalCreateCount;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public CacheStats minus(CacheStats other) {
        return new CacheStats(Math.max(0L, this.hitCount - other.hitCount), Math.max(0L, this.missCount - other.missCount), Math.max(0L, this.createSuccessCount - other.createSuccessCount), Math.max(0L, this.createExceptionCount - other.createExceptionCount), Math.max(0L, this.totalCreateTime - other.totalCreateTime), Math.max(0L, this.evictionCount - other.evictionCount));
    }

    public int hashCode() {
        return Objects.hashCode(this.hitCount, this.missCount, this.createSuccessCount, this.createExceptionCount, this.totalCreateTime, this.evictionCount);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof CacheStats) {
            CacheStats other = (CacheStats)object;
            return this.hitCount == other.hitCount && this.missCount == other.missCount && this.createSuccessCount == other.createSuccessCount && this.createExceptionCount == other.createExceptionCount && this.totalCreateTime == other.totalCreateTime && this.evictionCount == other.evictionCount;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("hitCount", this.hitCount).add("missCount", this.missCount).add("createSuccessCount", this.createSuccessCount).add("createExceptionCount", this.createExceptionCount).add("totalCreateTime", this.totalCreateTime).add("evictionCount", this.evictionCount).toString();
    }
}

