/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import twitter4j.auth.Authorization;
import twitter4j.internal.http.BASE64Encoder;
import twitter4j.internal.http.HttpRequest;

public class BasicAuthorization
implements Authorization,
Serializable {
    private String userId;
    private String password;
    private String basic;
    private static final long serialVersionUID = -5861104407848415060L;

    public BasicAuthorization(String userId, String password) {
        this.userId = userId;
        this.password = password;
        this.basic = this.encodeBasicAuthenticationString();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    private String encodeBasicAuthenticationString() {
        if (null != this.userId && null != this.password) {
            return "Basic " + BASE64Encoder.encode((this.userId + ":" + this.password).getBytes());
        }
        return null;
    }

    public String getAuthorizationHeader(HttpRequest req) {
        return this.basic;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicAuthorization)) {
            return false;
        }
        BasicAuthorization that = (BasicAuthorization)o;
        return this.basic.equals(that.basic);
    }

    public int hashCode() {
        return this.basic.hashCode();
    }

    public String toString() {
        return "BasicAuthorization{userId='" + this.userId + '\'' + ", password='**********''" + '}';
    }
}

