/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import twitter4j.MediaEntity;
import twitter4j.TwitterException;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaEntityJSONImpl
implements MediaEntity {
    private static final long serialVersionUID = -5196438049688518593L;
    private long id;
    private int start = -1;
    private int end = -1;
    private URL url;
    private URL mediaURL;
    private URL mediaURLHttps;
    private URL expandedURL;
    private String displayURL;
    private Map<Integer, MediaEntity.Size> sizes;

    public MediaEntityJSONImpl(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.start = indicesArray.getInt(0);
            this.end = indicesArray.getInt(1);
            this.id = ParseUtil.getLong("id", json);
            try {
                this.url = new URL(json.getString("url"));
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
            if (!json.isNull("expanded_url")) {
                try {
                    this.expandedURL = new URL(json.getString("expanded_url"));
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
            }
            if (!json.isNull("media_url")) {
                try {
                    this.mediaURL = new URL(json.getString("media_url"));
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
            }
            if (!json.isNull("media_url_https")) {
                try {
                    this.mediaURLHttps = new URL(json.getString("media_url_https"));
                }
                catch (MalformedURLException ignore) {
                    // empty catch block
                }
            }
            if (!json.isNull("display_url")) {
                this.displayURL = json.getString("display_url");
            }
            JSONObject sizes = json.getJSONObject("sizes");
            this.sizes = new HashMap<Integer, MediaEntity.Size>(4);
            this.sizes.put(MediaEntity.Size.LARGE, new Size(sizes.getJSONObject("large")));
            this.sizes.put(MediaEntity.Size.MEDIUM, new Size(sizes.getJSONObject("medium")));
            this.sizes.put(MediaEntity.Size.SMALL, new Size(sizes.getJSONObject("small")));
            this.sizes.put(MediaEntity.Size.THUMB, new Size(sizes.getJSONObject("thumb")));
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public URL getMediaURL() {
        return this.mediaURL;
    }

    @Override
    public URL getMediaURLHttps() {
        return this.mediaURLHttps;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getDisplayURL() {
        return this.displayURL;
    }

    @Override
    public URL getExpandedURL() {
        return this.expandedURL;
    }

    @Override
    public Map<Integer, MediaEntity.Size> getSizes() {
        return this.sizes;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaEntityJSONImpl)) {
            return false;
        }
        MediaEntityJSONImpl that = (MediaEntityJSONImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return new StringBuffer().append("MediaEntityJSONImpl{id=").append(this.id).append(", start=").append(this.start).append(", end=").append(this.end).append(", url=").append(this.url).append(", mediaURL=").append(this.mediaURL).append(", mediaURLHttps=").append(this.mediaURLHttps).append(", expandedURL=").append(this.expandedURL).append(", displayURL='").append(this.displayURL).append('\'').append(", sizes=").append(this.sizes).append('}').toString();
    }

    static class Size
    implements MediaEntity.Size {
        private static final long serialVersionUID = 8681853416159361581L;
        int width;
        int height;
        int resize;

        Size(JSONObject json) throws JSONException {
            this.width = json.getInt("w");
            this.height = json.getInt("h");
            this.resize = "fit".equals(json.getString("resize")) ? 100 : 101;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getResize() {
            return this.resize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Size)) {
                return false;
            }
            Size size = (Size)o;
            if (this.height != size.height) {
                return false;
            }
            if (this.resize != size.resize) {
                return false;
            }
            return this.width == size.width;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.resize;
            return result;
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + ", resize=" + this.resize + '}';
        }
    }
}

