/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

public class FileUpload
extends Widget
implements HasName,
HasChangeHandlers {
    private FileUploadImpl impl;

    public static FileUpload wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        FileUpload fileUpload = new FileUpload(element);
        fileUpload.onAttach();
        RootPanel.detachOnWindowClose(fileUpload);
        return fileUpload;
    }

    public FileUpload() {
        this.setElement(Document.get().createFileInputElement());
        this.setStyleName("gwt-FileUpload");
        this.impl = (FileUploadImpl)GWT.create(FileUploadImpl.class);
        this.impl.init(this);
    }

    protected FileUpload(Element element) {
        assert (InputElement.as(element).getType().equalsIgnoreCase("file"));
        this.setElement(element);
    }

    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler(handler, ChangeEvent.getType());
    }

    public String getFilename() {
        return this.getInputElement().getValue();
    }

    public String getName() {
        return this.getInputElement().getName();
    }

    public boolean isEnabled() {
        return !this.getElement().getPropertyBoolean("disabled");
    }

    public void onBrowserEvent(Event event) {
        if (this.impl.onBrowserEvent(event)) {
            super.onBrowserEvent(event);
        }
    }

    public void setEnabled(boolean enabled) {
        this.getElement().setPropertyBoolean("disabled", !enabled);
    }

    public void setName(String name) {
        this.getInputElement().setName(name);
    }

    private InputElement getInputElement() {
        return (InputElement)this.getElement().cast();
    }

    private static class FileUploadImplOpera
    extends FileUploadImpl {
        private FileUpload fileUpload;
        private boolean eventPending;
        private boolean allowEvent;

        private FileUploadImplOpera() {
        }

        public void init(FileUpload fileUpload) {
            this.fileUpload = fileUpload;
            fileUpload.sinkEvents(4096);
        }

        public boolean onBrowserEvent(Event event) {
            switch (event.getTypeInt()) {
                case 1024: {
                    if (this.allowEvent) break;
                    this.eventPending = true;
                    return false;
                }
                case 4096: {
                    if (!this.eventPending) break;
                    this.allowEvent = true;
                    this.fileUpload.getElement().dispatchEvent(Document.get().createChangeEvent());
                    this.allowEvent = false;
                    this.eventPending = false;
                }
            }
            return true;
        }
    }

    private static class FileUploadImpl {
        private FileUploadImpl() {
        }

        public void init(FileUpload fileUpload) {
        }

        public boolean onBrowserEvent(Event event) {
            return true;
        }
    }
}

