/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.speckle.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.storage.speckle.jdbc.internal.Exceptions;
import com.google.storage.speckle.jdbc.internal.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public class ClientSideBlob
implements Blob {
    private byte[] data;

    public ClientSideBlob(byte[] data) {
        this.data = (byte[])data.clone();
    }

    public ClientSideBlob(ByteString data) {
        this.data = data.toByteArray();
    }

    public long length() throws SQLException {
        this.throwIfFreed();
        return this.data.length;
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.throwIfFreed();
        this.check(pos >= 1L && pos <= (long)this.data.length, "pos", pos);
        this.check(length > 0 && (long)length < pos + (long)this.data.length, "length", length);
        int index = (int)(pos - 1L);
        return Arrays.copyOfRange(this.data, index, index + length);
    }

    public InputStream getBinaryStream() throws SQLException {
        this.throwIfFreed();
        return new ByteArrayInputStream((byte[])this.data.clone());
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.throwIfFreed();
        this.check(pos >= 1L && pos <= (long)this.data.length, "pos", pos);
        this.check(length > 0L && length < pos + (long)this.data.length, "length", length);
        return new ByteArrayInputStream((byte[])this.data.clone(), (int)pos - 1, (int)length);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        this.throwIfFreed();
        this.check(start >= 1L, "start", start);
        if (pattern.length == 0) {
            return -1L;
        }
        long result = ClientSideBlob.indexOf(this.data, pattern, start - 1L);
        return result == -1L ? -1L : result + 1L;
    }

    public long position(Blob pattern, long start) throws SQLException {
        this.throwIfFreed();
        this.check(start >= 1L, "start", start);
        if (pattern.length() == 0L) {
            return -1L;
        }
        byte[] patternBytes = pattern.getBytes(1L, (int)pattern.length());
        return this.position(patternBytes, start);
    }

    private static long indexOf(byte[] array, byte[] target, long start) {
        Util.checkNotNull(array, "array");
        Util.checkNotNull(target, "target");
        Util.checkArgument(target.length > 0, "target");
        Util.checkArgument(start >= 0L, "start");
        block0: for (int i = (int)start; i < array.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1L;
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.throwIfFreed();
        this.check(pos >= 1L, "pos", pos);
        if (pos == 1L && bytes.length >= this.data.length) {
            this.data = (byte[])bytes.clone();
            return this.data.length;
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.throwIfFreed();
        this.check(pos >= 1L, "pos", pos);
        if (--pos + (long)len > (long)this.data.length) {
            this.resize(pos + (long)len);
        }
        System.arraycopy(bytes, offset, this.data, (int)pos, len);
        return len;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.throwIfFreed();
        this.check(pos >= 1L, "pos", pos);
        return new BlobOutputStream(this, pos);
    }

    public void truncate(long len) throws SQLException {
        this.throwIfFreed();
        this.check(len > 0L, "len", len);
        if (len > (long)this.data.length) {
            return;
        }
        this.resize(len);
    }

    public void free() throws SQLException {
        this.throwIfFreed();
        this.data = null;
    }

    private void throwIfFreed() throws SQLException {
        if (this.data == null) {
            throw Exceptions.newStatementClosedException();
        }
    }

    private void check(boolean condition, String fieldName, Object value) throws SQLException {
        if (!condition) {
            throw Exceptions.newInvalidParameterException(fieldName, value);
        }
    }

    private void resize(long length) {
        this.data = Arrays.copyOf(this.data, (int)length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientSideBlob)) {
            return false;
        }
        return Arrays.equals(this.data, ((ClientSideBlob)obj).data);
    }

    private static class BlobOutputStream
    extends FilterOutputStream {
        private final ClientSideBlob blob;
        private final long startPosition;

        private BlobOutputStream(ClientSideBlob blob, long startPosition) {
            super(new ByteArrayOutputStream());
            this.blob = blob;
            this.startPosition = startPosition;
        }

        public void close() throws IOException {
            super.close();
            try {
                this.blob.setBytes(this.startPosition, ((ByteArrayOutputStream)this.out).toByteArray());
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

