/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.AtomicTracerStatMap;
import com.google.appengine.repackaged.com.google.common.base.TracingStatistic;
import com.google.appengine.repackaged.com.google.common.base.X;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public final class Tracer {
    static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private static volatile boolean defaultPrettyPrint;
    private static List<TracingStatistic> extraTracingStatistics;
    private long[] extraTracingValues;
    private final String type;
    private final String comment;
    private final long startTimeMs;
    private long stopTimeMs;
    final Thread startThread;
    static final int MAX_TRACE_SIZE = 1000;
    static InternalClock clock;
    private static final char[] manySpaces;
    private static AtomicTracerStatMap typeToCountMap;
    private static AtomicTracerStatMap typeToSilentMap;
    private static AtomicTracerStatMap typeToTimeMap;
    private static final Stat ZERO_STAT;
    private static ThreadLocal<Deque<ThreadTrace>> traceStack;

    public Tracer(@Nullable String type, @Nullable String comment) {
        ThreadTrace trace;
        this.type = type;
        this.comment = comment == null ? "" : comment;
        this.startTimeMs = clock.currentTimeMillis();
        this.startThread = Thread.currentThread();
        if (!extraTracingStatistics.isEmpty()) {
            int size = extraTracingStatistics.size();
            this.extraTracingValues = new long[size];
            int i = 0;
            for (TracingStatistic tracingStatistic : extraTracingStatistics) {
                this.extraTracingValues[i] = tracingStatistic.start(this.startThread);
                ++i;
            }
        }
        if (!(trace = Tracer.getThreadTrace()).isInitialized()) {
            return;
        }
        if (trace.events.size() >= 1000) {
            logger.log(Level.WARNING, "Giant thread trace. Too many Tracers created. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateEvents();
        }
        if (trace.outstandingEvents.size() >= 1000) {
            logger.log(Level.WARNING, "Too many outstanding Tracers. Tracer.stop() is missing or Tracer.stop() is not wrapped in a try/finally block. Clearing to avoid memory leak.", new Throwable(trace.toString()));
            trace.truncateOutstandingEvents();
        }
        trace.startEvent(this);
    }

    public Tracer(@Nullable String comment) {
        this(null, comment);
    }

    public static Tracer shortName(@Nullable Object object, @Nullable String comment) {
        if (object == null) {
            return new Tracer(comment);
        }
        return new Tracer(object.getClass().getSimpleName(), comment);
    }

    private static void appendPaddedLong(StringBuilder sb, long v, int digits_column_width) {
        int digit_width = Tracer.numDigits(v);
        Tracer.appendSpaces(sb, digits_column_width - digit_width);
        sb.append(v);
    }

    private static int numDigits(long n) {
        int i = 0;
        do {
            ++i;
        } while ((n /= 10L) > 0L);
        return i;
    }

    @VisibleForTesting
    static void appendSpaces(StringBuilder sb, int numSpaces) {
        while (numSpaces > 0) {
            int numToAppend = Math.min(numSpaces, manySpaces.length);
            sb.append(manySpaces, 0, numToAppend);
            numSpaces -= numToAppend;
        }
    }

    public static int addTracingStatistic(TracingStatistic tracingStatistic) {
        if (tracingStatistic.enable()) {
            extraTracingStatistics.add(tracingStatistic);
            return extraTracingStatistics.lastIndexOf(tracingStatistic);
        }
        return -1;
    }

    @VisibleForTesting
    static void clearTracingStatisticsTestingOnly() {
        extraTracingStatistics.clear();
    }

    public long stop(int silence_threshold) {
        X.assertTrue(Thread.currentThread() == this.startThread);
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            return 0L;
        }
        this.stopTimeMs = clock.currentTimeMillis();
        if (this.extraTracingValues != null) {
            for (int i = 0; i < this.extraTracingValues.length; ++i) {
                long value = extraTracingStatistics.get(i).stop(this.startThread);
                this.extraTracingValues[i] = value - this.extraTracingValues[i];
            }
        }
        if (!trace.isInitialized()) {
            return 0L;
        }
        trace.endEvent(this, silence_threshold);
        return this.stopTimeMs - this.startTimeMs;
    }

    public long stop() {
        return this.stop(-1);
    }

    public String toString() {
        return this.type == null ? this.comment : this.appendTo(new StringBuilder()).toString();
    }

    private StringBuilder appendTo(StringBuilder sb) {
        return this.type == null ? sb.append(this.comment) : sb.append('[').append(this.type).append("] ").append(this.comment);
    }

    public static void setDefaultSilenceThreshold(int threshold) {
        Tracer.getThreadTrace().defaultSilenceThreshold = threshold;
    }

    public static void initCurrentThreadTrace() {
        ThreadTrace events = Tracer.getThreadTrace();
        if (events.isInitialized()) {
            events = Tracer.pushNewThreadTrace();
        }
        events.init();
    }

    public static void initCurrentThreadTrace(int default_silence_threshold) {
        Tracer.initCurrentThreadTrace();
        Tracer.setDefaultSilenceThreshold(default_silence_threshold);
    }

    public static String getCurrentThreadTraceReport() {
        return Tracer.getThreadTrace().toString();
    }

    public static void logCurrentThreadTrace() {
        ThreadTrace trace = Tracer.getThreadTrace();
        if (!trace.isInitialized()) {
            logger.log(Level.WARNING, "Tracer log requested for this thread but was not initialized using Tracer.initCurrentThreadTrace().", new Throwable());
            return;
        }
        if (!trace.isEmpty()) {
            logger.log(Level.INFO, "timers:\n{0}", Tracer.getCurrentThreadTraceReport());
        }
    }

    public static void clearCurrentThreadTrace() {
        Tracer.clearThreadTrace();
    }

    public static void logAndClearCurrentThreadTrace() {
        Tracer.logCurrentThreadTrace();
        Tracer.clearThreadTrace();
    }

    public static void setPrettyPrint(boolean enabled) {
        defaultPrettyPrint = enabled;
    }

    public static synchronized void enableTypeMaps() {
        if (typeToCountMap == null) {
            typeToCountMap = new AtomicTracerStatMap();
            typeToSilentMap = new AtomicTracerStatMap();
            typeToTimeMap = new AtomicTracerStatMap();
        }
    }

    public static Map<String, Long> getTypeToCountMap() {
        return typeToCountMap != null ? typeToCountMap.getMap() : null;
    }

    public static Map<String, Long> getTypeToSilentMap() {
        return typeToSilentMap != null ? typeToSilentMap.getMap() : null;
    }

    public static Map<String, Long> getTypeToTimeMap() {
        return typeToTimeMap != null ? typeToTimeMap.getMap() : null;
    }

    public static Stat getStatsForType(String type) {
        Stat stat = Tracer.getThreadTrace().stats.get(type);
        return stat != null ? stat : ZERO_STAT;
    }

    private static String formatTime(long time) {
        int sec = (int)(time / 1000L % 60L);
        int ms = (int)(time % 1000L);
        return String.format("%02d.%03d", sec, ms);
    }

    @VisibleForTesting
    static ThreadTrace getThreadTrace() {
        ThreadTrace t = traceStack.get().peekLast();
        return t != null ? t : Tracer.pushNewThreadTrace();
    }

    private static ThreadTrace pushNewThreadTrace() {
        ThreadTrace parent = traceStack.get().peekLast();
        ThreadTrace newTrace = parent == null ? ThreadTrace.newRootThreadTrace() : ThreadTrace.newChildThreadTrace(parent);
        traceStack.get().addLast(newTrace);
        return newTrace;
    }

    private static void clearThreadTrace() {
        if (traceStack.get().pollLast() == null) {
            logger.log(Level.WARNING, "clearThreadTrace() called without a current ThreadTrace. Any call to {logAnd}clearCurrentThreadTrace() should be preceded by a corresponding call to initCurrentThreadTrace.", new Throwable());
        }
    }

    @VisibleForTesting
    static void clearThreadTraceStackForTesting() {
        traceStack.get().clear();
    }

    static {
        extraTracingStatistics = new CopyOnWriteArrayList<TracingStatistic>();
        clock = new InternalClock(){

            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        manySpaces = "                                                        ".toCharArray();
        ZERO_STAT = new Stat();
        traceStack = new ThreadLocal<Deque<ThreadTrace>>(){

            @Override
            protected Deque<ThreadTrace> initialValue() {
                return new ArrayDeque<ThreadTrace>(2);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    static final class ThreadTrace {
        @Nullable
        private final ThreadTrace parent;
        private int defaultSilenceThreshold;
        @VisibleForTesting
        final List<Event> events;
        @VisibleForTesting
        final HashSet<Tracer> outstandingEvents = new HashSet();
        @VisibleForTesting
        final Map<String, Stat> stats = new HashMap<String, Stat>();
        @VisibleForTesting
        boolean isOutstandingEventsTruncated;
        @VisibleForTesting
        boolean isEventsTruncated;
        private boolean isInitialized;
        private boolean prettyPrint;

        static ThreadTrace newRootThreadTrace() {
            return new ThreadTrace(null, new ArrayList<Event>(), 0);
        }

        static ThreadTrace newChildThreadTrace(ThreadTrace parent) {
            int numParentEvents = parent.events.size();
            return new ThreadTrace(parent, parent.events.subList(numParentEvents, numParentEvents), parent.defaultSilenceThreshold);
        }

        private ThreadTrace(@Nullable ThreadTrace parent, List<Event> events, int defaultSilenceThreshold) {
            this.parent = parent;
            this.events = events;
            this.prettyPrint = defaultPrettyPrint;
            this.defaultSilenceThreshold = defaultSilenceThreshold;
        }

        void init() {
            this.isInitialized = true;
        }

        boolean isInitialized() {
            return this.isInitialized;
        }

        void startEvent(Tracer t) {
            this.events.add(new Event(true, t));
            boolean notAlreadyOutstanding = this.outstandingEvents.add(t);
            X.assertTrue(notAlreadyOutstanding);
        }

        void endEvent(Tracer t, int silenceThreshold) {
            int i;
            boolean wasOutstanding = this.outstandingEvents.remove(t);
            if (!wasOutstanding) {
                if (this.isOutstandingEventsTruncated) {
                    logger.log(Level.WARNING, "event not found, probably because the event stack overflowed and was truncated", new Throwable());
                } else {
                    X.assertTrue(false);
                }
            }
            long elapsed = t.stopTimeMs - t.startTimeMs;
            if (silenceThreshold == -1) {
                silenceThreshold = this.defaultSilenceThreshold;
            }
            if (elapsed < (long)silenceThreshold) {
                boolean removed = false;
                for (i = 0; i < this.events.size(); ++i) {
                    Event e = this.events.get(i);
                    if (e.tracer != t) continue;
                    X.assertTrue(e.isStart);
                    this.events.remove(i);
                    removed = true;
                    break;
                }
                X.assertTrue(removed || this.isEventsTruncated);
            } else {
                this.events.add(new Event(false, t));
            }
            if (t.type != null) {
                if (typeToCountMap != null) {
                    typeToCountMap.incrementBy(t.type, 1L);
                }
                if (typeToTimeMap != null) {
                    typeToTimeMap.incrementBy(t.type, elapsed);
                }
                if (elapsed < (long)silenceThreshold && typeToSilentMap != null) {
                    typeToSilentMap.incrementBy(t.type, 1L);
                }
                if (!extraTracingStatistics.isEmpty() && t.extraTracingValues != null) {
                    int overlapLength = Math.min(extraTracingStatistics.size(), t.extraTracingValues.length);
                    for (i = 0; i < overlapLength; ++i) {
                        AtomicTracerStatMap map = ((TracingStatistic)extraTracingStatistics.get(i)).getTracingStat();
                        if (map == null) continue;
                        map.incrementBy(t.type, t.extraTracingValues[i]);
                    }
                }
                ThreadTrace trace = this;
                while (trace != null) {
                    Stat stat = trace.getStat(t.type);
                    stat.count++;
                    stat.clockTime = (int)((long)stat.clockTime + elapsed);
                    if (stat.extraInfo != null && t.extraTracingValues != null) {
                        int overlapLength = Math.min(stat.extraInfo.length, t.extraTracingValues.length);
                        for (int i2 = 0; i2 < overlapLength; ++i2) {
                            int[] nArray = stat.extraInfo;
                            int n = i2;
                            nArray[n] = (int)((long)nArray[n] + t.extraTracingValues[i2]);
                        }
                    }
                    if (elapsed < (long)silenceThreshold) {
                        stat.silent++;
                    }
                    trace = trace.parent;
                }
            }
        }

        private Stat getStat(String type) {
            Stat stat = this.stats.get(type);
            if (stat == null) {
                stat = new Stat();
                if (!extraTracingStatistics.isEmpty()) {
                    Stat.access$1502(stat, new int[extraTracingStatistics.size()]);
                }
                this.stats.put(type, stat);
            }
            return stat;
        }

        boolean isEmpty() {
            return this.events.size() == 0 && this.outstandingEvents.size() == 0;
        }

        void truncateOutstandingEvents() {
            this.isOutstandingEventsTruncated = true;
            this.outstandingEvents.clear();
        }

        void truncateEvents() {
            this.isEventsTruncated = true;
            this.events.clear();
        }

        public String toString() {
            int numDigits = this.getMaxDigits();
            StringBuilder sb = new StringBuilder();
            long etime = -1L;
            int indentDepth = 0;
            for (Event e : this.events) {
                if (this.prettyPrint && !e.isStart && indentDepth > 0) {
                    --indentDepth;
                }
                sb.append(' ');
                if (this.prettyPrint) {
                    e.appendTo(sb, etime, indentDepth, numDigits);
                } else {
                    e.appendTo(sb, etime, 0, 4);
                }
                etime = e.eventTime();
                sb.append('\n');
                if (!this.prettyPrint || !e.isStart) continue;
                ++indentDepth;
            }
            if (this.outstandingEvents.size() != 0) {
                long now = clock.currentTimeMillis();
                sb.append(" Unstopped timers:\n");
                for (Tracer t : this.outstandingEvents) {
                    sb.append("  ").append(t).append(" (").append(now - t.startTimeMs).append(" ms, started at ").append(Tracer.formatTime(t.startTimeMs)).append(")\n");
                }
            }
            for (String key : this.stats.keySet()) {
                Stat stat = this.stats.get(key);
                if (stat.count <= 1) continue;
                sb.append(" TOTAL ").append(key).append(' ').append(stat.count).append(" (").append(stat.clockTime).append(" ms");
                if (stat.extraInfo != null) {
                    for (int i = 0; i < stat.extraInfo.length; ++i) {
                        sb.append("; ");
                        sb.append(stat.extraInfo[i]).append(' ').append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                    }
                }
                sb.append(")\n");
            }
            return sb.toString();
        }

        private int getMaxDigits() {
            long etime = -1L;
            long max_time = 0L;
            for (Event e : this.events) {
                long time;
                if (etime != -1L) {
                    time = e.eventTime() - etime;
                    max_time = Math.max(max_time, time);
                }
                if (!e.isStart) {
                    time = e.tracer.stopTimeMs - e.tracer.startTimeMs;
                    max_time = Math.max(max_time, time);
                }
                etime = e.eventTime();
            }
            return Math.max(3, Tracer.numDigits(max_time));
        }
    }

    private static final class Event {
        boolean isStart;
        Tracer tracer;
        private static final String INDENT_STR = "|  ";

        Event(boolean start, Tracer t) {
            this.isStart = start;
            this.tracer = t;
        }

        long eventTime() {
            return this.isStart ? this.tracer.startTimeMs : this.tracer.stopTimeMs;
        }

        void appendTo(StringBuilder sb, long prevEventTime, int indentDepth, int digitsColWidth) {
            if (prevEventTime == -1L) {
                Tracer.appendSpaces(sb, digitsColWidth);
            } else {
                Tracer.appendPaddedLong(sb, this.eventTime() - prevEventTime, digitsColWidth);
            }
            sb.append(' ');
            sb.append(Tracer.formatTime(this.eventTime()));
            if (this.isStart) {
                sb.append(" Start ");
                Tracer.appendSpaces(sb, digitsColWidth);
                sb.append("   ");
            } else {
                sb.append(" Done ");
                long delta = this.tracer.stopTimeMs - this.tracer.startTimeMs;
                Tracer.appendPaddedLong(sb, delta, digitsColWidth);
                sb.append(" ms ");
                if (this.tracer.extraTracingValues != null) {
                    for (int i = 0; i < this.tracer.extraTracingValues.length; ++i) {
                        delta = this.tracer.extraTracingValues[i];
                        Tracer.appendPaddedLong(sb, delta, 4);
                        sb.append(((TracingStatistic)extraTracingStatistics.get(i)).getUnits());
                        sb.append(";  ");
                    }
                }
            }
            for (int i = 0; i < indentDepth; ++i) {
                sb.append(INDENT_STR);
            }
            this.tracer.appendTo(sb);
        }
    }

    public static final class Stat {
        private int count;
        private int silent;
        private int clockTime;
        private int[] extraInfo;

        public int getCount() {
            return this.count;
        }

        public int getSilentCount() {
            return this.silent;
        }

        public int getTotalTime() {
            return this.clockTime;
        }

        @VisibleForTesting
        public int getExtraInfo(int index) {
            return index >= this.extraInfo.length ? 0 : this.extraInfo[index];
        }

        static /* synthetic */ int[] access$1502(Stat x0, int[] x1) {
            x0.extraInfo = x1;
            return x1;
        }
    }

    static interface InternalClock {
        public long currentTimeMillis();
    }
}

