/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import java.util.regex.Pattern;

public final class QueueConstants {
    private static final int MAX_QUEUE_NAME_LENGTH = 100;
    private static final int MAX_TASK_NAME_LENGTH = 500;
    private static final int MAX_TASK_SIZE_BYTES = 10240;
    private static final int MAX_TASKS_PER_ADD = 100;
    private static final int MAX_URL_LENGTH = 2083;
    private static final long MAX_ETA_DELTA_MILLIS = 2592000000L;
    public static final String TASK_NAME_REGEX = "[a-zA-Z\\d-]{1," + QueueConstants.maxTaskNameLength() + "}";
    public static final Pattern TASK_NAME_PATTERN = Pattern.compile(TASK_NAME_REGEX);
    public static final String QUEUE_NAME_REGEX = "[a-zA-Z\\d-]{1," + QueueConstants.maxQueueNameLength() + "}";
    public static final Pattern QUEUE_NAME_PATTERN = Pattern.compile(QUEUE_NAME_REGEX);

    public static int maxQueueNameLength() {
        return 100;
    }

    public static int maxTaskNameLength() {
        return 500;
    }

    public static int maxTaskSizeBytes() {
        return 10240;
    }

    public static int maxTasksPerAdd() {
        return 100;
    }

    public static int maxUrlLength() {
        return 2083;
    }

    public static long getMaxEtaDeltaMillis() {
        return 2592000000L;
    }

    private QueueConstants() {
    }
}

