/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseDatastoreServiceImpl;
import com.google.appengine.api.datastore.BasePreparedQuery;
import com.google.appengine.api.datastore.CompositeIndexManager;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultIteratorImpl;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.QueryResultListImpl;
import com.google.appengine.api.datastore.QueryResultsSourceImpl;
import com.google.appengine.api.datastore.QueryTranslator;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreparedQueryImpl
extends BasePreparedQuery {
    private final DatastoreServiceConfig datastoreServiceConfig;
    private final ApiProxy.ApiConfig apiConfig;
    private final Query query;
    private final Transaction txn;

    public PreparedQueryImpl(ApiProxy.ApiConfig apiConfig, DatastoreServiceConfig datastoreServiceConfig, Query query, Transaction txn) {
        this.apiConfig = apiConfig;
        this.datastoreServiceConfig = datastoreServiceConfig;
        this.query = query;
        this.txn = txn;
        if (txn != null && query.getAncestor() == null) {
            throw new IllegalArgumentException("Only ancestor queries are allowed inside transactions.");
        }
        TransactionImpl.ensureTxnActive(txn);
    }

    private int makeAsListFetchOptions(FetchOptions override) {
        int maximumSize;
        int n = maximumSize = override.getLimit() != null ? override.getLimit() : Integer.MAX_VALUE;
        if (override.getPrefetchSize() == null) {
            override.prefetchSize(maximumSize);
        }
        return maximumSize;
    }

    @Override
    public List<Entity> asList(FetchOptions fetchOptions) {
        FetchOptions override = new FetchOptions(fetchOptions);
        int numRequested = this.makeAsListFetchOptions(override);
        return this.runQuery(this.query, override).nextList(numRequested);
    }

    @Override
    public QueryResultList<Entity> asQueryResultList(FetchOptions fetchOptions) {
        FetchOptions override = new FetchOptions(fetchOptions);
        int numRequested = this.makeAsListFetchOptions(override);
        if (override.getCompile() == null) {
            override.compile(true);
        }
        QueryResultIteratorImpl itr = this.runQuery(this.query, override);
        return new QueryResultListImpl<Entity>(itr.nextList(numRequested), itr.getCursor());
    }

    @Override
    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        return this.runQuery(this.query, fetchOptions);
    }

    @Override
    public QueryResultIterator<Entity> asQueryResultIterator(FetchOptions fetchOptions) {
        if (fetchOptions.getCompile() == null) {
            fetchOptions = new FetchOptions(fetchOptions).compile(true);
        }
        return this.runQuery(this.query, fetchOptions);
    }

    @Override
    public Entity asSingleEntity() throws PreparedQuery.TooManyResultsException {
        List<Entity> entities = this.asList(FetchOptions.Builder.withLimit(2));
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() != 1) {
            throw new PreparedQuery.TooManyResultsException();
        }
        return entities.get(0);
    }

    @Override
    public int countEntities(FetchOptions fetchOptions) {
        FetchOptions overrideOptions = new FetchOptions(fetchOptions);
        overrideOptions.limit(0);
        if (fetchOptions.getLimit() != null) {
            if (fetchOptions.getOffset() != null) {
                int offset = fetchOptions.getLimit() + fetchOptions.getOffset();
                overrideOptions.offset(offset >= 0 ? offset : Integer.MAX_VALUE);
            } else {
                overrideOptions.offset(fetchOptions.getLimit());
            }
        } else {
            overrideOptions.offset(Integer.MAX_VALUE);
        }
        int count = this.runQuery(this.query, overrideOptions).getNumSkipped();
        if (fetchOptions.getOffset() != null) {
            count = count < fetchOptions.getOffset() ? 0 : (count -= fetchOptions.getOffset().intValue());
        }
        return count;
    }

    private QueryResultIteratorImpl runQuery(Query q, FetchOptions fetchOptions) {
        final DatastorePb.Query queryProto = this.convertToPb(q, fetchOptions);
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            queryProto.setFailoverMs(-1L);
            queryProto.setStrong(false);
        }
        FutureWrapper<DatastorePb.QueryResult, DatastorePb.QueryResult> result = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "RunQuery", queryProto, new DatastorePb.QueryResult());
        result = new FutureWrapper<DatastorePb.QueryResult, DatastorePb.QueryResult>(result){

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof DatastoreNeedIndexException) {
                    PreparedQueryImpl.this.addMissingIndexData(queryProto, (DatastoreNeedIndexException)cause);
                }
                return cause;
            }

            @Override
            protected DatastorePb.QueryResult wrap(DatastorePb.QueryResult result) throws Exception {
                return result;
            }
        };
        QueryResultsSourceImpl src = new QueryResultsSourceImpl(this.apiConfig, fetchOptions, this.txn, (Future<DatastorePb.QueryResult>)result);
        return new QueryResultIteratorImpl(this, src, fetchOptions, this.txn);
    }

    private void addMissingIndexData(DatastorePb.Query queryProto, DatastoreNeedIndexException e) {
        CompositeIndexManager mgr = new CompositeIndexManager();
        CompositeIndexManager.IndexComponentsOnlyQuery indexQuery = new CompositeIndexManager.IndexComponentsOnlyQuery(queryProto);
        OnestoreEntity.Index index = mgr.compositeIndexForQuery(indexQuery);
        if (index != null) {
            String xml = mgr.generateXmlForIndex(index, CompositeIndexManager.IndexSource.manual);
            e.setMissingIndexDefinitionXml(xml);
        }
    }

    private DatastorePb.Query convertToPb(Query q, FetchOptions fetchOptions) {
        DatastorePb.Query queryProto = QueryTranslator.convertToPb(q, fetchOptions);
        if (this.txn != null) {
            TransactionImpl.ensureTxnActive(this.txn);
            queryProto.setTransaction(BaseDatastoreServiceImpl.localTxnToRemoteTxn(this.txn));
        }
        return queryProto;
    }

    public String toString() {
        return this.query.toString() + (this.txn != null ? " IN " + this.txn : "");
    }
}

