/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel;

import com.google.appengine.api.channel.ChannelFailureException;
import com.google.appengine.api.channel.ChannelMessage;
import com.google.appengine.api.channel.ChannelService;
import com.google.appengine.api.channel.ChannelServicePb;
import com.google.apphosting.api.ApiProxy;
import javax.servlet.http.HttpServletRequest;

class ChannelServiceImpl
implements ChannelService {
    public static final String PACKAGE = "channel";
    public static final String CLIENT_ID_PARAM = "key";
    public static final String MESSAGE_PARAM = "msg";

    ChannelServiceImpl() {
    }

    public String createChannel(String clientId) {
        byte[] responseBytes;
        ChannelServicePb.CreateChannelRequest request = new ChannelServicePb.CreateChannelRequest().setApplicationKey(clientId);
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "CreateChannel", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException e) {
            switch (ChannelServicePb.ChannelServiceError.ErrorCode.valueOf(e.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new ChannelFailureException("An internal channel error occured.");
                }
            }
            throw new ChannelFailureException("An unexpected error occurred.", e);
        }
        ChannelServicePb.CreateChannelResponse response = new ChannelServicePb.CreateChannelResponse();
        response.mergeFrom(responseBytes);
        return response.getClientId();
    }

    public void sendMessage(ChannelMessage message) {
        ChannelServicePb.SendMessageRequest request = new ChannelServicePb.SendMessageRequest().setApplicationKey(message.getClientId()).setMessage(message.getMessage());
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "SendChannelMessage", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException e) {
            switch (ChannelServicePb.ChannelServiceError.ErrorCode.valueOf(e.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new ChannelFailureException("An internal channel error occured.");
                }
            }
            throw new ChannelFailureException("An unexpected error occurred.", e);
        }
    }

    public ChannelMessage parseMessage(HttpServletRequest request) {
        String clientId = request.getParameter(CLIENT_ID_PARAM);
        String message = request.getParameter(MESSAGE_PARAM);
        if (clientId == null) {
            throw new IllegalStateException("Client id parameter not found in HTTP request.");
        }
        if (message == null) {
            throw new IllegalStateException("Message parameter not found in HTTP request.");
        }
        return new ChannelMessage(clientId, message);
    }
}

