/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.identity.IdentityTranslator;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;

public class XcaliaIdentityTranslator
implements IdentityTranslator {
    public Object getIdentity(ObjectManager om, Object obj) {
        if (!(obj instanceof String)) {
            return obj;
        }
        String idString = (String)obj;
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Object id = null;
        int idStringPos = idString.indexOf(58);
        if (idStringPos > 0) {
            String definer = idString.substring(0, idStringPos);
            String idKey = idString.substring(idStringPos + 1);
            AbstractClassMetaData acmd = null;
            try {
                clr.classForName(definer);
                acmd = om.getMetaDataManager().getMetaDataForClass(definer, clr);
            }
            catch (ClassNotResolvedException cnre) {
                acmd = om.getMetaDataManager().getMetaDataForDiscriminator(definer);
            }
            if (acmd != null) {
                if (acmd.getIdentityType() == IdentityType.DATASTORE) {
                    try {
                        Long keyLong = Long.valueOf(idKey);
                        id = OIDFactory.getInstance(om, acmd.getFullClassName(), keyLong);
                    }
                    catch (NumberFormatException nfe) {
                        id = OIDFactory.getInstance(om, acmd.getFullClassName(), idKey);
                    }
                } else if (acmd.getIdentityType() == IdentityType.APPLICATION) {
                    id = om.getApiAdapter().getNewApplicationIdentityObjectId(clr, acmd, idKey);
                }
            }
        }
        return id;
    }
}

