/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.Location;
import twitter4j.ResponseList;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.ParseUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocationJSONImpl
implements Location {
    private final int woeid;
    private final String countryName;
    private final String countryCode;
    private final String placeName;
    private final int placeCode;
    private final String name;
    private final String url;
    private static final long serialVersionUID = 7095092358530897222L;

    LocationJSONImpl(JSONObject location) throws TwitterException {
        try {
            this.woeid = ParseUtil.getInt("woeid", location);
            this.countryName = ParseUtil.getUnescapedString("country", location);
            this.countryCode = ParseUtil.getRawString("countryCode", location);
            if (!location.isNull("placeType")) {
                JSONObject placeJSON = location.getJSONObject("placeType");
                this.placeName = ParseUtil.getUnescapedString("name", placeJSON);
                this.placeCode = ParseUtil.getInt("code", placeJSON);
            } else {
                this.placeName = null;
                this.placeCode = -1;
            }
            this.name = ParseUtil.getUnescapedString("name", location);
            this.url = ParseUtil.getUnescapedString("url", location);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    static ResponseList<Location> createLocationList(HttpResponse res) throws TwitterException {
        return LocationJSONImpl.createLocationList(res.asJSONArray(), res);
    }

    static ResponseList<Location> createLocationList(JSONArray list, HttpResponse res) throws TwitterException {
        try {
            int size = list.length();
            ResponseListImpl<Location> locations = new ResponseListImpl<Location>(size, null);
            for (int i = 0; i < size; ++i) {
                locations.add(new LocationJSONImpl(list.getJSONObject(i)));
            }
            return locations;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    @Override
    public int getWoeid() {
        return this.woeid;
    }

    @Override
    public String getCountryName() {
        return this.countryName;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public String getPlaceName() {
        return this.placeName;
    }

    @Override
    public int getPlaceCode() {
        return this.placeCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationJSONImpl)) {
            return false;
        }
        LocationJSONImpl that = (LocationJSONImpl)o;
        return this.woeid == that.woeid;
    }

    public int hashCode() {
        return this.woeid;
    }

    public String toString() {
        return new StringBuffer().append("LocationJSONImpl{woeid=").append(this.woeid).append(", countryName='").append(this.countryName).append('\'').append(", countryCode='").append(this.countryCode).append('\'').append(", placeName='").append(this.placeName).append('\'').append(", placeCode='").append(this.placeCode).append('\'').append(", name='").append(this.name).append('\'').append(", url='").append(this.url).append('\'').append('}').toString();
    }
}

