/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Hash;
import com.google.common.annotations.GoogleInternal;

@GoogleInternal
public final class StringHash {
    public static long hash64(CharSequence val) {
        return StringHash.hash64(val, 0, val.length(), false, 3141592653589793238L);
    }

    public static long hash64(CharSequence val, int pos, int len) {
        return StringHash.hash64(val, pos, len, false, 3141592653589793238L);
    }

    public static long hash64IgnoreCase(CharSequence val) {
        return StringHash.hash64(val, 0, val.length(), true, 3141592653589793238L);
    }

    public static long hash64IgnoreCase(CharSequence val, int pos, int len) {
        return StringHash.hash64(val, pos, len, true, 3141592653589793238L);
    }

    private static long hash64(CharSequence val, int pos, int len, boolean ignoreCase, long seed) {
        long a = -2266404186210603134L;
        long b = -2266404186210603134L;
        long c = seed;
        int keylen = len;
        while (keylen >= 12) {
            a += StringHash.word64At(val, pos, ignoreCase);
            a -= (b += StringHash.word64At(val, pos + 4, ignoreCase));
            a -= (c += StringHash.word64At(val, pos + 8, ignoreCase));
            b -= c;
            b -= (a ^= c >>> 43);
            c -= a;
            c -= (b ^= a << 9);
            a -= b;
            a -= (c ^= b >>> 8);
            b -= c;
            b -= (a ^= c >>> 38);
            c -= a;
            c -= (b ^= a << 23);
            a -= b;
            a -= (c ^= b >>> 5);
            b -= c;
            b -= (a ^= c >>> 35);
            c -= a;
            c -= (b ^= a << 49);
            a -= b;
            a -= (c ^= b >>> 11);
            b -= c;
            b -= (a ^= c >>> 12);
            c -= a;
            c -= (b ^= a << 18);
            c ^= b >>> 22;
            keylen -= 12;
            pos += 12;
        }
        c += (long)len;
        switch (keylen) {
            case 11: {
                c += ((long)(!ignoreCase ? val.charAt(pos + 10) : Character.toLowerCase(val.charAt(pos + 10))) & 0xFFFFL) << 40;
            }
            case 10: {
                c += ((long)(!ignoreCase ? val.charAt(pos + 9) : Character.toLowerCase(val.charAt(pos + 9))) & 0xFFFFL) << 24;
            }
            case 9: {
                c += ((long)(!ignoreCase ? val.charAt(pos + 8) : Character.toLowerCase(val.charAt(pos + 8))) & 0xFFFFL) << 8;
            }
            case 8: {
                b += StringHash.word64At(val, pos + 4, ignoreCase);
                a += StringHash.word64At(val, pos, ignoreCase);
                break;
            }
            case 7: {
                b += ((long)(!ignoreCase ? val.charAt(pos + 6) : Character.toLowerCase(val.charAt(pos + 6))) & 0xFFFFL) << 32;
            }
            case 6: {
                b += ((long)(!ignoreCase ? val.charAt(pos + 5) : Character.toLowerCase(val.charAt(pos + 5))) & 0xFFFFL) << 16;
            }
            case 5: {
                b += (long)(!ignoreCase ? val.charAt(pos + 4) : Character.toLowerCase(val.charAt(pos + 4))) & 0xFFFFL;
            }
            case 4: {
                a += StringHash.word64At(val, pos, ignoreCase);
                break;
            }
            case 3: {
                a += ((long)(!ignoreCase ? val.charAt(pos + 2) : Character.toLowerCase(val.charAt(pos + 2))) & 0xFFFFL) << 32;
            }
            case 2: {
                a += ((long)(!ignoreCase ? val.charAt(pos + 1) : Character.toLowerCase(val.charAt(pos + 1))) & 0xFFFFL) << 16;
            }
            case 1: {
                a += (long)(!ignoreCase ? val.charAt(pos + 0) : Character.toLowerCase(val.charAt(pos + 0))) & 0xFFFFL;
            }
        }
        return Hash.mix64(a, b, c);
    }

    private static long word64At(CharSequence chars, int offset, boolean ignoreCase) {
        if (ignoreCase) {
            return ((long)Character.toLowerCase(chars.charAt(offset + 0)) & 0xFFFFL) + (((long)Character.toLowerCase(chars.charAt(offset + 1)) & 0xFFFFL) << 16) + (((long)Character.toLowerCase(chars.charAt(offset + 2)) & 0xFFFFL) << 32) + (((long)Character.toLowerCase(chars.charAt(offset + 3)) & 0xFFFFL) << 48);
        }
        return ((long)chars.charAt(offset + 0) & 0xFFFFL) + (((long)chars.charAt(offset + 1) & 0xFFFFL) << 16) + (((long)chars.charAt(offset + 2) & 0xFFFFL) << 32) + (((long)chars.charAt(offset + 3) & 0xFFFFL) << 48);
    }

    private StringHash() {
    }
}

