/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.util;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.http.Authorization;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.OAuthAuthorization;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public abstract class ImageUpload {
    public static String DEFAULT_TWITPIC_API_KEY = null;

    public abstract String upload(File var1) throws TwitterException;

    public abstract String upload(String var1, InputStream var2) throws TwitterException;

    public static ImageUpload getTwitpicUploader(Twitter twitter) throws TwitterException {
        Authorization auth = twitter.getAuthorization();
        if (auth instanceof OAuthAuthorization) {
            return ImageUpload.getTwitpicUploader(DEFAULT_TWITPIC_API_KEY, (OAuthAuthorization)auth);
        }
        ImageUpload.ensureBasicEnabled(auth);
        return ImageUpload.getTwitpicUploader((BasicAuthorization)auth);
    }

    public static ImageUpload getTwitpicUploader(BasicAuthorization auth) {
        return new TwitpicBasicAuthUploader(auth);
    }

    public static ImageUpload getTwitpicUploader(String twitpicAPIKey, OAuthAuthorization auth) {
        return new TwitpicOAuthUploader(twitpicAPIKey, auth);
    }

    public static ImageUpload getYFrogUploader(Twitter twitter) throws TwitterException {
        Authorization auth = twitter.getAuthorization();
        if (auth instanceof OAuthAuthorization) {
            return ImageUpload.getYFrogUploader(twitter.getScreenName(), (OAuthAuthorization)auth);
        }
        ImageUpload.ensureBasicEnabled(auth);
        return ImageUpload.getYFrogUploader((BasicAuthorization)auth);
    }

    public static ImageUpload getYFrogUploader(BasicAuthorization auth) {
        return new YFrogBasicAuthUploader(auth);
    }

    public static ImageUpload getYFrogUploader(String userId, OAuthAuthorization auth) {
        return new YFrogOAuthUploader(userId, auth);
    }

    private static void ensureBasicEnabled(Authorization auth) {
        if (!(auth instanceof BasicAuthorization)) {
            throw new IllegalStateException("user ID/password combination not supplied");
        }
    }

    private static class TwitpicBasicAuthUploader
    extends ImageUpload {
        private BasicAuthorization auth;
        private static final String TWITPIC_UPLOAD_URL = "https://twitpic.com/api/upload";

        public TwitpicBasicAuthUploader(BasicAuthorization auth) {
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("username", this.auth.getUserId()), new HttpParameter("password", this.auth.getPassword()), new HttpParameter("media", image)};
            return this.upload(params);
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("username", this.auth.getUserId()), new HttpParameter("password", this.auth.getPassword()), new HttpParameter("media", imageFileName, imageBody)};
            return this.upload(params);
        }

        private String upload(HttpParameter[] params) throws TwitterException {
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(TWITPIC_UPLOAD_URL, params);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("Twitpic image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<rsp stat=\"fail\">")) {
                String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
                throw new TwitterException("Twitpic image upload failed with this error message: " + error, httpResponse);
            }
            if (response.contains("<rsp stat=\"ok\">")) {
                String media = response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
                return media;
            }
            throw new TwitterException("Unknown Twitpic response", httpResponse);
        }
    }

    private static class TwitpicOAuthUploader
    extends ImageUpload {
        private String twitpicAPIKey;
        private OAuthAuthorization auth;
        private static final String TWITPIC_UPLOAD_URL = "https://twitpic.com/api/2/upload.json";
        private static final String TWITTER_VERIFY_CREDENTIALS = "https://api.twitter.com/1/account/verify_credentials.json";

        public TwitpicOAuthUploader(String twitpicAPIKey, OAuthAuthorization auth) {
            if (twitpicAPIKey == null || "".equals(twitpicAPIKey)) {
                throw new IllegalArgumentException("The Twitpic API Key supplied to the OAuth image uploader can't be null or empty");
            }
            this.twitpicAPIKey = twitpicAPIKey;
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("key", this.twitpicAPIKey), new HttpParameter("media", image)};
            return this.upload(params);
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("key", this.twitpicAPIKey), new HttpParameter("media", imageFileName, imageBody)};
            return this.upload(params);
        }

        private String upload(HttpParameter[] params) throws TwitterException {
            String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("X-Auth-Service-Provider", TWITTER_VERIFY_CREDENTIALS);
            headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(TWITPIC_UPLOAD_URL, params, headers);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("Twitpic image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            try {
                JSONObject json = new JSONObject(response);
                if (!json.isNull("url")) {
                    return json.getString("url");
                }
            }
            catch (JSONException e) {
                throw new TwitterException("Invalid Twitpic response: " + response, e);
            }
            throw new TwitterException("Unknown Twitpic response", httpResponse);
        }

        private String generateVerifyCredentialsAuthorizationHeader() {
            List<HttpParameter> oauthSignatureParams = this.auth.generateOAuthSignatureHttpParams("GET", TWITTER_VERIFY_CREDENTIALS);
            return "OAuth realm=\"http://api.twitter.com/\"," + OAuthAuthorization.encodeParameters(oauthSignatureParams, ",", true);
        }
    }

    private static class YFrogBasicAuthUploader
    extends ImageUpload {
        private BasicAuthorization auth;
        private static final String YFROG_UPLOAD_URL = "https://yfrog.com/api/upload";

        public YFrogBasicAuthUploader(BasicAuthorization auth) {
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("username", this.auth.getUserId()), new HttpParameter("password", this.auth.getPassword()), new HttpParameter("media", image)};
            return this.upload(params);
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("username", this.auth.getUserId()), new HttpParameter("password", this.auth.getPassword()), new HttpParameter("media", imageFileName, imageBody)};
            return this.upload(params);
        }

        private String upload(HttpParameter[] params) throws TwitterException {
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(YFROG_UPLOAD_URL, params);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("YFrog image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<rsp stat=\"fail\">")) {
                String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
                throw new TwitterException("YFrog image upload failed with this error message: " + error, httpResponse);
            }
            if (response.contains("<rsp stat=\"ok\">")) {
                String media = response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
                return media;
            }
            throw new TwitterException("Unknown YFrog response", httpResponse);
        }
    }

    private static class YFrogOAuthUploader
    extends ImageUpload {
        private String user;
        private OAuthAuthorization auth;
        private static final String YFROG_UPLOAD_URL = "https://yfrog.com/api/upload";
        private static final String TWITTER_VERIFY_CREDENTIALS = "https://api.twitter.com/1/account/verify_credentials.xml";

        public YFrogOAuthUploader(String user, OAuthAuthorization auth) {
            this.user = user;
            this.auth = auth;
        }

        public String upload(File image) throws TwitterException {
            String signedVerifyCredentialsURL = this.generateSignedVerifyCredentialsURL();
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("auth", "oauth"), new HttpParameter("username", this.user), new HttpParameter("verify_url", signedVerifyCredentialsURL), new HttpParameter("media", image)};
            return this.upload(params);
        }

        public String upload(String imageFileName, InputStream imageBody) throws TwitterException {
            String signedVerifyCredentialsURL = this.generateSignedVerifyCredentialsURL();
            HttpParameter[] params = new HttpParameter[]{new HttpParameter("auth", "oauth"), new HttpParameter("username", this.user), new HttpParameter("verify_url", signedVerifyCredentialsURL), new HttpParameter("media", imageFileName, imageBody)};
            return this.upload(params);
        }

        private String upload(HttpParameter[] params) throws TwitterException {
            HttpClientWrapper client = new HttpClientWrapper();
            HttpResponse httpResponse = client.post(YFROG_UPLOAD_URL, params);
            int statusCode = httpResponse.getStatusCode();
            if (statusCode != 200) {
                throw new TwitterException("YFrog image upload returned invalid status code", httpResponse);
            }
            String response = httpResponse.asString();
            if (response.contains("<rsp stat=\"fail\">")) {
                String error = response.substring(response.indexOf("msg") + 5, response.lastIndexOf("\""));
                throw new TwitterException("YFrog image upload failed with this error message: " + error, httpResponse);
            }
            if (response.contains("<rsp stat=\"ok\">")) {
                String media = response.substring(response.indexOf("<mediaurl>") + "<mediaurl>".length(), response.indexOf("</mediaurl>"));
                return media;
            }
            throw new TwitterException("Unknown YFrog response", httpResponse);
        }

        private String generateSignedVerifyCredentialsURL() {
            List<HttpParameter> oauthSignatureParams = this.auth.generateOAuthSignatureHttpParams("GET", TWITTER_VERIFY_CREDENTIALS);
            return "https://api.twitter.com/1/account/verify_credentials.xml?" + OAuthAuthorization.encodeParameters(oauthSignatureParams);
        }
    }
}

