/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.logging;

import java.security.AccessControlException;
import twitter4j.internal.logging.LoggerFactory;
import twitter4j.internal.logging.StdOutLoggerFactory;

public abstract class Logger {
    private static final LoggerFactory LOGGER_FACTORY;
    private static final String LOGGER_FACTORY_IMPLEMENTATION = "twitter4j.loggerFactory";

    private static LoggerFactory getLoggerFactory(String checkClassName, String implementationClass) {
        LoggerFactory logger = null;
        try {
            Class.forName(checkClassName);
            logger = (LoggerFactory)Class.forName(implementationClass).newInstance();
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return logger;
    }

    public static Logger getLogger(Class clazz) {
        return LOGGER_FACTORY.getLogger(clazz);
    }

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract void debug(String var1);

    public abstract void debug(String var1, String var2);

    public abstract void info(String var1);

    public abstract void info(String var1, String var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, String var2);

    static {
        LoggerFactory loggerFactory = null;
        try {
            String loggerFactoryImpl = System.getProperty(LOGGER_FACTORY_IMPLEMENTATION);
            if (null != loggerFactoryImpl) {
                loggerFactory = (LoggerFactory)Class.forName(loggerFactoryImpl).newInstance();
            }
        }
        catch (NoClassDefFoundError ignore) {
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException ignore) {
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactory("org.slf4j.Logger", "twitter4j.internal.logging.SLF4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactory("org.apache.commons.logging.Log", "twitter4j.internal.logging.CommonsLoggingLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = Logger.getLoggerFactory("org.apache.log4j.Logger", "twitter4j.internal.logging.Log4JLoggerFactory");
        }
        if (null == loggerFactory) {
            loggerFactory = new StdOutLoggerFactory();
        }
        LOGGER_FACTORY = loggerFactory;
        loggerFactory.getLogger(Logger.class).info("Will use " + loggerFactory.getClass() + " as logging factory.");
    }
}

