/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.OAuthSupport;
import twitter4j.http.OAuthToken;
import twitter4j.http.RequestToken;
import twitter4j.internal.http.BASE64Encoder;
import twitter4j.internal.http.HttpClientWrapper;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpRequest;
import twitter4j.internal.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OAuthAuthorization
implements Authorization,
Serializable,
OAuthSupport {
    private final Configuration conf;
    private static transient HttpClientWrapper http;
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final HttpParameter OAUTH_SIGNATURE_METHOD;
    private static final Logger logger;
    static final long serialVersionUID = -4368426677157998618L;
    private String consumerKey = "";
    private String consumerSecret;
    private OAuthToken oauthToken = null;
    private static Random RAND;
    static /* synthetic */ Class class$twitter4j$http$OAuthAuthorization;

    public OAuthAuthorization(Configuration conf) {
        this(conf, conf.getOAuthConsumerKey(), conf.getOAuthConsumerSecret());
    }

    public OAuthAuthorization(Configuration conf, String consumerKey, String consumerSecret) {
        this.conf = conf;
        this.init(consumerKey, consumerSecret);
    }

    public OAuthAuthorization(Configuration conf, String consumerKey, String consumerSecret, AccessToken accessToken) {
        this.conf = conf;
        this.init(consumerKey, consumerSecret, accessToken);
    }

    private void init(String consumerKey, String consumerSecret) {
        http = new HttpClientWrapper(this.conf);
        this.setConsumerKey(consumerKey);
        this.setConsumerSecret(consumerSecret);
    }

    private void init(String consumerKey, String consumerSecret, AccessToken accessToken) {
        this.init(consumerKey, consumerSecret);
        this.setOAuthAccessToken(accessToken);
    }

    @Override
    public String getAuthorizationHeader(HttpRequest req) {
        return this.generateAuthorizationHeader(req.getMethod().name(), req.getURL(), req.getParameters(), this.oauthToken);
    }

    private void ensureTokenIsAvailable() {
        if (null == this.oauthToken) {
            throw new IllegalStateException("No Token available.");
        }
    }

    @Override
    public boolean isEnabled() {
        return null != this.oauthToken && this.oauthToken instanceof AccessToken;
    }

    @Override
    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.getOAuthRequestToken(null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String callbackURL) throws TwitterException {
        HttpParameter[] httpParameterArray;
        if (null != callbackURL) {
            HttpParameter[] httpParameterArray2 = new HttpParameter[1];
            httpParameterArray = httpParameterArray2;
            httpParameterArray2[0] = new HttpParameter("oauth_callback", callbackURL);
        } else {
            httpParameterArray = new HttpParameter[]{};
        }
        HttpParameter[] params = httpParameterArray;
        this.oauthToken = new RequestToken(http.post(this.conf.getOAuthRequestTokenURL(), params, this), this);
        return (RequestToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken() throws TwitterException {
        this.ensureTokenIsAvailable();
        if (this.oauthToken instanceof AccessToken) {
            return (AccessToken)this.oauthToken;
        }
        this.oauthToken = new AccessToken(http.post(this.conf.getOAuthAccessTokenURL(), this));
        return (AccessToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        this.ensureTokenIsAvailable();
        this.oauthToken = new AccessToken(http.post(this.conf.getOAuthAccessTokenURL(), new HttpParameter[]{new HttpParameter("oauth_verifier", oauthVerifier)}, this));
        return (AccessToken)this.oauthToken;
    }

    @Override
    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken();
    }

    @Override
    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken(oauthVerifier);
    }

    public AccessToken getOAuthAccessToken(String screenName, String password) throws TwitterException {
        try {
            this.oauthToken = new AccessToken(http.post(this.conf.getOAuthAccessTokenURL(), new HttpParameter[]{new HttpParameter("x_auth_username", screenName), new HttpParameter("x_auth_password", password), new HttpParameter("x_auth_mode", "client_auth")}, this));
            return (AccessToken)this.oauthToken;
        }
        catch (TwitterException te) {
            throw new TwitterException("The screen name / password combination seems to be invalid.", te, te.getStatusCode());
        }
    }

    @Override
    public void setOAuthAccessToken(AccessToken accessToken) {
        this.oauthToken = accessToken;
    }

    String generateAuthorizationHeader(String method, String url, HttpParameter[] params, String nonce, String timestamp, OAuthToken otoken) {
        if (null == params) {
            params = new HttpParameter[]{};
        }
        ArrayList<HttpParameter> oauthHeaderParams = new ArrayList<HttpParameter>(5);
        oauthHeaderParams.add(new HttpParameter("oauth_consumer_key", this.consumerKey));
        oauthHeaderParams.add(OAUTH_SIGNATURE_METHOD);
        oauthHeaderParams.add(new HttpParameter("oauth_timestamp", timestamp));
        oauthHeaderParams.add(new HttpParameter("oauth_nonce", nonce));
        oauthHeaderParams.add(new HttpParameter("oauth_version", "1.0"));
        if (null != otoken) {
            oauthHeaderParams.add(new HttpParameter("oauth_token", otoken.getToken()));
        }
        ArrayList<HttpParameter> signatureBaseParams = new ArrayList<HttpParameter>(oauthHeaderParams.size() + params.length);
        signatureBaseParams.addAll(oauthHeaderParams);
        if (!HttpParameter.containsFile(params)) {
            signatureBaseParams.addAll(OAuthAuthorization.toParamList(params));
        }
        this.parseGetParameters(url, signatureBaseParams);
        StringBuffer base = new StringBuffer(method).append("&").append(OAuthAuthorization.encode(OAuthAuthorization.constructRequestURL(url))).append("&");
        base.append(OAuthAuthorization.encode(OAuthAuthorization.normalizeRequestParameters(signatureBaseParams)));
        String oauthBaseString = base.toString();
        logger.debug("OAuth base string: ", oauthBaseString);
        String signature = this.generateSignature(oauthBaseString, otoken);
        logger.debug("OAuth signature: ", signature);
        oauthHeaderParams.add(new HttpParameter("oauth_signature", signature));
        return new StringBuffer().append("OAuth ").append(OAuthAuthorization.encodeParameters(oauthHeaderParams, ",", true)).toString();
    }

    private void parseGetParameters(String url, List<HttpParameter> signatureBaseParams) {
        int queryStart = url.indexOf("?");
        if (-1 != queryStart) {
            String[] queryStrs = url.substring(queryStart + 1).split("&");
            try {
                for (String query : queryStrs) {
                    String[] split = query.split("=");
                    if (split.length == 2) {
                        signatureBaseParams.add(new HttpParameter(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8")));
                        continue;
                    }
                    signatureBaseParams.add(new HttpParameter(URLDecoder.decode(split[0], "UTF-8"), ""));
                }
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
        }
    }

    String generateAuthorizationHeader(String method, String url, HttpParameter[] params, OAuthToken token) {
        long timestamp = System.currentTimeMillis() / 1000L;
        long nonce = timestamp + (long)RAND.nextInt();
        return this.generateAuthorizationHeader(method, url, params, String.valueOf(nonce), String.valueOf(timestamp), token);
    }

    public List<HttpParameter> generateOAuthSignatureHttpParams(String method, String url) {
        long timestamp = System.currentTimeMillis() / 1000L;
        long nonce = timestamp + (long)RAND.nextInt();
        ArrayList<HttpParameter> oauthHeaderParams = new ArrayList<HttpParameter>(5);
        oauthHeaderParams.add(new HttpParameter("oauth_consumer_key", this.consumerKey));
        oauthHeaderParams.add(OAUTH_SIGNATURE_METHOD);
        oauthHeaderParams.add(new HttpParameter("oauth_timestamp", timestamp));
        oauthHeaderParams.add(new HttpParameter("oauth_nonce", nonce));
        oauthHeaderParams.add(new HttpParameter("oauth_version", "1.0"));
        if (null != this.oauthToken) {
            oauthHeaderParams.add(new HttpParameter("oauth_token", this.oauthToken.getToken()));
        }
        ArrayList<HttpParameter> signatureBaseParams = new ArrayList<HttpParameter>(oauthHeaderParams.size());
        signatureBaseParams.addAll(oauthHeaderParams);
        this.parseGetParameters(url, signatureBaseParams);
        StringBuffer base = new StringBuffer(method).append("&").append(OAuthAuthorization.encode(OAuthAuthorization.constructRequestURL(url))).append("&");
        base.append(OAuthAuthorization.encode(OAuthAuthorization.normalizeRequestParameters(signatureBaseParams)));
        String oauthBaseString = base.toString();
        String signature = this.generateSignature(oauthBaseString, this.oauthToken);
        oauthHeaderParams.add(new HttpParameter("oauth_signature", signature));
        return oauthHeaderParams;
    }

    String generateSignature(String data, OAuthToken token) {
        byte[] byteHMAC = null;
        try {
            SecretKeySpec spec;
            Mac mac = Mac.getInstance(HMAC_SHA1);
            if (null == token) {
                String oauthSignature = new StringBuffer().append(OAuthAuthorization.encode(this.consumerSecret)).append("&").toString();
                spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
            } else {
                spec = token.getSecretKeySpec();
                if (null == spec) {
                    String oauthSignature = new StringBuffer().append(OAuthAuthorization.encode(this.consumerSecret)).append("&").append(OAuthAuthorization.encode(token.getTokenSecret())).toString();
                    spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
                    token.setSecretKeySpec(spec);
                }
            }
            mac.init(spec);
            byteHMAC = mac.doFinal(data.getBytes());
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException ignore) {
            // empty catch block
        }
        return BASE64Encoder.encode(byteHMAC);
    }

    String generateSignature(String data) {
        return this.generateSignature(data, null);
    }

    public static String normalizeRequestParameters(HttpParameter[] params) {
        return OAuthAuthorization.normalizeRequestParameters(OAuthAuthorization.toParamList(params));
    }

    public static String normalizeRequestParameters(List<HttpParameter> params) {
        Collections.sort(params);
        return OAuthAuthorization.encodeParameters(params);
    }

    public static String normalizeAuthorizationHeaders(List<HttpParameter> params) {
        Collections.sort(params);
        return OAuthAuthorization.encodeParameters(params);
    }

    public static List<HttpParameter> toParamList(HttpParameter[] params) {
        ArrayList<HttpParameter> paramList = new ArrayList<HttpParameter>(params.length);
        paramList.addAll(Arrays.asList(params));
        return paramList;
    }

    public static String encodeParameters(List<HttpParameter> httpParams) {
        return OAuthAuthorization.encodeParameters(httpParams, "&", false);
    }

    public static String encodeParameters(List<HttpParameter> httpParams, String splitter, boolean quot) {
        StringBuffer buf = new StringBuffer();
        for (HttpParameter param : httpParams) {
            if (param.isFile()) continue;
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(OAuthAuthorization.encode(param.getName())).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(OAuthAuthorization.encode(param.getValue()));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    public static String encode(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer(encoded.length());
        for (int i = 0; i < encoded.length(); ++i) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
                continue;
            }
            if (focus == '+') {
                buf.append("%20");
                continue;
            }
            if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
                continue;
            }
            buf.append(focus);
        }
        return buf.toString();
    }

    public static String constructRequestURL(String url) {
        int slashIndex;
        String baseURL;
        int colonIndex;
        int index = url.indexOf("?");
        if (-1 != index) {
            url = url.substring(0, index);
        }
        if (-1 != (colonIndex = (baseURL = url.substring(0, slashIndex = url.indexOf("/", 8)).toLowerCase()).indexOf(":", 8))) {
            if (baseURL.startsWith("http://") && baseURL.endsWith(":80")) {
                baseURL = baseURL.substring(0, colonIndex);
            } else if (baseURL.startsWith("https://") && baseURL.endsWith(":443")) {
                baseURL = baseURL.substring(0, colonIndex);
            }
        }
        url = new StringBuffer().append(baseURL).append(url.substring(slashIndex)).toString();
        return url;
    }

    private void setConsumerKey(String consumerKey) {
        this.consumerKey = null != consumerKey ? consumerKey : "";
    }

    private void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = null != consumerSecret ? consumerSecret : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthSupport)) {
            return false;
        }
        OAuthAuthorization that = (OAuthAuthorization)o;
        if (this.consumerKey != null ? !this.consumerKey.equals(that.consumerKey) : that.consumerKey != null) {
            return false;
        }
        if (this.consumerSecret != null ? !this.consumerSecret.equals(that.consumerSecret) : that.consumerSecret != null) {
            return false;
        }
        return !(this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null);
    }

    public int hashCode() {
        int result = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
        result = 31 * result + (this.consumerSecret != null ? this.consumerSecret.hashCode() : 0);
        result = 31 * result + (this.oauthToken != null ? this.oauthToken.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("OAuthAuthorization{consumerKey='").append(this.consumerKey).append('\'').append(", consumerSecret='******************************************'").append(", oauthToken=").append(this.oauthToken).append('}').toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        OAUTH_SIGNATURE_METHOD = new HttpParameter("oauth_signature_method", "HMAC-SHA1");
        logger = Logger.getLogger(class$twitter4j$http$OAuthAuthorization == null ? (class$twitter4j$http$OAuthAuthorization = OAuthAuthorization.class$("twitter4j.http.OAuthAuthorization")) : class$twitter4j$http$OAuthAuthorization);
        RAND = new Random();
    }
}

