/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import twitter4j.internal.http.HttpParameter;

public final class FilterQuery
implements Serializable {
    private int count;
    private int[] follow;
    private String[] track;
    private double[][] locations;

    public FilterQuery() {
        this.count = 0;
        this.follow = null;
        this.track = null;
        this.locations = null;
    }

    public FilterQuery(int[] follow) {
        this();
        this.count = 0;
        this.follow = follow;
    }

    public FilterQuery(int count, int[] follow) {
        this();
        this.count = count;
        this.follow = follow;
    }

    public FilterQuery(int count, int[] follow, String[] track) {
        this();
        this.count = count;
        this.follow = follow;
        this.track = track;
    }

    public FilterQuery(int count, int[] follow, String[] track, double[][] locations) {
        this.count = count;
        this.follow = follow;
        this.track = track;
        this.locations = locations;
    }

    public FilterQuery count(int count) {
        this.count = count;
        return this;
    }

    public FilterQuery follow(int[] follow) {
        this.follow = follow;
        return this;
    }

    public FilterQuery track(String[] track) {
        this.track = track;
        return this;
    }

    public FilterQuery locations(double[][] locations) {
        this.locations = locations;
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("count", this.count));
        if (null != this.follow && this.follow.length > 0) {
            params.add(new HttpParameter("follow", this.toFollowString(this.follow)));
        }
        if (null != this.track && this.track.length > 0) {
            params.add(new HttpParameter("track", this.toTrackString(this.track)));
        }
        if (null != this.locations && this.locations.length > 0) {
            params.add(new HttpParameter("locations", this.toLocationsString(this.locations)));
        }
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private String toLocationsString(double[][] keywords) {
        StringBuffer buf = new StringBuffer(20 * keywords.length * 2);
        for (int c = 0; c < keywords.length; ++c) {
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(keywords[c][0]);
            buf.append(",");
            buf.append(keywords[c][1]);
        }
        return buf.toString();
    }

    private String toFollowString(int[] follows) {
        StringBuffer buf = new StringBuffer(11 * follows.length);
        int[] arr$ = follows;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int follow = arr$[i$];
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(follow);
        }
        return buf.toString();
    }

    private String toTrackString(String[] keywords) {
        StringBuffer buf = new StringBuffer(20 * keywords.length * 4);
        String[] arr$ = keywords;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String keyword = arr$[i$];
            if (0 != buf.length()) {
                buf.append(",");
            }
            buf.append(keyword);
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterQuery that = (FilterQuery)o;
        if (this.count != that.count) {
            return false;
        }
        if (!Arrays.equals(this.follow, that.follow)) {
            return false;
        }
        return Arrays.equals(this.track, that.track);
    }

    public int hashCode() {
        int result = this.count;
        result = 31 * result + (this.follow != null ? Arrays.hashCode(this.follow) : 0);
        result = 31 * result + (this.track != null ? Arrays.hashCode(this.track) : 0);
        return result;
    }

    public String toString() {
        return "FilterQuery{count=" + this.count + ", follow=" + this.follow + ", track=" + (this.track == null ? null : Arrays.asList(this.track)) + ", locations=" + (this.locations == null ? null : Arrays.asList(this.locations)) + '}';
    }
}

