/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4j.Category;
import twitter4j.CategoryJSONImpl;
import twitter4j.Device;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.IDs;
import twitter4j.IDsJSONImpl;
import twitter4j.Location;
import twitter4j.LocationJSONImpl;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.PlaceJSONImpl;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.QueryResultJSONImpl;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.RateLimitStatusListener;
import twitter4j.Relationship;
import twitter4j.RelationshipJSONImpl;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.SavedSearchJSONImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusUpdate;
import twitter4j.Trends;
import twitter4j.TrendsJSONImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterOAuthSupportBase;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.UserListJSONImpl;
import twitter4j.api.AccountMethods;
import twitter4j.api.BlockMethods;
import twitter4j.api.DirectMessageMethods;
import twitter4j.api.FavoriteMethods;
import twitter4j.api.FriendshipMethods;
import twitter4j.api.GeoMethods;
import twitter4j.api.HelpMethods;
import twitter4j.api.ListMembersMethods;
import twitter4j.api.ListMethods;
import twitter4j.api.ListSubscribersMethods;
import twitter4j.api.LocalTrendsMethods;
import twitter4j.api.NotificationMethods;
import twitter4j.api.SavedSearchesMethods;
import twitter4j.api.SearchMethods;
import twitter4j.api.SocialGraphMethods;
import twitter4j.api.SpamReportingMethods;
import twitter4j.api.StatusMethods;
import twitter4j.api.TimelineMethods;
import twitter4j.api.UserMethods;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationContext;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.AuthorizationFactory;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.NullAuthorization;
import twitter4j.http.OAuthAuthorization;
import twitter4j.http.OAuthSupport;
import twitter4j.http.RequestToken;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.http.HttpResponseEvent;
import twitter4j.internal.org.json.JSONException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter
extends TwitterOAuthSupportBase
implements Serializable,
SearchMethods,
TimelineMethods,
StatusMethods,
UserMethods,
ListMethods,
ListMembersMethods,
ListSubscribersMethods,
DirectMessageMethods,
FriendshipMethods,
SocialGraphMethods,
AccountMethods,
FavoriteMethods,
NotificationMethods,
BlockMethods,
SpamReportingMethods,
SavedSearchesMethods,
LocalTrendsMethods,
GeoMethods,
HelpMethods {
    private static final long serialVersionUID = -1486360080128882436L;
    private transient String screenName = null;
    private transient int id = 0;

    Twitter(Configuration conf) {
        super(conf);
    }

    public Twitter() {
        super(ConfigurationContext.getInstance());
    }

    public Twitter(String screenName, String password) {
        super(ConfigurationContext.getInstance(), screenName, password);
    }

    Twitter(Configuration conf, String screenName, String password) {
        super(conf, screenName, password);
    }

    Twitter(Configuration conf, Authorization auth) {
        super(conf, auth);
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter[] params2) {
        if (null != params1 && null != params2) {
            HttpParameter[] params = new HttpParameter[params1.length + params2.length];
            System.arraycopy(params1, 0, params, 0, params1.length);
            System.arraycopy(params2, 0, params, params1.length, params2.length);
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (null != params1) {
            return params1;
        }
        return params2;
    }

    public String getScreenName() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (null == this.screenName) {
            if (this.auth instanceof BasicAuthorization) {
                this.screenName = ((BasicAuthorization)this.auth).getUserId();
                if (-1 != this.screenName.indexOf("@")) {
                    this.screenName = null;
                }
            }
            if (null == this.screenName) {
                this.verifyCredentials();
            }
        }
        return this.screenName;
    }

    public int getId() throws TwitterException, IllegalStateException {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Neither user ID/password combination nor OAuth consumer key/secret combination supplied");
        }
        if (0 == this.id) {
            this.verifyCredentials();
        }
        return this.id;
    }

    @Override
    public QueryResult search(Query query) throws TwitterException {
        try {
            return new QueryResultJSONImpl(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("search.json").toString(), query.asHttpParameterArray(), null));
        }
        catch (TwitterException te) {
            if (404 == te.getStatusCode()) {
                return new QueryResultJSONImpl(query);
            }
            throw te;
        }
    }

    @Override
    public Trends getTrends() throws TwitterException {
        return TrendsJSONImpl.createTrends(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends.json").toString()));
    }

    @Override
    public Trends getCurrentTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/current.json").toString())).get(0);
    }

    @Override
    public Trends getCurrentTrends(boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/current.json").append(excludeHashTags ? "?exclude=hashtags" : "").toString())).get(0);
    }

    @Override
    public List<Trends> getDailyTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/daily.json").toString()));
    }

    @Override
    public List<Trends> getDailyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/daily.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString()));
    }

    private String toDateStr(Date date) {
        if (null == date) {
            date = new Date();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    @Override
    public List<Trends> getWeeklyTrends() throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/weekly.json").toString()));
    }

    @Override
    public List<Trends> getWeeklyTrends(Date date, boolean excludeHashTags) throws TwitterException {
        return TrendsJSONImpl.createTrendsList(this.http.get(new StringBuffer().append(this.conf.getSearchBaseURL()).append("trends/weekly.json?date=").append(this.toDateStr(date)).append(excludeHashTags ? "&exclude=hashtags" : "").toString()));
    }

    @Override
    public ResponseList<Status> getPublicTimeline() throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/public_timeline.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getHomeTimeline() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/home_timeline.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getHomeTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/home_timeline.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public ResponseList<Status> getFriendsTimeline() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends_timeline.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getFriendsTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends_timeline.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName)}, paging.asPostParameterArray()), this.auth));
    }

    @Override
    public ResponseList<Status> getUserTimeline(int userId, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId)}, paging.asPostParameterArray()), this.auth));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName) throws TwitterException {
        return this.getUserTimeline(screenName, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(int userId) throws TwitterException {
        return this.getUserTimeline(userId, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline() throws TwitterException {
        return this.getUserTimeline(new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/user_timeline.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public ResponseList<Status> getMentions() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/mentions.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getMentions(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/mentions.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedByMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_me.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedByMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_by_me.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedToMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_me.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetedToMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweeted_to_me.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets_of_me.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets_of_me.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public Status showStatus(long id) throws TwitterException {
        return new StatusJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/show/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public Status updateStatus(String status) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), new HttpParameter("source", this.conf.getSource())}, this.auth));
    }

    @Override
    public Status updateStatus(String status, GeoLocation location) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude()), new HttpParameter("source", this.conf.getSource())}, this.auth));
    }

    @Override
    public Status updateStatus(String status, long inReplyToStatusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), new HttpParameter("in_reply_to_status_id", inReplyToStatusId), new HttpParameter("source", this.conf.getSource())}, this.auth));
    }

    @Override
    public Status updateStatus(String status, long inReplyToStatusId, GeoLocation location) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), new HttpParameter[]{new HttpParameter("status", status), new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude()), new HttpParameter("in_reply_to_status_id", inReplyToStatusId), new HttpParameter("source", this.conf.getSource())}, this.auth));
    }

    @Override
    public Status updateStatus(StatusUpdate latestStatus) throws TwitterException {
        this.ensureAuthorizationEnabled();
        HttpParameter[] array = latestStatus.asHttpParameterArray();
        HttpParameter[] combined = new HttpParameter[array.length + 1];
        System.arraycopy(array, 0, combined, 0, array.length);
        combined[combined.length - 1] = new HttpParameter("source", this.conf.getSource());
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/update.json").toString(), combined, this.auth));
    }

    @Override
    public Status destroyStatus(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/destroy/").append(statusId).append(".json").toString(), this.auth));
    }

    @Override
    public Status retweetStatus(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweet/").append(statusId).append(".json").toString(), new HttpParameter[]{new HttpParameter("source", this.conf.getSource())}, this.auth));
    }

    @Override
    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/retweets/").append(statusId).append(".json").toString(), this.auth));
    }

    @Override
    public User showUser(String screenName) throws TwitterException {
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/show.json?screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User showUser(int userId) throws TwitterException {
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/show.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public ResponseList<User> lookupUsers(String[] screenNames) throws TwitterException {
        this.ensureAuthorizationEnabled();
        StringBuffer buf = new StringBuffer(screenNames.length * 8);
        for (String screenName : screenNames) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(screenName);
        }
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/lookup.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", buf.toString())}, this.auth));
    }

    @Override
    public ResponseList<User> lookupUsers(int[] ids) throws TwitterException {
        this.ensureAuthorizationEnabled();
        StringBuffer buf = new StringBuffer(ids.length * 8);
        for (int id : ids) {
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(id);
        }
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/lookup.json").toString(), new HttpParameter[]{new HttpParameter("user_id", buf.toString())}, this.auth));
    }

    @Override
    public ResponseList<User> searchUsers(String query, int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/search.json").toString(), new HttpParameter[]{new HttpParameter("q", query), new HttpParameter("per_page", 20), new HttpParameter("page", page)}, this.auth));
    }

    @Override
    public ResponseList<Category> getSuggestedUserCategories() throws TwitterException {
        return CategoryJSONImpl.createCategoriesList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions.json").toString(), this.auth));
    }

    @Override
    public ResponseList<User> getUserSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res = this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("users/suggestions/").append(categorySlug).append(".json").toString(), this.auth);
        try {
            return UserJSONImpl.createUserList(res.asJSONObject().getJSONArray("users"), res);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses() throws TwitterException {
        return this.getFriendsStatuses(-1L);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(String screenName) throws TwitterException {
        return this.getFriendsStatuses(screenName, -1L);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(int userId) throws TwitterException {
        return this.getFriendsStatuses(userId, -1L);
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(String screenName, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFriendsStatuses(int userId, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/friends.json?user_id=").append(userId).append("&cursor=").append(cursor).toString(), null, this.auth));
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses() throws TwitterException {
        return this.getFollowersStatuses(-1L);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(String screenName) throws TwitterException {
        return this.getFollowersStatuses(screenName, -1L);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(int userId) throws TwitterException {
        return this.getFollowersStatuses(userId, -1L);
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(String screenName, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getFollowersStatuses(int userId, long cursor) throws TwitterException {
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("statuses/followers.json?user_id=").append(userId).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList createUserList(String listName, boolean isPublicList, String description) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(new HttpParameter("name", listName));
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (description != null) {
            httpParams.add(new HttpParameter("description", description));
        }
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/lists.json").toString(), httpParams.toArray(new HttpParameter[httpParams.size()]), this.auth));
    }

    @Override
    public UserList updateUserList(int listId, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        if (newListName != null) {
            httpParams.add(new HttpParameter("name", newListName));
        }
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (newDescription != null) {
            httpParams.add(new HttpParameter("description", newDescription));
        }
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/lists/").append(listId).append(".json").toString(), httpParams.toArray(new HttpParameter[httpParams.size()]), this.auth));
    }

    @Override
    public PagableResponseList<UserList> getUserLists(String listOwnerScreenName, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserListJSONImpl.createUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList showUserList(String listOwnerScreenName, int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public UserList destroyUserList(int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.delete(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/lists/").append(listId).append(".json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(String listOwnerScreenName, int id, Paging paging) throws TwitterException {
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists/").append(id).append("/statuses.json").toString(), paging.asPostParameterArray(Paging.SMCP, "per_page"), this.auth));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listOwnerScreenName, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserListJSONImpl.createUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists/memberships.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String listOwnerScreenName, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserListJSONImpl.createUserListList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/lists/subscriptions.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String listOwnerScreenName, int listId, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/members.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList addUserListMember(int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/").append(listId).append("/members.json?id=").append(userId).toString(), this.auth));
    }

    @Override
    public UserList deleteUserListMember(int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.delete(new StringBuffer().append(this.conf.getRestBaseURL()).append(this.getScreenName()).append("/").append(listId).append("/members.json?id=").append(userId).toString(), this.auth));
    }

    @Override
    public User checkUserListMembership(String listOwnerScreenName, int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/members/").append(userId).append(".json").toString(), this.auth));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String listOwnerScreenName, int listId, long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createPagableUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public UserList subscribeUserList(String listOwnerScreenName, int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers.json").toString(), this.auth));
    }

    @Override
    public UserList unsubscribeUserList(String listOwnerScreenName, int listId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserListJSONImpl(this.http.delete(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers.json?id=").append(this.verifyCredentials().getId()).toString(), this.auth));
    }

    @Override
    public User checkUserListSubscription(String listOwnerScreenName, int listId, int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append(listOwnerScreenName).append("/").append(listId).append("/subscribers/").append(userId).append(".json").toString(), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages.json").toString(), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/sent.json").toString(), this.auth));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages(Paging paging) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return DirectMessageJSONImpl.createDirectMessageList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/sent.json").toString(), paging.asPostParameterArray(), this.auth));
    }

    @Override
    public DirectMessage sendDirectMessage(String screenName, String text) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/new.json").toString(), new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("text", text)}, this.auth));
    }

    @Override
    public DirectMessage sendDirectMessage(int userId, String text) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/new.json").toString(), new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("text", text)}, this.auth));
    }

    @Override
    public DirectMessage destroyDirectMessage(int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new DirectMessageJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("direct_messages/destroy/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public User createFriendship(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User createFriendship(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User createFriendship(String screenName, boolean follow) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?screen_name=").append(screenName).append("&follow=").append(follow).toString(), this.auth));
    }

    @Override
    public User createFriendship(int userId, boolean follow) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/create.json?user_id=").append(userId).append("&follow=").append(follow).toString(), this.auth));
    }

    @Override
    public User destroyFriendship(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/destroy.json?screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User destroyFriendship(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/destroy.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public boolean existsFriendship(String userA, String userB) throws TwitterException {
        return -1 != this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/exists.json").toString(), HttpParameter.getParameterArray("user_a", userA, "user_b", userB), this.auth).asString().indexOf("true");
    }

    @Override
    public Relationship showFriendship(String sourceScreenName, String targetScreenName) throws TwitterException {
        return new RelationshipJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/show.json").toString(), HttpParameter.getParameterArray("source_screen_name", sourceScreenName, "target_screen_name", targetScreenName), this.auth));
    }

    @Override
    public Relationship showFriendship(int sourceId, int targetId) throws TwitterException {
        return new RelationshipJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/show.json").toString(), HttpParameter.getParameterArray("source_id", sourceId, "target_id", targetId), this.auth));
    }

    @Override
    public IDs getIncomingFriendships(long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/incoming.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getOutgoingFriendships(long cursor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friendships/outgoing.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFriendsIDs() throws TwitterException {
        return this.getFriendsIDs(-1L);
    }

    @Override
    public IDs getFriendsIDs(long cursor) throws TwitterException {
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFriendsIDs(int userId) throws TwitterException {
        return this.getFriendsIDs(userId, -1L);
    }

    @Override
    public IDs getFriendsIDs(int userId, long cursor) throws TwitterException {
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?user_id=").append(userId).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFriendsIDs(String screenName) throws TwitterException {
        return this.getFriendsIDs(screenName, -1L);
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor) throws TwitterException {
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("friends/ids.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFollowersIDs() throws TwitterException {
        return this.getFollowersIDs(-1L);
    }

    @Override
    public IDs getFollowersIDs(long cursor) throws TwitterException {
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFollowersIDs(int userId) throws TwitterException {
        return this.getFollowersIDs(userId, -1L);
    }

    @Override
    public IDs getFollowersIDs(int userId, long cursor) throws TwitterException {
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?user_id=").append(userId).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public IDs getFollowersIDs(String screenName) throws TwitterException {
        return this.getFollowersIDs(screenName, -1L);
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor) throws TwitterException {
        return IDsJSONImpl.getFriendsIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("followers/ids.json?screen_name=").append(screenName).append("&cursor=").append(cursor).toString(), this.auth));
    }

    @Override
    public User verifyCredentials() throws TwitterException {
        UserJSONImpl user = new UserJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/verify_credentials.json").toString(), this.auth));
        this.screenName = user.getScreenName();
        this.id = user.getId();
        return user;
    }

    @Override
    public User updateProfile(String name, String email, String url, String location, String description) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(5);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "email", email);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile.json").toString(), profile.toArray(new HttpParameter[profile.size()]), this.auth));
    }

    @Override
    public RateLimitStatus getRateLimitStatus() throws TwitterException {
        return RateLimitStatusJSONImpl.createFromJSONResponse(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/rate_limit_status.json").toString(), this.auth));
    }

    @Override
    public User updateDeliveryDevice(Device device) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_delivery_device.json").toString(), new HttpParameter[]{new HttpParameter("device", device.getName())}, this.auth));
    }

    @Override
    public User updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        this.ensureAuthorizationEnabled();
        ArrayList<HttpParameter> colors = new ArrayList<HttpParameter>(5);
        this.addParameterToList(colors, "profile_background_color", profileBackgroundColor);
        this.addParameterToList(colors, "profile_text_color", profileTextColor);
        this.addParameterToList(colors, "profile_link_color", profileLinkColor);
        this.addParameterToList(colors, "profile_sidebar_fill_color", profileSidebarFillColor);
        this.addParameterToList(colors, "profile_sidebar_border_color", profileSidebarBorderColor);
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_colors.json").toString(), colors.toArray(new HttpParameter[colors.size()]), this.auth));
    }

    private void addParameterToList(List<HttpParameter> colors, String paramName, String color) {
        if (null != color) {
            colors.add(new HttpParameter(paramName, color));
        }
    }

    @Override
    public User updateProfileImage(File image) throws TwitterException {
        this.checkFileValidity(image);
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_image.json").toString(), new HttpParameter[]{new HttpParameter("image", image)}, this.auth));
    }

    @Override
    public User updateProfileBackgroundImage(File image, boolean tile) throws TwitterException {
        this.ensureAuthorizationEnabled();
        this.checkFileValidity(image);
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("account/update_profile_background_image.json").toString(), new HttpParameter[]{new HttpParameter("image", image), new HttpParameter("tile", tile)}, this.auth));
    }

    private void checkFileValidity(File image) throws TwitterException {
        if (!image.exists()) {
            throw new TwitterException(new FileNotFoundException(new StringBuffer().append(image).append(" is not found.").toString()));
        }
        if (!image.isFile()) {
            throw new TwitterException(new IOException(new StringBuffer().append(image).append(" is not a file.").toString()));
        }
    }

    @Override
    public ResponseList<Status> getFavorites() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getFavorites(int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites.json").toString(), new HttpParameter[]{new HttpParameter("page", page)}, this.auth));
    }

    @Override
    public ResponseList<Status> getFavorites(String id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public ResponseList<Status> getFavorites(String id, int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return StatusJSONImpl.createStatusList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/").append(id).append(".json").toString(), HttpParameter.getParameterArray("page", page), this.auth));
    }

    @Override
    public Status createFavorite(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/create/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public Status destroyFavorite(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new StatusJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("favorites/destroy/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public User enableNotification(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/follow.json?screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User enableNotification(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/follow.json?userId=").append(userId).toString(), this.auth));
    }

    @Override
    public User disableNotification(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/leave.json?screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User disableNotification(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("notifications/leave.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User createBlock(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/create.json?screen_name=").append(screenName).toString(), this.auth));
    }

    @Override
    public User createBlock(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/create.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User destroyBlock(String screen_name) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/destroy.json?screen_name=").append(screen_name).toString(), this.auth));
    }

    @Override
    public User destroyBlock(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/destroy.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public boolean existsBlock(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return -1 == this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/exists.json?screen_name=").append(screenName).toString(), this.auth).asString().indexOf("<error>You are not blocking this user.</error>");
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return false;
            }
            throw te;
        }
    }

    @Override
    public boolean existsBlock(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        try {
            return -1 == this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/exists.json?user_id=").append(userId).toString(), this.auth).asString().indexOf("<error>You are not blocking this user.</error>");
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return false;
            }
            throw te;
        }
    }

    @Override
    public ResponseList<User> getBlockingUsers() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking.json").toString(), this.auth));
    }

    @Override
    public ResponseList<User> getBlockingUsers(int page) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return UserJSONImpl.createUserList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking.json?page=").append(page).toString(), this.auth));
    }

    @Override
    public IDs getBlockingUsersIDs() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return IDsJSONImpl.getBlockIDs(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("blocks/blocking/ids.json").toString(), this.auth));
    }

    @Override
    public User reportSpam(int userId) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("report_spam.json?user_id=").append(userId).toString(), this.auth));
    }

    @Override
    public User reportSpam(String screenName) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new UserJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("report_spam.json?screenName=").append(screenName).toString(), this.auth));
    }

    @Override
    public List<SavedSearch> getSavedSearches() throws TwitterException {
        this.ensureAuthorizationEnabled();
        return SavedSearchJSONImpl.createSavedSearchList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches.json").toString(), this.auth));
    }

    @Override
    public SavedSearch showSavedSearch(int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/show/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public SavedSearch createSavedSearch(String query) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/create.json").toString(), new HttpParameter[]{new HttpParameter("query", query)}, this.auth));
    }

    @Override
    public SavedSearch destroySavedSearch(int id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        return new SavedSearchJSONImpl(this.http.post(new StringBuffer().append(this.conf.getRestBaseURL()).append("saved_searches/destroy/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public ResponseList<Location> getAvailableTrends() throws TwitterException {
        return LocationJSONImpl.createLocationList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/available.json").toString(), this.auth));
    }

    @Override
    public ResponseList<Location> getAvailableTrends(GeoLocation location) throws TwitterException {
        return LocationJSONImpl.createLocationList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/available.json").toString(), new HttpParameter[]{new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude())}, this.auth));
    }

    @Override
    public Trends getLocationTrends(int woeid) throws TwitterException {
        try {
            HttpResponse res = this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("trends/").append(woeid).append(".json").toString(), this.auth);
            return TrendsJSONImpl.createTrends(res.asJSONArray().getJSONObject(0), res);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public ResponseList<Place> getNearbyPlaces(GeoQuery query) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/nearby_places.json").toString(), query.asHttpParameterArray(), this.auth));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseList<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public ResponseList<Place> reverseGeoCode(GeoQuery query) throws TwitterException {
        try {
            return PlaceJSONImpl.createPlaceList(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/reverse_geocode.json").toString(), query.asHttpParameterArray(), this.auth));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return new ResponseList<Place>(0, null);
            }
            throw te;
        }
    }

    @Override
    public Place getGeoDetails(String id) throws TwitterException {
        return new PlaceJSONImpl(this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("geo/id/").append(id).append(".json").toString(), this.auth));
    }

    @Override
    public boolean test() throws TwitterException {
        return -1 != this.http.get(new StringBuffer().append(this.conf.getRestBaseURL()).append("help/test.json").toString()).asString().indexOf("ok");
    }

    private OAuthSupport getOAuth() {
        if (!(this.auth instanceof OAuthSupport)) {
            throw new IllegalStateException("OAuth consumer key/secret combination not supplied");
        }
        return (OAuthSupport)((Object)this.auth);
    }

    @Override
    public synchronized void setOAuthConsumer(String consumerKey, String consumerSecret) {
        if (this.auth instanceof NullAuthorization) {
            this.auth = new OAuthAuthorization(this.conf, consumerKey, consumerSecret);
        } else {
            if (this.auth instanceof BasicAuthorization) {
                throw new IllegalStateException("Basic authenticated instance.");
            }
            if (this.auth instanceof OAuthAuthorization) {
                throw new IllegalStateException("consumer key/secret pair already set.");
            }
        }
    }

    @Override
    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.getOAuthRequestToken(null);
    }

    @Override
    public RequestToken getOAuthRequestToken(String callbackUrl) throws TwitterException {
        return this.getOAuth().getOAuthRequestToken(callbackUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized AccessToken getOAuthAccessToken() throws TwitterException {
        AccessToken oauthAccessToken;
        Authorization auth = this.getAuthorization();
        if (auth instanceof BasicAuthorization) {
            BasicAuthorization basicAuth = (BasicAuthorization)auth;
            auth = AuthorizationFactory.getInstance(this.conf, true);
            if (!(auth instanceof OAuthAuthorization)) throw new IllegalStateException("consumer key / secret combination not supplied.");
            this.auth = auth;
            OAuthAuthorization oauthAuth = (OAuthAuthorization)auth;
            oauthAccessToken = oauthAuth.getOAuthAccessToken(basicAuth.getUserId(), basicAuth.getPassword());
        } else {
            oauthAccessToken = this.getOAuth().getOAuthAccessToken();
        }
        this.screenName = oauthAccessToken.getScreenName();
        this.id = oauthAccessToken.getUserId();
        return oauthAccessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        AccessToken oauthAccessToken = this.getOAuth().getOAuthAccessToken(oauthVerifier);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        OAuthSupport oauth = this.getOAuth();
        AccessToken oauthAccessToken = oauth.getOAuthAccessToken(requestToken);
        this.screenName = oauthAccessToken.getScreenName();
        return oauthAccessToken;
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(requestToken, oauthVerifier);
    }

    @Override
    public synchronized void setOAuthAccessToken(AccessToken accessToken) {
        this.getOAuth().setOAuthAccessToken(accessToken);
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret) throws TwitterException {
        return this.getOAuth().getOAuthAccessToken(new RequestToken(token, tokenSecret));
    }

    @Override
    public synchronized AccessToken getOAuthAccessToken(String token, String tokenSecret, String pin) throws TwitterException {
        return this.getOAuthAccessToken(new RequestToken(token, tokenSecret), pin);
    }

    @Override
    public void setOAuthAccessToken(String token, String tokenSecret) {
        this.getOAuth().setOAuthAccessToken(new AccessToken(token, tokenSecret));
    }

    @Override
    public boolean isOAuthEnabled() {
        return this.auth instanceof OAuthAuthorization && this.auth.isEnabled();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("Twitter{auth='").append(this.auth).append('\'').append('}').toString();
    }

    @Override
    public /* synthetic */ void httpResponseReceived(HttpResponseEvent x0) {
        super.httpResponseReceived(x0);
    }

    @Override
    public /* synthetic */ int hashCode() {
        return super.hashCode();
    }

    @Override
    public /* synthetic */ boolean equals(Object x0) {
        return super.equals(x0);
    }

    @Override
    public /* synthetic */ void setRateLimitStatusListener(RateLimitStatusListener x0) {
        super.setRateLimitStatusListener(x0);
    }
}

