/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import twitter4j.GeoLocation;
import twitter4j.ParseUtil;
import twitter4j.Place;
import twitter4j.PlaceJSONImpl;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StatusJSONImpl
extends TwitterResponseImpl
implements Status,
Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private int inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private GeoLocation geoLocation = null;
    private Place place = null;
    private String[] contributors;
    private Status retweetedStatus;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    StatusJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
        this.init(res.asJSONObject());
    }

    StatusJSONImpl(JSONObject json) throws TwitterException, JSONException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = ParseUtil.getLong("id", json);
        this.text = ParseUtil.getUnescapedString("text", json);
        this.source = ParseUtil.getUnescapedString("source", json);
        this.createdAt = ParseUtil.getDate("created_at", json);
        this.isTruncated = ParseUtil.getBoolean("truncated", json);
        this.inReplyToStatusId = ParseUtil.getLong("in_reply_to_status_id", json);
        this.inReplyToUserId = ParseUtil.getInt("in_reply_to_user_id", json);
        this.isFavorited = ParseUtil.getBoolean("favorited", json);
        this.inReplyToScreenName = ParseUtil.getUnescapedString("in_reply_to_screen_name", json);
        try {
            if (!json.isNull("user")) {
                this.user = new UserJSONImpl(json.getJSONObject("user"));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        this.geoLocation = GeoLocation.getInstance(json);
        if (!json.isNull("place")) {
            try {
                this.place = new PlaceJSONImpl(json.getJSONObject("place"), null);
            }
            catch (JSONException ignore) {
                // empty catch block
            }
        }
        if (!json.isNull("retweeted_status")) {
            try {
                this.retweetedStatus = new StatusJSONImpl(json.getJSONObject("retweeted_status"));
            }
            catch (JSONException ignore) {
                // empty catch block
            }
        }
        if (!json.isNull("contributors")) {
            try {
                JSONArray contributorsArray = json.getJSONArray("contributors");
                this.contributors = new String[contributorsArray.length()];
                for (int i = 0; i < contributorsArray.length(); ++i) {
                    this.contributors[i] = contributorsArray.getString(i);
                }
            }
            catch (JSONException jSONException) {}
        } else {
            this.contributors = null;
        }
    }

    @Override
    public int compareTo(Status that) {
        long delta = this.id - that.getId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isTruncated() {
        return this.isTruncated;
    }

    @Override
    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    @Override
    public int getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    @Override
    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    @Override
    public GeoLocation getGeoLocation() {
        return this.geoLocation;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public String[] getContributors() {
        return this.contributors;
    }

    @Override
    public boolean isFavorited() {
        return this.isFavorited;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public boolean isRetweet() {
        return null != this.retweetedStatus;
    }

    @Override
    public Status getRetweetedStatus() {
        return this.retweetedStatus;
    }

    static ResponseList<Status> createStatusList(HttpResponse res) throws TwitterException {
        try {
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseList<Status> statuses = new ResponseList<Status>(size, res);
            for (int i = 0; i < size; ++i) {
                statuses.add(new StatusJSONImpl(list.getJSONObject(i)));
            }
            return statuses;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).getId() == this.id;
    }

    public String toString() {
        return new StringBuffer().append("StatusJSONImpl{createdAt=").append(this.createdAt).append(", id=").append(this.id).append(", text='").append(this.text).append('\'').append(", source='").append(this.source).append('\'').append(", isTruncated=").append(this.isTruncated).append(", inReplyToStatusId=").append(this.inReplyToStatusId).append(", inReplyToUserId=").append(this.inReplyToUserId).append(", isFavorited=").append(this.isFavorited).append(", inReplyToScreenName='").append(this.inReplyToScreenName).append('\'').append(", geoLocation=").append(this.geoLocation).append(", place=").append(this.place).append(", contributors=").append(this.contributors == null ? null : Arrays.asList(this.contributors)).append(", retweetedStatus=").append(this.retweetedStatus).append(", user=").append(this.user).append('}').toString();
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Status)x0);
    }
}

