/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import twitter4j.GeoLocation;
import twitter4j.internal.http.HttpParameter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Query
implements Serializable {
    private String query = null;
    private String lang = null;
    private String locale = null;
    private long maxId = -1L;
    private int rpp = -1;
    private int page = -1;
    private String since = null;
    private long sinceId = -1L;
    private String geocode = null;
    private String until = null;
    private static final long serialVersionUID = -8108425822233599808L;
    public static final String MILES = "mi";
    public static final String KILOMETERS = "km";

    public Query() {
    }

    public Query(String query) {
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Query query(String query) {
        this.setQuery(query);
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Query lang(String lang) {
        this.setLang(lang);
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Query locale(String locale) {
        this.setLocale(locale);
        return this;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public Query maxId(long maxId) {
        this.setMaxId(maxId);
        return this;
    }

    public int getRpp() {
        return this.rpp;
    }

    public void setRpp(int rpp) {
        this.rpp = rpp;
    }

    public Query rpp(int rpp) {
        this.setRpp(rpp);
        return this;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public Query page(int page) {
        this.setPage(page);
        return this;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public Query since(String since) {
        this.setSince(since);
        return this;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public Query sinceId(long sinceId) {
        this.setSinceId(sinceId);
        return this;
    }

    public String getGeocode() {
        return this.geocode;
    }

    public void setGeoCode(GeoLocation location, double radius, String unit) {
        this.geocode = new StringBuffer().append(location.getLatitude()).append(",").append(location.getLongitude()).append(",").append(radius).append(unit).toString();
    }

    public Query geoCode(GeoLocation location, double radius, String unit) {
        this.setGeoCode(location, radius, unit);
        return this;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until) {
        this.until = until;
    }

    public Query until(String until) {
        this.setUntil(until);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        this.appendParameter("q", this.query, params);
        this.appendParameter("lang", this.lang, params);
        this.appendParameter("locale", this.locale, params);
        this.appendParameter("max_id", this.maxId, params);
        this.appendParameter("rpp", this.rpp, params);
        this.appendParameter("page", this.page, params);
        this.appendParameter("since", this.since, params);
        this.appendParameter("since_id", this.sinceId, params);
        this.appendParameter("geocode", this.geocode, params);
        this.appendParameter("until", this.until, params);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<HttpParameter> params) {
        if (null != value) {
            params.add(new HttpParameter(name, value));
        }
    }

    private void appendParameter(String name, long value, List<HttpParameter> params) {
        if (0L <= value) {
            params.add(new HttpParameter(name, String.valueOf(value)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (this.maxId != query1.maxId) {
            return false;
        }
        if (this.page != query1.page) {
            return false;
        }
        if (this.rpp != query1.rpp) {
            return false;
        }
        if (this.sinceId != query1.sinceId) {
            return false;
        }
        if (this.geocode != null ? !this.geocode.equals(query1.geocode) : query1.geocode != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(query1.lang) : query1.lang != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(query1.locale) : query1.locale != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(query1.query) : query1.query != null) {
            return false;
        }
        if (this.since != null ? !this.since.equals(query1.since) : query1.since != null) {
            return false;
        }
        return !(this.until != null ? !this.until.equals(query1.until) : query1.until != null);
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (int)(this.maxId ^ this.maxId >>> 32);
        result = 31 * result + this.rpp;
        result = 31 * result + this.page;
        result = 31 * result + (this.since != null ? this.since.hashCode() : 0);
        result = 31 * result + (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (this.geocode != null ? this.geocode.hashCode() : 0);
        result = 31 * result + (this.until != null ? this.until.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append("Query{query='").append(this.query).append('\'').append(", lang='").append(this.lang).append('\'').append(", locale='").append(this.locale).append('\'').append(", maxId=").append(this.maxId).append(", rpp=").append(this.rpp).append(", page=").append(this.page).append(", since='").append(this.since).append('\'').append(", sinceId=").append(this.sinceId).append(", geocode='").append(this.geocode).append('\'').append(", until='").append(this.until).append('\'').append('}').toString();
    }
}

