/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;

public class RpcRequestBuilder {
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String MODULE_BASE_HEADER = "X-GWT-Module-Base";
    public static final String STRONG_NAME_HEADER = "X-GWT-Permutation";
    private RequestBuilder builder;

    public final RpcRequestBuilder create(String serviceEntryPoint) {
        this.builder = this.doCreate(serviceEntryPoint);
        assert (this.builder != null) : "doCreate failed to return a RequestBuilder";
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RequestBuilder finish() {
        try {
            assert (this.builder != null) : "Call create() first";
            this.doFinish(this.builder);
            RequestBuilder requestBuilder = this.builder;
            return requestBuilder;
        }
        finally {
            this.builder = null;
        }
    }

    public final RpcRequestBuilder setCallback(RequestCallback callback) {
        assert (this.builder != null) : "Call create() first";
        this.doSetCallback(this.builder, callback);
        return this;
    }

    public final RpcRequestBuilder setContentType(String contentType) {
        assert (this.builder != null) : "Call create() first";
        this.doSetContentType(this.builder, contentType);
        return this;
    }

    public final RpcRequestBuilder setRequestData(String data) {
        assert (this.builder != null) : "Call create() first";
        this.doSetRequestData(this.builder, data);
        return this;
    }

    public final RpcRequestBuilder setRequestId(int id) {
        assert (this.builder != null) : "Call create() first";
        this.doSetRequestId(this.builder, id);
        return this;
    }

    protected RequestBuilder doCreate(String serviceEntryPoint) {
        return new RequestBuilder(RequestBuilder.POST, serviceEntryPoint);
    }

    protected void doFinish(RequestBuilder rb) {
        rb.setHeader(STRONG_NAME_HEADER, GWT.getPermutationStrongName());
        rb.setHeader(MODULE_BASE_HEADER, GWT.getModuleBaseURL());
    }

    protected void doSetCallback(RequestBuilder rb, RequestCallback callback) {
        rb.setCallback(callback);
    }

    protected void doSetContentType(RequestBuilder rb, String contentType) {
        rb.setHeader(CONTENT_TYPE_HEADER, contentType);
    }

    protected void doSetRequestData(RequestBuilder rb, String data) {
        rb.setRequestData(data);
    }

    protected void doSetRequestId(RequestBuilder rb, int id) {
    }
}

