/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

public final class TwitterException
extends Exception {
    private int statusCode = -1;
    private int retryAfter;
    private static final long serialVersionUID = -2623309261327598087L;

    public TwitterException(String msg) {
        super(msg);
    }

    public TwitterException(Exception cause) {
        super(cause);
    }

    public TwitterException(String msg, int statusCode) {
        super(msg);
        this.statusCode = statusCode;
    }

    public static TwitterException createRateLimitedTwitterException(String msg, int statusCode, int retryAfter) {
        TwitterException te = new TwitterException(msg, statusCode);
        te.retryAfter = retryAfter;
        return te;
    }

    public TwitterException(String msg, Exception cause) {
        super(msg, cause);
    }

    public TwitterException(String msg, Exception cause, int statusCode) {
        super(msg, cause);
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getRetryAfter() {
        if (this.statusCode != 503 && this.statusCode != 420) {
            throw new IllegalStateException("Rate limitation is not exceeded");
        }
        return this.retryAfter;
    }
}

