/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.Arrays;
import twitter4j.IDs;
import twitter4j.ParseUtil;
import twitter4j.TwitterException;
import twitter4j.TwitterResponseImpl;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

final class IDsJSONImpl
extends TwitterResponseImpl
implements IDs {
    private int[] ids;
    private long previousCursor = -1L;
    private long nextCursor = -1L;
    private static final long serialVersionUID = -6585026560164704953L;

    private IDsJSONImpl(HttpResponse res) throws TwitterException {
        super(res);
    }

    static IDs getFriendsIDs(HttpResponse res) throws TwitterException {
        IDsJSONImpl friendsIDs = new IDsJSONImpl(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONArray idList = json.getJSONArray("ids");
            friendsIDs.ids = new int[idList.length()];
            for (int i = 0; i < idList.length(); ++i) {
                try {
                    friendsIDs.ids[i] = Integer.parseInt(idList.getString(i));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new TwitterException("Twitter API returned malformed response: " + json, nfe);
                }
            }
            friendsIDs.previousCursor = ParseUtil.getLong("previous_cursor", json);
            friendsIDs.nextCursor = ParseUtil.getLong("next_cursor", json);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        return friendsIDs;
    }

    static IDs getBlockIDs(HttpResponse res) throws TwitterException {
        IDsJSONImpl blockIDs = new IDsJSONImpl(res);
        JSONArray idList = null;
        try {
            idList = res.asJSONArray();
            blockIDs.ids = new int[idList.length()];
            for (int i = 0; i < idList.length(); ++i) {
                try {
                    blockIDs.ids[i] = Integer.parseInt(idList.getString(i));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new TwitterException("Twitter API returned malformed response: " + idList, nfe);
                }
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        return blockIDs;
    }

    public int[] getIDs() {
        return this.ids;
    }

    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    public long getPreviousCursor() {
        return this.previousCursor;
    }

    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    public long getNextCursor() {
        return this.nextCursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDs)) {
            return false;
        }
        IDs iDs = (IDs)o;
        return Arrays.equals(this.ids, iDs.getIDs());
    }

    public int hashCode() {
        return this.ids != null ? Arrays.hashCode(this.ids) : 0;
    }

    public String toString() {
        return "IDsJSONImpl{ids=" + this.ids + ", previousCursor=" + this.previousCursor + ", nextCursor=" + this.nextCursor + '}';
    }
}

