/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.ConfigurableHandler;
import com.google.appengine.repackaged.com.google.common.base.Log2Formatter;
import com.google.appengine.repackaged.com.google.common.base.RotatingLogStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

@Deprecated
public final class Log2FileHandler
extends Handler
implements ConfigurableHandler {
    static final String LIMIT_PROP = "limit";
    static final String BASENAME_PROP = "baseName";
    static final String QUALIFY_BASENAME_PROP = "qualifyBaseName";
    static final String RECORD_TS_FORMAT_PROP = "recordTsFormat";
    static final String FILENAME_TS_FORMAT_PROP = "fileNameTsFormat";
    static final String LINKNAME_PROP = "linkName";
    static final String EXTENSION_PROP = "extension";
    static final String FORMATTER_PROP = "formatter";
    private static final long MB = 0x100000L;
    private static final long DEFAULT_ROTATION_UNIT_SIZE_MB = 1800L;
    private static final String DEFAULT_BASE_FILE_NAME = "/export/hda3/tmp/Log2Trace";
    private static final String DEFAULT_RECORD_TS_FORMAT_STR = "yyMMdd HH:mm:ss ";
    private static final String DEFAULT_FILENAME_TS_FORMAT_STR = "-yyyy_MM_dd_HH_mm_ss";
    private String baseFileName;
    private boolean qualifyBaseFileName;
    private String linkName;
    private String extension;
    private long rotateSize;
    private DateFormat recordTsFormat;
    private DateFormat fileNameTsFormat;
    private Writer logFileWriter;
    private String formatterClass;
    private static String LOG_DIR_ENV = "GOOGLE_LOG_DIR";
    private static String LOG_DIR_PROP = "google.logDir";
    private static String BACKUP_LOG_DIR = "/export/hda3/tmp";

    Log2FileHandler(String baseFileName, String linkName, String extension, DateFormat recordTsFormat, DateFormat fileNameTsFormat, long rotateSize) {
        this.baseFileName = baseFileName;
        this.qualifyBaseFileName = true;
        this.linkName = linkName;
        this.extension = extension;
        this.recordTsFormat = recordTsFormat;
        this.fileNameTsFormat = fileNameTsFormat;
        this.rotateSize = rotateSize;
        this.logFileWriter = null;
        this.formatterClass = "com.google.appengine.repackaged.com.google.common.base.Log2Formatter";
        this.setFormatter(new Log2Formatter(recordTsFormat));
    }

    public Log2FileHandler(String fileName) {
        this(fileName, fileName, null, new SimpleDateFormat(DEFAULT_RECORD_TS_FORMAT_STR), new SimpleDateFormat(DEFAULT_FILENAME_TS_FORMAT_STR), Log2FileHandler.getRotationUnitSize());
    }

    Log2FileHandler() {
        this(DEFAULT_BASE_FILE_NAME, null, null, new SimpleDateFormat(DEFAULT_RECORD_TS_FORMAT_STR), new SimpleDateFormat(DEFAULT_FILENAME_TS_FORMAT_STR), Log2FileHandler.getRotationUnitSize());
    }

    public Handler configure(String instanceName, Properties configProps) {
        this.close();
        this.baseFileName = configProps.getProperty(this.qualifyPropName(instanceName, BASENAME_PROP), DEFAULT_BASE_FILE_NAME);
        this.qualifyBaseFileName = Boolean.valueOf(configProps.getProperty(this.qualifyPropName(instanceName, QUALIFY_BASENAME_PROP), "true"));
        this.rotateSize = Long.parseLong(configProps.getProperty(this.qualifyPropName(instanceName, LIMIT_PROP), "0"));
        if (this.rotateSize <= 0L) {
            this.rotateSize = Log2FileHandler.getRotationUnitSize();
        }
        String recordTsFormatStr = configProps.getProperty(this.qualifyPropName(instanceName, RECORD_TS_FORMAT_PROP), DEFAULT_RECORD_TS_FORMAT_STR);
        this.recordTsFormat = new SimpleDateFormat(recordTsFormatStr);
        String fileNameTsFormatStr = configProps.getProperty(this.qualifyPropName(instanceName, FILENAME_TS_FORMAT_PROP), DEFAULT_FILENAME_TS_FORMAT_STR);
        this.fileNameTsFormat = new SimpleDateFormat(fileNameTsFormatStr);
        this.linkName = configProps.getProperty(this.qualifyPropName(instanceName, LINKNAME_PROP), null);
        this.extension = configProps.getProperty(this.qualifyPropName(instanceName, EXTENSION_PROP), null);
        this.formatterClass = configProps.getProperty(this.qualifyPropName(instanceName, FORMATTER_PROP), "");
        if (!this.formatterClass.equals("")) {
            Formatter fmt = null;
            try {
                fmt = this.formatterClass.equals(Log2Formatter.class.getName()) ? new Log2Formatter(this.recordTsFormat) : (Formatter)Class.forName(this.formatterClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error loading formatter class specified by: " + this.qualifyPropName(instanceName, FORMATTER_PROP) + "value: " + this.formatterClass);
            }
            catch (InstantiationException e) {
                System.err.println("Error instantiating formatter class specified by: " + this.qualifyPropName(instanceName, FORMATTER_PROP) + "value: " + this.formatterClass);
            }
            catch (IllegalAccessException e) {
                System.err.println("Error instantiating formatter class specified by: " + this.qualifyPropName(instanceName, FORMATTER_PROP) + "value: " + this.formatterClass);
            }
            if (fmt != null) {
                this.setFormatter(fmt);
            }
        } else {
            this.setFormatter(new Log2Formatter(this.recordTsFormat));
        }
        return this;
    }

    private static long getRotationUnitSize() {
        String maxLogSizeMbStr = System.getenv("GOOGLE_MAX_LOG_MB");
        if (maxLogSizeMbStr != null) {
            try {
                long maxLogSizeMb = Long.parseLong(maxLogSizeMbStr);
                if (maxLogSizeMb > 0L) {
                    return maxLogSizeMb * 0x100000L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0x70800000L;
    }

    public void publish(LogRecord rec) {
        String logMsg = this.getFormatter().format(rec);
        if (this.logFileWriter == null) {
            this.openWriter();
        }
        try {
            this.logFileWriter.write(logMsg);
            this.logFileWriter.flush();
        }
        catch (IOException e) {
            System.err.println("Log2FileHandler#publish : error in writing to log!\n Exception thrown: " + e.getMessage() + "\nlog entry: " + logMsg);
        }
    }

    public void flush() {
        if (this.logFileWriter != null) {
            try {
                this.logFileWriter.flush();
            }
            catch (IOException e) {
                System.err.println("Log2FileHandler#flush : error in flushing log!\n Exception thrown: " + e.getMessage());
            }
        }
    }

    public void close() {
        if (this.logFileWriter != null) {
            try {
                this.logFileWriter.close();
                this.logFileWriter = null;
            }
            catch (IOException e) {
                System.err.println("Log2FileHandler#flush : error in closing log!\n Exception thrown: " + e.getMessage());
                this.logFileWriter = null;
            }
        }
    }

    private String qualifyPropName(String instanceName, String propName) {
        return instanceName + "." + propName;
    }

    private void openWriter() {
        try {
            String qualifiedFileName = this.baseFileName;
            String qualifiedLinkName = this.linkName;
            if (this.qualifyBaseFileName && !new File(this.baseFileName).isAbsolute()) {
                qualifiedFileName = Log2FileHandler.getLoggingDirectory() + File.separator + this.baseFileName;
            }
            if (this.qualifyBaseFileName && !new File(this.linkName).isAbsolute()) {
                qualifiedLinkName = Log2FileHandler.getLoggingDirectory() + File.separator + this.linkName;
            }
            RotatingLogStream rls = new RotatingLogStream(qualifiedFileName, qualifiedLinkName, this.extension, this.fileNameTsFormat);
            rls.setRotateSize(this.rotateSize);
            this.logFileWriter = new BufferedWriter(new OutputStreamWriter(rls));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean directoryExists(String dir) {
        File f = new File(dir);
        return f.exists() && f.isDirectory();
    }

    private static String getLoggingDirectory() {
        String dir = System.getenv(LOG_DIR_ENV);
        if (dir != null && Log2FileHandler.directoryExists(dir)) {
            return dir;
        }
        dir = System.getProperty(LOG_DIR_PROP);
        if (dir != null && Log2FileHandler.directoryExists(dir)) {
            return dir;
        }
        if (Log2FileHandler.directoryExists(BACKUP_LOG_DIR)) {
            return dir;
        }
        return Log2FileHandler.getTempDirectory();
    }

    private static String getTempDirectory() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (tmpDir == null) {
            tmpDir = System.getProperty("user.home");
        }
        return tmpDir;
    }
}

