/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.BinaryPredicate;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public class BinaryPredicates {
    private BinaryPredicates() {
    }

    @GwtCompatible(serializable=true)
    public static <X, Y> BinaryPredicate<X, Y> alwaysTrue() {
        return BinaryPredicates.restrict(AlwaysTrue.AlwaysTrue);
    }

    @GwtCompatible(serializable=true)
    public static <X, Y> BinaryPredicate<X, Y> alwaysFalse() {
        return BinaryPredicates.restrict(AlwaysFalse.AlwaysFalse);
    }

    @GwtCompatible(serializable=true)
    public static <X, Y> BinaryPredicate<X, Y> equality() {
        return BinaryPredicates.restrict(Equality.Equality);
    }

    @GwtCompatible(serializable=true)
    public static <X, Y> BinaryPredicate<X, Y> identity() {
        return BinaryPredicates.restrict(Identity.Identity);
    }

    public static <X, Y> BinaryPredicate<X, Y> first(Predicate<? super X> predicate) {
        return new First(predicate);
    }

    public static <X, Y> BinaryPredicate<X, Y> second(Predicate<? super Y> predicate) {
        return new Second(predicate);
    }

    public static <X, Y> BinaryPredicate<X, Y> and(BinaryPredicate<? super X, ? super Y> binaryPredicate1, BinaryPredicate<? super X, ? super Y> binaryPredicate2) {
        BinaryPredicate<? super X, ? super Y> restricted1 = BinaryPredicates.restrict(binaryPredicate1);
        BinaryPredicate<? super X, ? super Y> restricted2 = BinaryPredicates.restrict(binaryPredicate2);
        List<BinaryPredicate> iterable = Arrays.asList(restricted1, restricted2);
        return new And(iterable);
    }

    public static <X, Y> BinaryPredicate<X, Y> and(BinaryPredicate<? super X, ? super Y> ... components) {
        return new And<X, Y>(Arrays.asList(components));
    }

    public static <X, Y> BinaryPredicate<X, Y> and(Iterable<? extends BinaryPredicate<? super X, ? super Y>> components) {
        return new And(components);
    }

    public static <X, Y> BinaryPredicate<X, Y> or(BinaryPredicate<? super X, ? super Y> binaryPredicate1, BinaryPredicate<? super X, ? super Y> binaryPredicate2) {
        BinaryPredicate<? super X, ? super Y> restricted1 = BinaryPredicates.restrict(binaryPredicate1);
        BinaryPredicate<? super X, ? super Y> restricted2 = BinaryPredicates.restrict(binaryPredicate2);
        List<BinaryPredicate> iterable = Arrays.asList(restricted1, restricted2);
        return new Or(iterable);
    }

    public static <X, Y> BinaryPredicate<X, Y> or(BinaryPredicate<? super X, ? super Y> ... components) {
        return new Or<X, Y>(Arrays.asList(components));
    }

    public static <X, Y> BinaryPredicate<X, Y> or(Iterable<? extends BinaryPredicate<? super X, ? super Y>> components) {
        return new Or(components);
    }

    public static <X, Y> BinaryPredicate<X, Y> not(BinaryPredicate<? super X, ? super Y> binaryPredicate) {
        return new Not<X, Y>(binaryPredicate);
    }

    private static <X, Y> BinaryPredicate<X, Y> restrict(@Nullable BinaryPredicate<? super X, ? super Y> predicate) {
        return predicate;
    }

    private static boolean iterableElementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        Iterator<?> iterator1 = iterable1.iterator();
        Iterator<?> iterator2 = iterable2.iterator();
        while (iterator1.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (iterator1.next().equals(iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    private static int iterableAsListHashCode(Iterable<?> iterable) {
        Iterator<?> iterator = iterable.iterator();
        int result = 1;
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            result = 31 * result + obj.hashCode();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Second<X, Y>
    implements BinaryPredicate<X, Y>,
    Serializable {
        private static final long serialVersionUID = -7134579481937611424L;
        private final Predicate<? super Y> predicate;

        Second(Predicate<? super Y> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(@Nullable X x, @Nullable Y y) {
            return this.predicate.apply(y);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof Second) {
                Second other = (Second)obj;
                return ((Object)this.predicate).equals(other.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class First<X, Y>
    implements BinaryPredicate<X, Y>,
    Serializable {
        private static final long serialVersionUID = 5389902773091803723L;
        private final Predicate<? super X> predicate;

        First(Predicate<? super X> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(@Nullable X x, @Nullable Y y) {
            return this.predicate.apply(x);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof First) {
                First other = (First)obj;
                return ((Object)this.predicate).equals(other.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Or<X, Y>
    implements BinaryPredicate<X, Y>,
    Serializable {
        private static final long serialVersionUID = -1352468805830701672L;
        private final Iterable<? extends BinaryPredicate<? super X, ? super Y>> predicates;

        Or(Iterable<? extends BinaryPredicate<? super X, ? super Y>> predicates) {
            this.predicates = Preconditions.checkContentsNotNull(predicates);
        }

        @Override
        public boolean apply(@Nullable X x, @Nullable Y y) {
            for (BinaryPredicate<X, Y> predicate : this.predicates) {
                if (!predicate.apply(x, y)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof Or) {
                return BinaryPredicates.iterableElementsEqual(this.predicates, ((Or)obj).predicates);
            }
            return false;
        }

        public int hashCode() {
            return BinaryPredicates.iterableAsListHashCode(this.predicates);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class And<X, Y>
    implements BinaryPredicate<X, Y>,
    Serializable {
        private static final long serialVersionUID = 4814831122225615776L;
        private final Iterable<? extends BinaryPredicate<? super X, ? super Y>> predicates;

        And(Iterable<? extends BinaryPredicate<? super X, ? super Y>> predicates) {
            this.predicates = Preconditions.checkContentsNotNull(predicates);
        }

        @Override
        public boolean apply(@Nullable X x, @Nullable Y y) {
            for (BinaryPredicate<X, Y> predicate : this.predicates) {
                if (predicate.apply(x, y)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof And) {
                return BinaryPredicates.iterableElementsEqual(this.predicates, ((And)obj).predicates);
            }
            return false;
        }

        public int hashCode() {
            return BinaryPredicates.iterableAsListHashCode(this.predicates);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Not<X, Y>
    implements BinaryPredicate<X, Y>,
    Serializable {
        private static final long serialVersionUID = 7318841078083112007L;
        private final BinaryPredicate<? super X, ? super Y> predicate;

        Not(BinaryPredicate<? super X, ? super Y> predicate) {
            this.predicate = Preconditions.checkNotNull(predicate);
        }

        @Override
        public boolean apply(@Nullable X x, @Nullable Y y) {
            return !this.predicate.apply(x, y);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof Not) {
                Not other = (Not)obj;
                return this.predicate.equals(other.predicate);
            }
            return false;
        }

        public int hashCode() {
            return this.predicate.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Identity implements BinaryPredicate<Object, Object>
    {
        Identity;


        @Override
        public boolean apply(@Nullable Object o1, @Nullable Object o2) {
            return o1 == o2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Equality implements BinaryPredicate<Object, Object>
    {
        Equality;


        @Override
        public boolean apply(@Nullable Object o1, @Nullable Object o2) {
            return Objects.equal(o1, o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AlwaysFalse implements BinaryPredicate<Object, Object>
    {
        AlwaysFalse;


        @Override
        public boolean apply(@Nullable Object o1, @Nullable Object o2) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AlwaysTrue implements BinaryPredicate<Object, Object>
    {
        AlwaysTrue;


        @Override
        public boolean apply(@Nullable Object o1, @Nullable Object o2) {
            return true;
        }
    }
}

