/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache.stdimpl;

import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceFactory;
import com.google.appengine.api.memcache.Stats;
import com.google.appengine.api.memcache.stdimpl.GCacheEntry;
import com.google.appengine.api.memcache.stdimpl.GCacheException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheEntry;
import javax.cache.CacheListener;
import javax.cache.CacheStatistics;

public class GCache
implements Cache {
    private final MemcacheService service;
    private final List<CacheListener> listeners = new LinkedList<CacheListener>();
    private final Expiration expiration;
    private final MemcacheService.SetPolicy setPolicy;

    public GCache(Map properties) {
        if (properties != null) {
            Object expirationProperty = properties.get(0);
            int millis = 0;
            if (expirationProperty instanceof Integer) {
                millis = (Integer)expirationProperty * 1000;
            }
            if ((expirationProperty = properties.get(1)) instanceof Integer) {
                millis = (Integer)expirationProperty;
            }
            this.expiration = millis != 0 ? Expiration.byDeltaMillis(millis) : ((expirationProperty = properties.get(2)) instanceof Date ? Expiration.onDate((Date)expirationProperty) : null);
            Object setProperty = properties.get(3);
            this.setPolicy = setProperty instanceof MemcacheService.SetPolicy ? (MemcacheService.SetPolicy)((Object)setProperty) : MemcacheService.SetPolicy.SET_ALWAYS;
            Object memcacheService = properties.get(4);
            if (memcacheService instanceof MemcacheService) {
                this.service = (MemcacheService)memcacheService;
            } else {
                Object namespace = properties.get(5);
                if (!(namespace instanceof String)) {
                    namespace = null;
                }
                this.service = MemcacheServiceFactory.getMemcacheService((String)namespace);
            }
        } else {
            this.expiration = null;
            this.setPolicy = MemcacheService.SetPolicy.SET_ALWAYS;
            this.service = MemcacheServiceFactory.getMemcacheService();
        }
    }

    public void addListener(CacheListener cacheListener) {
        this.listeners.add(cacheListener);
    }

    public void evict() {
    }

    public Map getAll(Collection collection) {
        return this.service.getAll(collection);
    }

    public CacheEntry getCacheEntry(Object o) {
        Object value = this.service.get(o);
        if (value == null && !this.service.contains(o)) {
            return null;
        }
        return new GCacheEntry(this, o, value);
    }

    public CacheStatistics getCacheStatistics() {
        return new GCacheStats(this.service.getStatistics());
    }

    public void load(Object o) {
        throw new UnsupportedOperationException();
    }

    public void loadAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public Object peek(Object o) {
        return this.get(o);
    }

    public void removeListener(CacheListener cacheListener) {
        this.listeners.remove(cacheListener);
    }

    public int size() {
        return this.getCacheStatistics().getObjectCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.service.contains(key);
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        return this.service.get(key);
    }

    public Object put(Object key, Object value) {
        for (CacheListener listener : this.listeners) {
            listener.onPut(value);
        }
        if (!this.service.put(key, value, this.expiration, this.setPolicy)) {
            throw new GCacheException("Policy prevented put operation");
        }
        return null;
    }

    public Object remove(Object key) {
        for (CacheListener listener : this.listeners) {
            listener.onRmove(key);
        }
        Object value = this.service.get(key);
        this.service.delete(key);
        return value;
    }

    public void putAll(Map m) {
        Set<Object> added = this.service.putAll(m, this.expiration, this.setPolicy);
        added.removeAll(m.keySet());
        if (!added.isEmpty()) {
            throw new GCacheException("Policy prevented some put operations");
        }
    }

    public void clear() {
        for (CacheListener listener : this.listeners) {
            listener.onClear();
        }
        this.service.clearAll();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class GCacheStats
    implements CacheStatistics {
        private Stats stats;

        private GCacheStats(Stats stats) {
            this.stats = stats;
        }

        public void clearStatistics() {
            throw new UnsupportedOperationException();
        }

        public int getCacheHits() {
            return (int)this.stats.getHitCount();
        }

        public int getCacheMisses() {
            return (int)this.stats.getMissCount();
        }

        public int getObjectCount() {
            return (int)this.stats.getItemCount();
        }

        public int getStatisticsAccuracy() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.stats.toString();
        }
    }
}

