/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.images.Composite;
import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImagesServiceImpl;
import com.google.appengine.api.images.ImagesServicePb;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompositeImpl
extends Composite {
    private final Image image;
    private final Composite.Anchor anchor;
    private final int xOffset;
    private final int yOffset;
    private final float opacity;

    CompositeImpl(Image image, int xOffset, int yOffset, float opacity, Composite.Anchor anchor) {
        if (image == null) {
            throw new IllegalArgumentException("The image must not be null");
        }
        if (xOffset > 4000 || xOffset < -4000 || yOffset > 4000 || yOffset < -4000) {
            throw new IllegalArgumentException("Images must fit on the canvas");
        }
        if (opacity < 0.0f || opacity > 1.0f) {
            throw new IllegalArgumentException("Opacity must be in range [0, 1]");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Anchor must not be null");
        }
        this.image = image;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.opacity = opacity;
    }

    @Override
    void apply(ImagesServicePb.ImagesCompositeRequest request, Map<Image, Integer> imageIndexMap) {
        if (!imageIndexMap.containsKey(this.image)) {
            imageIndexMap.put(this.image, request.imageSize());
            ImagesServiceImpl.convertImageData(this.image, request.addImage());
        }
        ImagesServicePb.CompositeImageOptions options = request.addOptions();
        int sourceId = imageIndexMap.get(this.image);
        options.setSourceIndex(sourceId);
        options.setXOffset(this.xOffset);
        options.setYOffset(this.yOffset);
        options.setOpacity(this.opacity);
        options.setAnchor(this.anchor.ordinal());
    }
}

