/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.util.ResourceLoader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;

public final class UIHelper {
    private static final UIHelper singleton = new UIHelper();
    private final ResourceLoader resourceLoader = new ResourceLoader(ResourceLoader.getDefaultClassLoader());

    private UIHelper() {
    }

    public static final UIHelper getInstance() {
        return singleton;
    }

    public <T> Collection<T> getDescendantOfClass(Class<T> clz, Container container) {
        if (container == null || clz == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Component> components = new ArrayList<Component>();
        this.getDescendantOfClass(clz, container, components);
        return components;
    }

    private void getDescendantOfClass(Class<?> clz, Container container, Collection<Component> results) {
        if (container == null) {
            return;
        }
        for (Component comp : container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents()) {
            if (clz.isInstance(comp)) {
                results.add(comp);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.getDescendantOfClass(clz, (Container)comp, results);
        }
    }

    public Icon createTwoStateIcon(String iconName1, String iconName2) {
        if (iconName1 == null || iconName2 == null || iconName1.length() == 0 || iconName2.length() == 0) {
            throw new IllegalArgumentException();
        }
        final BufferedImage pinIcon1 = this.getImage(iconName1);
        final BufferedImage pinIcon2 = this.getImage(iconName2);
        Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                boolean selected = false;
                if (c instanceof AbstractButton) {
                    AbstractButton btn = (AbstractButton)c;
                    selected = btn.isSelected();
                }
                BufferedImage iconImage = !selected ? pinIcon1 : pinIcon2;
                int w = iconImage.getWidth();
                int h = iconImage.getHeight();
                g.drawImage(iconImage, x, y, w, h, 0, 0, w, h, null);
            }

            @Override
            public int getIconHeight() {
                return pinIcon1.getHeight();
            }

            @Override
            public int getIconWidth() {
                return pinIcon1.getWidth();
            }
        };
        return icon;
    }

    public JButton createIconButton(String iconName) {
        if (iconName == null || iconName.length() == 0) {
            throw new IllegalArgumentException();
        }
        JButton btn = new JButton();
        btn.setIcon(new ImageIcon(this.getImage(iconName)));
        return btn;
    }

    public JButton createTransparentButton(String normal) {
        return this.createTransparentButton(normal, null);
    }

    public JButton createTransparentButton(String normal, String rollover) {
        if (normal == null || normal.length() == 0) {
            throw new IllegalArgumentException();
        }
        ImageIcon normIcon = new ImageIcon(this.getImage(normal));
        JButton btn = new JButton(normIcon);
        if (rollover != null && rollover.length() != 0) {
            ImageIcon rolloverIcon = new ImageIcon(this.getImage(rollover));
            btn.setRolloverEnabled(true);
            btn.setRolloverIcon(rolloverIcon);
            btn.setPressedIcon(rolloverIcon);
        }
        btn.setOpaque(false);
        btn.setBorderPainted(false);
        btn.setContentAreaFilled(false);
        return btn;
    }

    public BufferedImage getImage(String name) {
        URL url = this.resourceLoader.getResource(name);
        if (url == null) {
            throw new RuntimeException("resource not found. " + name);
        }
        try {
            return ImageIO.read(url);
        }
        catch (IOException ex) {
            throw new RuntimeException("image load error." + ex.getMessage(), ex);
        }
    }
}

