/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.LinkedList;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Realm
implements Cloneable {
    private final String realm;

    public Realm(String string) throws RealmException {
        this.realm = Realm.parseRealm(string);
    }

    public static Realm getDefault() throws RealmException {
        try {
            return new Realm(Config.getInstance().getDefaultRealm());
        }
        catch (RealmException realmException) {
            throw realmException;
        }
        catch (KrbException krbException) {
            throw new RealmException(krbException);
        }
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Realm)) {
            return false;
        }
        Realm realm = (Realm)object;
        return this.realm.equals(realm.realm);
    }

    public int hashCode() {
        return this.realm.hashCode();
    }

    public Realm(DerValue derValue) throws Asn1Exception, RealmException, IOException {
        if (derValue == null) {
            throw new IllegalArgumentException("encoding can not be null");
        }
        this.realm = new KerberosString(derValue).toString();
        if (this.realm == null || this.realm.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(this.realm)) {
            throw new RealmException(600);
        }
    }

    public String toString() {
        return this.realm;
    }

    public static String parseRealmAtSeparator(String string) throws RealmException {
        if (string == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String string2 = new String(string);
        String string3 = null;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != '@' || i != 0 && string2.charAt(i - 1) == '\\') continue;
            if (i + 1 < string2.length()) {
                string3 = string2.substring(i + 1, string2.length());
                break;
            }
            throw new IllegalArgumentException("empty realm part not allowed");
        }
        if (string3 != null) {
            if (string3.length() == 0) {
                throw new RealmException(601);
            }
            if (!Realm.isValidRealmString(string3)) {
                throw new RealmException(600);
            }
        }
        return string3;
    }

    public static String parseRealmComponent(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String string2 = new String(string);
        String string3 = null;
        for (int i = 0; i < string2.length(); ++i) {
            if (string2.charAt(i) != '.' || i != 0 && string2.charAt(i - 1) == '\\') continue;
            if (i + 1 >= string2.length()) break;
            string3 = string2.substring(i + 1, string2.length());
            break;
        }
        return string3;
    }

    protected static String parseRealm(String string) throws RealmException {
        String string2 = Realm.parseRealmAtSeparator(string);
        if (string2 == null) {
            string2 = string;
        }
        if (string2 == null || string2.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(string2)) {
            throw new RealmException(600);
        }
        return string2;
    }

    protected static boolean isValidRealmString(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '/' && string.charAt(i) != ':' && string.charAt(i) != '\u0000') continue;
            return false;
        }
        return true;
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putDerValue(new KerberosString(this.realm).toDerValue());
        return derOutputStream.toByteArray();
    }

    public static Realm parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException, RealmException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new Realm(derValue2);
    }

    public static String[] getRealmsList(String string, String string2) {
        try {
            return Realm.parseCapaths(string, string2);
        }
        catch (KrbException krbException) {
            return Realm.parseHierarchy(string, string2);
        }
    }

    private static String[] parseCapaths(String string, String string2) throws KrbException {
        String string3;
        Config config = Config.getInstance();
        if (!config.exists("capaths", string, string2)) {
            throw new KrbException("No conf");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string4 = string2;
        while ((string3 = config.getAll("capaths", string, string4)) != null) {
            String[] stringArray = string3.split("\\s+");
            boolean bl = false;
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (linkedList.contains(stringArray[i]) || stringArray[i].equals(".") || stringArray[i].equals(string) || stringArray[i].equals(string2) || stringArray[i].equals(string4)) continue;
                bl = true;
                linkedList.addFirst(stringArray[i]);
            }
            if (!bl) break;
            string4 = (String)linkedList.getFirst();
        }
        linkedList.addFirst(string);
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private static String[] parseHierarchy(String string, String string2) {
        int n;
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n2 = stringArray.length;
        int n3 = stringArray2.length;
        boolean bl = false;
        --n3;
        --n2;
        while (n3 >= 0 && n2 >= 0 && stringArray2[n3].equals(stringArray[n2])) {
            bl = true;
            --n3;
            --n2;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (n = 0; n <= n2; ++n) {
            linkedList.addLast(Realm.subStringFrom(stringArray, n));
        }
        if (bl) {
            linkedList.addLast(Realm.subStringFrom(stringArray, n2 + 1));
        }
        for (n = n3; n >= 0; --n) {
            linkedList.addLast(Realm.subStringFrom(stringArray2, n));
        }
        linkedList.removeLast();
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private static String subStringFrom(String[] stringArray, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < stringArray.length; ++i) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }
}

