/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.oracle.webservices.internal.api.EnvelopeStyleFeature;
import com.oracle.webservices.internal.api.message.MessageContextFactory;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.binding.FeatureListUtil;
import com.sun.xml.internal.ws.binding.HTTPBindingImpl;
import com.sun.xml.internal.ws.binding.SOAPBindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.developer.BindingTypeFeature;
import com.sun.xml.internal.ws.developer.MemberSubmissionAddressingFeature;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.AddressingFeature;

public abstract class BindingImpl
implements WSBinding {
    protected static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];
    private HandlerConfiguration handlerConfig;
    private final Set<QName> addedHeaders = new HashSet<QName>();
    private final Set<QName> knownHeaders = new HashSet<QName>();
    private final Set<QName> unmodKnownHeaders = Collections.unmodifiableSet(this.knownHeaders);
    private final BindingID bindingId;
    protected final WebServiceFeatureList features;
    protected final Map<QName, WebServiceFeatureList> operationFeatures = new HashMap<QName, WebServiceFeatureList>();
    protected final Map<QName, WebServiceFeatureList> inputMessageFeatures = new HashMap<QName, WebServiceFeatureList>();
    protected final Map<QName, WebServiceFeatureList> outputMessageFeatures = new HashMap<QName, WebServiceFeatureList>();
    protected final Map<MessageKey, WebServiceFeatureList> faultMessageFeatures = new HashMap<MessageKey, WebServiceFeatureList>();
    protected Service.Mode serviceMode = Service.Mode.PAYLOAD;
    protected MessageContextFactory messageContextFactory;

    protected BindingImpl(BindingID bindingID, WebServiceFeature ... webServiceFeatureArray) {
        this.bindingId = bindingID;
        this.handlerConfig = new HandlerConfiguration(Collections.emptySet(), Collections.emptyList());
        if (this.handlerConfig.getHandlerKnownHeaders() != null) {
            this.knownHeaders.addAll(this.handlerConfig.getHandlerKnownHeaders());
        }
        this.features = new WebServiceFeatureList(webServiceFeatureArray);
        this.features.validate();
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    protected void setHandlerConfig(HandlerConfiguration handlerConfiguration) {
        this.handlerConfig = handlerConfiguration;
        this.knownHeaders.clear();
        this.knownHeaders.addAll(this.addedHeaders);
        if (handlerConfiguration != null && handlerConfiguration.getHandlerKnownHeaders() != null) {
            this.knownHeaders.addAll(handlerConfiguration.getHandlerKnownHeaders());
        }
    }

    public void setMode(@NotNull Service.Mode mode) {
        this.serviceMode = mode;
    }

    @Override
    public Set<QName> getKnownHeaders() {
        return this.unmodKnownHeaders;
    }

    @Override
    public boolean addKnownHeader(QName qName) {
        this.addedHeaders.add(qName);
        return this.knownHeaders.add(qName);
    }

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        AddressingVersion addressingVersion = this.features.isEnabled(AddressingFeature.class) ? AddressingVersion.W3C : (this.features.isEnabled(MemberSubmissionAddressingFeature.class) ? AddressingVersion.MEMBER : null);
        return addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingID) {
        if (bindingID.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingID);
    }

    public static BindingImpl create(@NotNull BindingID bindingID, WebServiceFeature[] webServiceFeatureArray) {
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            if (!(webServiceFeature instanceof BindingTypeFeature)) continue;
            BindingTypeFeature bindingTypeFeature = (BindingTypeFeature)webServiceFeature;
            bindingID = BindingID.parse(bindingTypeFeature.getBindingId());
        }
        if (bindingID.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl(webServiceFeatureArray);
        }
        return new SOAPBindingImpl(bindingID, webServiceFeatureArray);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    @Override
    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getFeature(@NotNull Class<F> clazz) {
        return this.features.get(clazz);
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F getOperationFeature(@NotNull Class<F> clazz, @NotNull QName qName) {
        WebServiceFeatureList webServiceFeatureList = this.operationFeatures.get(qName);
        return FeatureListUtil.mergeFeature(clazz, webServiceFeatureList, this.features);
    }

    @Override
    public boolean isFeatureEnabled(@NotNull Class<? extends WebServiceFeature> clazz) {
        return this.features.isEnabled(clazz);
    }

    @Override
    public boolean isOperationFeatureEnabled(@NotNull Class<? extends WebServiceFeature> clazz, @NotNull QName qName) {
        WebServiceFeatureList webServiceFeatureList = this.operationFeatures.get(qName);
        return FeatureListUtil.isFeatureEnabled(clazz, webServiceFeatureList, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFeatures() {
        if (!this.isFeatureEnabled(EnvelopeStyleFeature.class)) {
            WebServiceFeature[] webServiceFeatureArray = new WebServiceFeature[]{this.getSOAPVersion().toFeature()};
            this.features.mergeFeatures(webServiceFeatureArray, false);
        }
        return this.features;
    }

    @Override
    @NotNull
    public WebServiceFeatureList getOperationFeatures(@NotNull QName qName) {
        WebServiceFeatureList webServiceFeatureList = this.operationFeatures.get(qName);
        return FeatureListUtil.mergeList(webServiceFeatureList, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getInputMessageFeatures(@NotNull QName qName) {
        WebServiceFeatureList webServiceFeatureList = this.operationFeatures.get(qName);
        WebServiceFeatureList webServiceFeatureList2 = this.inputMessageFeatures.get(qName);
        return FeatureListUtil.mergeList(webServiceFeatureList, webServiceFeatureList2, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getOutputMessageFeatures(@NotNull QName qName) {
        WebServiceFeatureList webServiceFeatureList = this.operationFeatures.get(qName);
        WebServiceFeatureList webServiceFeatureList2 = this.outputMessageFeatures.get(qName);
        return FeatureListUtil.mergeList(webServiceFeatureList, webServiceFeatureList2, this.features);
    }

    @Override
    @NotNull
    public WebServiceFeatureList getFaultMessageFeatures(@NotNull QName qName, @NotNull QName qName2) {
        WebServiceFeatureList webServiceFeatureList = this.operationFeatures.get(qName);
        WebServiceFeatureList webServiceFeatureList2 = this.faultMessageFeatures.get(new MessageKey(qName, qName2));
        return FeatureListUtil.mergeList(webServiceFeatureList, webServiceFeatureList2, this.features);
    }

    public void setOperationFeatures(@NotNull QName qName, WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            WebServiceFeatureList webServiceFeatureList = this.operationFeatures.get(qName);
            if (webServiceFeatureList == null) {
                webServiceFeatureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                webServiceFeatureList.add(webServiceFeature);
            }
            this.operationFeatures.put(qName, webServiceFeatureList);
        }
    }

    public void setInputMessageFeatures(@NotNull QName qName, WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            WebServiceFeatureList webServiceFeatureList = this.inputMessageFeatures.get(qName);
            if (webServiceFeatureList == null) {
                webServiceFeatureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                webServiceFeatureList.add(webServiceFeature);
            }
            this.inputMessageFeatures.put(qName, webServiceFeatureList);
        }
    }

    public void setOutputMessageFeatures(@NotNull QName qName, WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            WebServiceFeatureList webServiceFeatureList = this.outputMessageFeatures.get(qName);
            if (webServiceFeatureList == null) {
                webServiceFeatureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                webServiceFeatureList.add(webServiceFeature);
            }
            this.outputMessageFeatures.put(qName, webServiceFeatureList);
        }
    }

    public void setFaultMessageFeatures(@NotNull QName qName, @NotNull QName qName2, WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            MessageKey messageKey = new MessageKey(qName, qName2);
            WebServiceFeatureList webServiceFeatureList = this.faultMessageFeatures.get(messageKey);
            if (webServiceFeatureList == null) {
                webServiceFeatureList = new WebServiceFeatureList();
            }
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                webServiceFeatureList.add(webServiceFeature);
            }
            this.faultMessageFeatures.put(messageKey, webServiceFeatureList);
        }
    }

    @Override
    @NotNull
    public synchronized MessageContextFactory getMessageContextFactory() {
        if (this.messageContextFactory == null) {
            this.messageContextFactory = MessageContextFactory.createFactory(this.getFeatures().toArray());
        }
        return this.messageContextFactory;
    }

    protected static class MessageKey {
        private final QName operationName;
        private final QName messageName;

        public MessageKey(QName qName, QName qName2) {
            this.operationName = qName;
            this.messageName = qName2;
        }

        public int hashCode() {
            int n = this.operationName != null ? this.operationName.hashCode() : 0;
            int n2 = this.messageName != null ? this.messageName.hashCode() : 0;
            return (n + n2) * n2 + n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MessageKey messageKey = (MessageKey)object;
            if (!(this.operationName == messageKey.operationName || this.operationName != null && this.operationName.equals(messageKey.operationName))) {
                return false;
            }
            return this.messageName == messageKey.messageName || this.messageName != null && this.messageName.equals(messageKey.messageName);
        }

        public String toString() {
            return "(" + this.operationName + ", " + this.messageName + ")";
        }
    }
}

