/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.assembler;

import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.pipe.Pipe;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.internal.ws.assembler.dev.TubelineAssemblyContext;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

class TubelineAssemblyContextImpl
implements TubelineAssemblyContext {
    private static final Logger LOGGER = Logger.getLogger(TubelineAssemblyContextImpl.class);
    private Tube head;
    private Pipe adaptedHead;
    private List<Tube> tubes = new LinkedList<Tube>();

    TubelineAssemblyContextImpl() {
    }

    @Override
    public Tube getTubelineHead() {
        return this.head;
    }

    @Override
    public Pipe getAdaptedTubelineHead() {
        if (this.adaptedHead == null) {
            this.adaptedHead = PipeAdapter.adapt(this.head);
        }
        return this.adaptedHead;
    }

    boolean setTubelineHead(Tube tube) {
        if (tube == this.head || tube == this.adaptedHead) {
            return false;
        }
        this.head = tube;
        this.tubes.add(this.head);
        this.adaptedHead = null;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(MessageFormat.format("Added '{0}' tube instance to the tubeline.", tube == null ? null : tube.getClass().getName()));
        }
        return true;
    }

    @Override
    public <T> T getImplementation(Class<T> clazz) {
        for (Tube tube : this.tubes) {
            if (!clazz.isInstance(tube)) continue;
            return clazz.cast(tube);
        }
        return null;
    }
}

