/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.utils;

import com.sun.org.apache.xerces.internal.utils.XMLSecurityManager;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public final class XMLLimitAnalyzer {
    private final int[] values = new int[XMLSecurityManager.Limit.values().length];
    private final String[] names;
    private final int[] totalValue = new int[XMLSecurityManager.Limit.values().length];
    private final Map[] caches;
    private String entityStart;
    private String entityEnd;

    public XMLLimitAnalyzer() {
        this.names = new String[XMLSecurityManager.Limit.values().length];
        this.caches = new Map[XMLSecurityManager.Limit.values().length];
    }

    public void addValue(XMLSecurityManager.Limit limit, String string, int n) {
        this.addValue(limit.ordinal(), string, n);
    }

    public void addValue(int n, String string, int n2) {
        Map<String, Integer> map;
        if (n == XMLSecurityManager.Limit.ENTITY_EXPANSION_LIMIT.ordinal() || n == XMLSecurityManager.Limit.MAX_OCCUR_NODE_LIMIT.ordinal() || n == XMLSecurityManager.Limit.ELEMENT_ATTRIBUTE_LIMIT.ordinal()) {
            int n3 = n;
            this.totalValue[n3] = this.totalValue[n3] + n2;
            return;
        }
        if (this.caches[n] == null) {
            this.caches[n] = map = new HashMap(10);
        } else {
            map = this.caches[n];
        }
        int n4 = n2;
        if (map.containsKey(string)) {
            map.put(string, n4 += ((Integer)map.get(string)).intValue());
        } else {
            map.put(string, n2);
        }
        if (n4 > this.values[n]) {
            this.values[n] = n4;
            this.names[n] = string;
        }
        if (n == XMLSecurityManager.Limit.GENERAL_ENTITY_SIZE_LIMIT.ordinal() || n == XMLSecurityManager.Limit.PARAMETER_ENTITY_SIZE_LIMIT.ordinal()) {
            int n5 = XMLSecurityManager.Limit.TOTAL_ENTITY_SIZE_LIMIT.ordinal();
            this.totalValue[n5] = this.totalValue[n5] + n2;
        }
    }

    public int getValue(XMLSecurityManager.Limit limit) {
        return this.values[limit.ordinal()];
    }

    public int getValue(int n) {
        return this.values[n];
    }

    public int getTotalValue(XMLSecurityManager.Limit limit) {
        return this.totalValue[limit.ordinal()];
    }

    public int getTotalValue(int n) {
        return this.totalValue[n];
    }

    public int getValueByIndex(int n) {
        return this.values[n];
    }

    public void startEntity(String string) {
        this.entityStart = string;
    }

    public boolean isTracking(String string) {
        if (this.entityStart == null) {
            return false;
        }
        return this.entityStart.equals(string);
    }

    public void endEntity(XMLSecurityManager.Limit limit, String string) {
        this.entityStart = "";
        Map map = this.caches[limit.ordinal()];
        if (map != null) {
            map.remove(string);
        }
    }

    public void debugPrint(XMLSecurityManager xMLSecurityManager) {
        Formatter formatter = new Formatter();
        System.out.println(formatter.format("%30s %15s %15s %15s %30s", "Property", "Limit", "Total size", "Size", "Entity Name"));
        for (XMLSecurityManager.Limit limit : XMLSecurityManager.Limit.values()) {
            formatter = new Formatter();
            System.out.println(formatter.format("%30s %15d %15d %15d %30s", limit.name(), xMLSecurityManager.getLimit(limit), this.totalValue[limit.ordinal()], this.values[limit.ordinal()], this.names[limit.ordinal()]));
        }
    }

    public static enum NameMap {
        ENTITY_EXPANSION_LIMIT("jdk.xml.entityExpansionLimit", "entityExpansionLimit"),
        MAX_OCCUR_NODE_LIMIT("jdk.xml.maxOccurLimit", "maxOccurLimit"),
        ELEMENT_ATTRIBUTE_LIMIT("jdk.xml.elementAttributeLimit", "elementAttributeLimit");

        final String newName;
        final String oldName;

        private NameMap(String string2, String string3) {
            this.newName = string2;
            this.oldName = string3;
        }

        String getOldName(String string) {
            if (string.equals(this.newName)) {
                return this.oldName;
            }
            return null;
        }
    }
}

