/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import jdk.nashorn.internal.parser.Token;

public final class Source {
    private final String name;
    private final String base;
    private final char[] content;
    private final int length;
    private int hash;
    private final URL url;
    private static final int BUFSIZE = 8192;

    private Source(String name, String base, char[] content, URL url) {
        this.name = name;
        this.base = base;
        this.content = content;
        this.length = content.length;
        this.url = url;
    }

    public Source(String name, char[] content) {
        this(name, Source.baseName(name, null), content, null);
    }

    public Source(String name, String content) {
        this(name, content.toCharArray());
    }

    public Source(String name, URL url) throws IOException {
        this(name, Source.baseURL(url, null), Source.readFully(url), url);
    }

    public Source(String name, URL url, Charset cs) throws IOException {
        this(name, Source.baseURL(url, null), Source.readFully(url, cs), url);
    }

    public Source(String name, File file) throws IOException {
        this(name, Source.dirName(file, null), Source.readFully(file), Source.getURLFromFile(file));
    }

    public Source(String name, File file, Charset cs) throws IOException {
        this(name, Source.dirName(file, null), Source.readFully(file, cs), Source.getURLFromFile(file));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source src = (Source)obj;
        return this.length == src.length && Objects.equals(this.url, src.url) && Objects.equals(this.name, src.name) && Arrays.equals(this.content, src.content);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.hash = Arrays.hashCode(this.content) ^ Objects.hashCode(this.name);
        }
        return h;
    }

    public String getString() {
        return new String(this.content, 0, this.length);
    }

    public String getName() {
        return this.name;
    }

    public String getBase() {
        return this.base;
    }

    public String getString(int start, int len) {
        return new String(this.content, start, len);
    }

    public String getString(long token) {
        int start = Token.descPosition(token);
        int len = Token.descLength(token);
        return new String(this.content, start, len);
    }

    public URL getURL() {
        return this.url;
    }

    private int findBOLN(int position) {
        for (int i = position - 1; i > 0; --i) {
            char ch = this.content[i];
            if (ch != '\n' && ch != '\r') continue;
            return i + 1;
        }
        return 0;
    }

    private int findEOLN(int position) {
        for (int i = position; i < this.length; ++i) {
            char ch = this.content[i];
            if (ch != '\n' && ch != '\r') continue;
            return i - 1;
        }
        return this.length - 1;
    }

    public int getLine(int position) {
        int line = 1;
        for (int i = 0; i < position; ++i) {
            char ch = this.content[i];
            if (ch != '\n') continue;
            ++line;
        }
        return line;
    }

    public int getColumn(int position) {
        return position - this.findBOLN(position);
    }

    public String getSourceLine(int position) {
        int first = this.findBOLN(position);
        int last = this.findEOLN(position);
        return new String(this.content, first, last - first + 1);
    }

    public char[] getContent() {
        return (char[])this.content.clone();
    }

    public int getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readFully(Reader reader) throws IOException {
        char[] arr = new char[8192];
        StringBuilder sb = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                sb.append(arr, 0, numChars);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString().toCharArray();
    }

    public static char[] readFully(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file + " is not a file");
        }
        return Source.byteToCharArray(Files.readAllBytes(file.toPath()));
    }

    public static char[] readFully(File file, Charset cs) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file + " is not a file");
        }
        byte[] buf = Files.readAllBytes(file.toPath());
        return cs != null ? new String(buf, cs).toCharArray() : Source.byteToCharArray(buf);
    }

    public static char[] readFully(URL url) throws IOException {
        return Source.readFully(url.openStream());
    }

    public static char[] readFully(URL url, Charset cs) throws IOException {
        return Source.readFully(url.openStream(), cs);
    }

    public static String baseURL(URL url) {
        return Source.baseURL(url, null);
    }

    private static String baseURL(URL url, String defaultValue) {
        if (url.getProtocol().equals("file")) {
            try {
                Path path = Paths.get(url.toURI());
                Path parent = path.getParent();
                return parent != null ? parent + File.separator : defaultValue;
            }
            catch (IOError | SecurityException | URISyntaxException e) {
                return defaultValue;
            }
        }
        String path = url.getPath();
        if (path.isEmpty()) {
            return defaultValue;
        }
        path = path.substring(0, path.lastIndexOf(47) + 1);
        int port = url.getPort();
        try {
            return new URL(url.getProtocol(), url.getHost(), port, path).toString();
        }
        catch (MalformedURLException e) {
            return defaultValue;
        }
    }

    private static String dirName(File file, String defaultValue) {
        String res = file.getParent();
        return res != null ? res + File.separator : defaultValue;
    }

    private static String baseName(String name, String defaultValue) {
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            idx = name.lastIndexOf(92);
        }
        return idx != -1 ? name.substring(0, idx + 1) : defaultValue;
    }

    private static char[] readFully(InputStream is, Charset cs) throws IOException {
        return cs != null ? new String(Source.readBytes(is), cs).toCharArray() : Source.readFully(is);
    }

    private static char[] readFully(InputStream is) throws IOException {
        return Source.byteToCharArray(Source.readBytes(is));
    }

    private static char[] byteToCharArray(byte[] bytes) {
        Charset cs = StandardCharsets.UTF_8;
        int start = 0;
        if (bytes.length > 1 && bytes[0] == -2 && bytes[1] == -1) {
            start = 2;
            cs = StandardCharsets.UTF_16BE;
        } else if (bytes.length > 1 && bytes[0] == -1 && bytes[1] == -2) {
            start = 2;
            cs = StandardCharsets.UTF_16LE;
        } else if (bytes.length > 2 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            start = 3;
            cs = StandardCharsets.UTF_8;
        } else if (bytes.length > 3 && bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
            start = 4;
            cs = Charset.forName("UTF-32LE");
        } else if (bytes.length > 3 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            start = 4;
            cs = Charset.forName("UTF-32BE");
        }
        return new String(bytes, start, bytes.length - start, cs).toCharArray();
    }

    /*
     * Loose catch block
     */
    static byte[] readBytes(InputStream is) throws IOException {
        byte[] arr = new byte[8192];
        try {
            try (ByteArrayOutputStream buf = new ByteArrayOutputStream();){
                int numBytes;
                while ((numBytes = is.read(arr, 0, arr.length)) > 0) {
                    buf.write(arr, 0, numBytes);
                }
                byte[] byArray = buf.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            is.close();
        }
    }

    public String toString() {
        return this.getName();
    }

    private static URL getURLFromFile(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (SecurityException | MalformedURLException ignored) {
            return null;
        }
    }
}

