/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.SwitchPoint;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import jdk.nashorn.internal.runtime.AccessorProperty;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyHashMap;
import jdk.nashorn.internal.runtime.PropertyListener;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.ScriptRuntime;
import jdk.nashorn.internal.runtime.UserAccessorProperty;
import jdk.nashorn.internal.runtime.arrays.ArrayIndex;

public final class PropertyMap
implements Iterable<Object>,
PropertyListener {
    public static final int NOT_EXTENSIBLE = 1;
    public static final int CONTAINS_ARRAY_KEYS = 2;
    private static final int CLONEABLE_FLAGS_MASK = 15;
    public static final int IS_LISTENER_ADDED = 16;
    public static final int IS_SHARED = 32;
    private int flags;
    private final PropertyHashMap properties;
    private int fieldCount;
    private int fieldMaximum;
    private int spillLength;
    private Map<String, SwitchPoint> protoGetSwitches;
    private HashMap<Property, PropertyMap> history;
    private WeakHashMap<ScriptObject, WeakReference<PropertyMap>> protoHistory;
    private int hashCode;
    private static int count;
    private static int clonedCount;
    private static int sharedCount;
    private static int duplicatedCount;
    private static int historyHit;
    private static int protoInvalidations;
    private static int protoHistoryHit;
    private static int setProtoNewMapCount;

    private PropertyMap(PropertyHashMap properties, int fieldCount, int fieldMaximum, int spillLength, boolean containsArrayKeys) {
        this.properties = properties;
        this.fieldCount = fieldCount;
        this.fieldMaximum = fieldMaximum;
        this.spillLength = spillLength;
        if (containsArrayKeys) {
            this.setContainsArrayKeys();
        }
        if (Context.DEBUG) {
            ++count;
        }
    }

    private PropertyMap(PropertyMap propertyMap, PropertyHashMap properties) {
        this.properties = properties;
        this.flags = propertyMap.getClonedFlags();
        this.spillLength = propertyMap.spillLength;
        this.fieldCount = propertyMap.fieldCount;
        this.fieldMaximum = propertyMap.fieldMaximum;
        if (Context.DEBUG) {
            ++count;
            ++clonedCount;
        }
    }

    private PropertyMap(PropertyMap propertyMap) {
        this(propertyMap, propertyMap.properties);
    }

    public PropertyMap duplicate() {
        if (Context.DEBUG) {
            ++duplicatedCount;
        }
        return new PropertyMap(this.properties, 0, 0, 0, this.containsArrayKeys());
    }

    public static PropertyMap newMap(Collection<Property> properties, int fieldCount, int fieldMaximum, int spillLength) {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP.immutableAdd(properties);
        return new PropertyMap(newProperties, fieldCount, fieldMaximum, spillLength, false);
    }

    public static PropertyMap newMap(Collection<Property> properties) {
        return properties == null || properties.isEmpty() ? PropertyMap.newMap() : PropertyMap.newMap(properties, 0, 0, 0);
    }

    public static PropertyMap newMap() {
        return new PropertyMap(PropertyHashMap.EMPTY_HASHMAP, 0, 0, 0, false);
    }

    public int size() {
        return this.properties.size();
    }

    public SwitchPoint getProtoGetSwitchPoint(ScriptObject proto, String key) {
        assert (!this.isShared()) : "proto SwitchPoint from a shared PropertyMap";
        if (proto == null) {
            return null;
        }
        if (this.protoGetSwitches == null) {
            this.protoGetSwitches = new HashMap<String, SwitchPoint>();
            if (!this.isListenerAdded()) {
                proto.addPropertyListener(this);
                this.setIsListenerAdded();
            }
        }
        if (this.protoGetSwitches.containsKey(key)) {
            return this.protoGetSwitches.get(key);
        }
        SwitchPoint switchPoint = new SwitchPoint();
        this.protoGetSwitches.put(key, switchPoint);
        return switchPoint;
    }

    private void invalidateProtoGetSwitchPoint(Property property) {
        String key;
        SwitchPoint sp;
        assert (!this.isShared()) : "proto invalidation on a shared PropertyMap";
        if (this.protoGetSwitches != null && (sp = this.protoGetSwitches.get(key = property.getKey())) != null) {
            this.protoGetSwitches.put(key, new SwitchPoint());
            if (Context.DEBUG) {
                ++protoInvalidations;
            }
            SwitchPoint.invalidateAll(new SwitchPoint[]{sp});
        }
    }

    private void invalidateAllProtoGetSwitchPoints() {
        assert (!this.isShared()) : "proto invalidation on a shared PropertyMap";
        if (this.protoGetSwitches != null) {
            Collection<SwitchPoint> sws = this.protoGetSwitches.values();
            SwitchPoint.invalidateAll(sws.toArray(new SwitchPoint[sws.size()]));
        }
    }

    PropertyMap addPropertyBind(AccessorProperty property, Object bindTo) {
        return this.addProperty(new AccessorProperty(property, bindTo));
    }

    public PropertyMap addProperty(Property property) {
        PropertyMap newMap = this.checkHistory(property);
        if (newMap == null) {
            PropertyHashMap newProperties = this.properties.immutableAdd(property);
            newMap = new PropertyMap(this, newProperties);
            this.addToHistory(property, newMap);
            if (!property.isSpill()) {
                newMap.fieldCount = Math.max(newMap.fieldCount, property.getSlot() + 1);
            }
            if (ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(property.getKey()))) {
                newMap.setContainsArrayKeys();
            }
            newMap.spillLength += property.getSpillCount();
        }
        return newMap;
    }

    public PropertyMap deleteProperty(Property property) {
        PropertyMap newMap = this.checkHistory(property);
        String key = property.getKey();
        if (newMap == null && this.properties.containsKey(key)) {
            PropertyHashMap newProperties = this.properties.immutableRemove(key);
            newMap = new PropertyMap(this, newProperties);
            this.addToHistory(property, newMap);
        }
        return newMap;
    }

    PropertyMap replaceProperty(Property oldProperty, Property newProperty) {
        boolean sameType;
        PropertyHashMap newProperties = this.properties.immutableAdd(newProperty);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        boolean bl = sameType = oldProperty.getClass() == newProperty.getClass();
        assert (sameType || oldProperty instanceof AccessorProperty && newProperty instanceof UserAccessorProperty) : "arbitrary replaceProperty attempted";
        newMap.flags = this.getClonedFlags();
        newMap.spillLength = this.spillLength + (sameType ? 0 : newProperty.getSpillCount());
        return newMap;
    }

    public UserAccessorProperty newUserAccessors(String key, int propertyFlags) {
        int oldSpillLength = this.spillLength;
        int getterSlot = oldSpillLength++;
        int setterSlot = oldSpillLength++;
        return new UserAccessorProperty(key, propertyFlags, getterSlot, setterSlot);
    }

    public Property findProperty(String key) {
        return this.properties.find(key);
    }

    public PropertyMap addAll(PropertyMap other) {
        assert (this != other) : "adding property map to itself";
        Property[] otherProperties = other.properties.getProperties();
        PropertyHashMap newProperties = this.properties.immutableAdd(otherProperties);
        PropertyMap newMap = new PropertyMap(this, newProperties);
        for (Property property : otherProperties) {
            if (ArrayIndex.isValidArrayIndex(ArrayIndex.getArrayIndex(property.getKey()))) {
                newMap.setContainsArrayKeys();
            }
            newMap.spillLength += property.getSpillCount();
        }
        return newMap;
    }

    public Property[] getProperties() {
        return this.properties.getProperties();
    }

    PropertyMap preventExtensions() {
        PropertyMap newMap = new PropertyMap(this);
        newMap.flags |= 1;
        return newMap;
    }

    PropertyMap seal() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP;
        for (Property oldProperty : this.properties.getProperties()) {
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(4));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 1;
        return newMap;
    }

    PropertyMap freeze() {
        PropertyHashMap newProperties = PropertyHashMap.EMPTY_HASHMAP;
        for (Property oldProperty : this.properties.getProperties()) {
            int propertyFlags = 4;
            if (!(oldProperty instanceof UserAccessorProperty)) {
                propertyFlags |= 1;
            }
            newProperties = newProperties.immutableAdd(oldProperty.addFlags(propertyFlags));
        }
        PropertyMap newMap = new PropertyMap(this, newProperties);
        newMap.flags |= 1;
        return newMap;
    }

    public PropertyMap setIsShared() {
        assert (!this.isListenerAdded()) : "making PropertyMap shared after listener added";
        assert (this.protoHistory == null) : "making PropertyMap shared after associating a proto with it";
        if (Context.DEBUG) {
            ++sharedCount;
        }
        this.flags |= 0x20;
        this.history = null;
        return this;
    }

    private boolean anyConfigurable() {
        for (Property property : this.properties.getProperties()) {
            if (!property.isConfigurable()) continue;
            return true;
        }
        return false;
    }

    private boolean allFrozen() {
        for (Property property : this.properties.getProperties()) {
            if (!(property instanceof UserAccessorProperty) && property.isWritable()) {
                return false;
            }
            if (!property.isConfigurable()) continue;
            return false;
        }
        return true;
    }

    private PropertyMap checkProtoHistory(ScriptObject newProto) {
        WeakReference<PropertyMap> weakMap;
        PropertyMap cachedMap = this.protoHistory != null ? ((weakMap = this.protoHistory.get(newProto)) != null ? (PropertyMap)weakMap.get() : null) : null;
        if (Context.DEBUG && cachedMap != null) {
            ++protoHistoryHit;
        }
        return cachedMap;
    }

    private void addToProtoHistory(ScriptObject newProto, PropertyMap newMap) {
        assert (!this.isShared()) : "proto history modified on a shared PropertyMap";
        if (this.protoHistory == null) {
            this.protoHistory = new WeakHashMap();
        }
        this.protoHistory.put(newProto, new WeakReference<PropertyMap>(newMap));
    }

    private void addToHistory(Property property, PropertyMap newMap) {
        assert (!this.isShared()) : "history modified on a shared PropertyMap";
        if (!this.properties.isEmpty()) {
            if (this.history == null) {
                this.history = new LinkedHashMap<Property, PropertyMap>();
            }
            this.history.put(property, newMap);
        }
    }

    private PropertyMap checkHistory(Property property) {
        PropertyMap historicMap;
        if (this.history != null && (historicMap = this.history.get(property)) != null) {
            if (Context.DEBUG) {
                ++historyHit;
            }
            return historicMap;
        }
        return null;
    }

    private int computeHashCode() {
        int hash = 0;
        for (Property property : this.getProperties()) {
            hash = hash << 7 ^ hash >> 7;
            hash ^= property.hashCode();
        }
        return hash;
    }

    public int hashCode() {
        if (this.hashCode == 0 && !this.properties.isEmpty()) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PropertyMap)) {
            return false;
        }
        PropertyMap otherMap = (PropertyMap)other;
        if (this.properties.size() != otherMap.properties.size()) {
            return false;
        }
        Iterator<Property> iter = this.properties.values().iterator();
        Iterator<Property> otherIter = otherMap.properties.values().iterator();
        while (iter.hasNext() && otherIter.hasNext()) {
            if (iter.next().equals(otherIter.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" [");
        boolean isFirst = true;
        for (Property property : this.properties.values()) {
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(ScriptRuntime.safeToString(property.getKey()));
            Class<?> ctype = property.getCurrentType();
            sb.append(" <").append(property.getClass().getSimpleName()).append(':').append(ctype == null ? "undefined" : ctype.getSimpleName()).append('>');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<Object> iterator() {
        return new PropertyMapIterator(this);
    }

    public final boolean containsArrayKeys() {
        return (this.flags & 2) != 0;
    }

    private void setContainsArrayKeys() {
        this.flags |= 2;
    }

    public boolean isListenerAdded() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isShared() {
        return (this.flags & 0x20) != 0;
    }

    boolean isExtensible() {
        return (this.flags & 1) == 0;
    }

    boolean isSealed() {
        return !this.isExtensible() && !this.anyConfigurable();
    }

    boolean isFrozen() {
        return !this.isExtensible() && this.allFrozen();
    }

    int getFieldCount() {
        return this.fieldCount;
    }

    int getFieldMaximum() {
        return this.fieldMaximum;
    }

    int getSpillLength() {
        return this.spillLength;
    }

    PropertyMap changeProto(ScriptObject oldProto, ScriptObject newProto) {
        assert (!this.isShared()) : "proto associated with a shared PropertyMap";
        if (oldProto == newProto) {
            return this;
        }
        PropertyMap nextMap = this.checkProtoHistory(newProto);
        if (nextMap != null) {
            return nextMap;
        }
        if (Context.DEBUG) {
            PropertyMap.incrementSetProtoNewMapCount();
        }
        PropertyMap newMap = new PropertyMap(this);
        this.addToProtoHistory(newProto, newMap);
        return newMap;
    }

    private void setIsListenerAdded() {
        this.flags |= 0x10;
    }

    private int getClonedFlags() {
        return this.flags & 0xF;
    }

    @Override
    public void propertyAdded(ScriptObject object, Property prop) {
        this.invalidateProtoGetSwitchPoint(prop);
    }

    @Override
    public void propertyDeleted(ScriptObject object, Property prop) {
        this.invalidateProtoGetSwitchPoint(prop);
    }

    @Override
    public void propertyModified(ScriptObject object, Property oldProp, Property newProp) {
        this.invalidateProtoGetSwitchPoint(oldProp);
    }

    @Override
    public void protoChanged(ScriptObject object, ScriptObject oldProto, ScriptObject newProto) {
        this.invalidateAllProtoGetSwitchPoints();
    }

    public static int getCount() {
        return count;
    }

    public static int getClonedCount() {
        return clonedCount;
    }

    public static int getSharedCount() {
        return sharedCount;
    }

    public static int getDuplicatedCount() {
        return duplicatedCount;
    }

    public static int getHistoryHit() {
        return historyHit;
    }

    public static int getProtoInvalidations() {
        return protoInvalidations;
    }

    public static int getProtoHistoryHit() {
        return protoHistoryHit;
    }

    public static int getSetProtoNewMapCount() {
        return setProtoNewMapCount;
    }

    private static void incrementSetProtoNewMapCount() {
        ++setProtoNewMapCount;
    }

    private static class PropertyMapIterator
    implements Iterator<Object> {
        final Iterator<Property> iter;
        Property property;

        PropertyMapIterator(PropertyMap propertyMap) {
            this.iter = Arrays.asList(propertyMap.properties.getProperties()).iterator();
            this.property = this.iter.hasNext() ? this.iter.next() : null;
            this.skipNotEnumerable();
        }

        private void skipNotEnumerable() {
            while (this.property != null && !this.property.isEnumerable()) {
                this.property = this.iter.hasNext() ? this.iter.next() : null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.property != null;
        }

        @Override
        public Object next() {
            if (this.property == null) {
                throw new NoSuchElementException();
            }
            String key = this.property.getKey();
            this.property = this.iter.next();
            this.skipNotEnumerable();
            return key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

