/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.HashMap;
import java.util.Map;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Symbol;

public class TemporarySymbols {
    private static final String prefix = CompilerConstants.TEMP_PREFIX.symbolName() + "$";
    private int totalSymbolCount;
    private final Map<Type, TypedTemporarySymbols> temporarySymbolsByType = new HashMap<Type, TypedTemporarySymbols>();

    public Expression ensureSymbol(LexicalContext lc, Type type, Expression node) {
        Symbol symbol = node.getSymbol();
        if (symbol != null) {
            return node;
        }
        return node.setSymbol(lc, this.getTypedTemporarySymbol(type));
    }

    public Symbol getTypedTemporarySymbol(Type type) {
        return this.getTypedTemporarySymbols(type).getTemporarySymbol(type);
    }

    private TypedTemporarySymbols getTypedTemporarySymbols(Type type) {
        TypedTemporarySymbols temporarySymbols = this.temporarySymbolsByType.get(type);
        if (temporarySymbols == null) {
            temporarySymbols = new TypedTemporarySymbols();
            this.temporarySymbolsByType.put(type, temporarySymbols);
        }
        return temporarySymbols;
    }

    public void reuse() {
        for (TypedTemporarySymbols ts : this.temporarySymbolsByType.values()) {
            ts.reuse();
        }
    }

    public Symbol createUnshared(Symbol symbol) {
        return symbol.createUnshared(this.getUniqueName());
    }

    private String getUniqueName() {
        return prefix + ++this.totalSymbolCount;
    }

    public int getTotalSymbolCount() {
        return this.totalSymbolCount;
    }

    private class TypedTemporarySymbols {
        private Symbol[] symbols = new Symbol[16];
        private int nextFreeSymbol = 0;
        private int symbolCount = 0;

        private TypedTemporarySymbols() {
        }

        Symbol getTemporarySymbol(Type type) {
            while (this.nextFreeSymbol < this.symbolCount) {
                Symbol nextSymbol = this.symbols[this.nextFreeSymbol];
                assert (nextSymbol != null);
                if (!nextSymbol.hasSlot()) {
                    Type symbolType = nextSymbol.getSymbolType();
                    if (symbolType == type) {
                        assert (nextSymbol.isTemp());
                        assert (!nextSymbol.isScope());
                        nextSymbol.setIsShared();
                        ++this.nextFreeSymbol;
                        return nextSymbol;
                    }
                    TemporarySymbols.this.getTypedTemporarySymbols(symbolType).addSymbol(nextSymbol);
                }
                --this.symbolCount;
                if (this.symbolCount != this.nextFreeSymbol) {
                    Symbol lastFreeSymbol;
                    this.symbols[this.nextFreeSymbol] = lastFreeSymbol = this.symbols[this.symbolCount];
                }
                this.symbols[this.symbolCount] = null;
            }
            return this.createNewSymbol(type);
        }

        private Symbol createNewSymbol(Type type) {
            this.ensureCapacity();
            Symbol symbol = this.symbols[this.nextFreeSymbol] = new Symbol(TemporarySymbols.this.getUniqueName(), 1, type);
            ++this.nextFreeSymbol;
            ++this.symbolCount;
            return symbol;
        }

        private void addSymbol(Symbol symbol) {
            this.ensureCapacity();
            this.symbols[this.symbolCount++] = symbol;
        }

        void reuse() {
            this.nextFreeSymbol = 0;
        }

        private void ensureCapacity() {
            if (this.symbolCount == this.symbols.length) {
                Symbol[] newSymbols = new Symbol[this.symbolCount * 2];
                System.arraycopy(this.symbols, 0, newSymbols, 0, this.symbolCount);
                this.symbols = newSymbols;
            }
        }
    }
}

