/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public class ContinueNode
extends Statement {
    private IdentNode label;

    public ContinueNode(int lineNumber, long token, int finish, IdentNode label) {
        super(lineNumber, token, finish);
        this.label = label;
    }

    @Override
    public boolean hasGoto() {
        return true;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterContinueNode(this)) {
            return visitor.leaveContinueNode(this);
        }
        return this;
    }

    public IdentNode getLabel() {
        return this.label;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append("continue");
        if (this.label != null) {
            sb.append(' ');
            this.label.toString(sb);
        }
    }
}

