/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.io.File;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import jdk.internal.dynalink.support.NameCodec;
import jdk.nashorn.internal.codegen.ClassEmitter;
import jdk.nashorn.internal.codegen.CompilationException;
import jdk.nashorn.internal.codegen.CompilationPhase;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.ConstantData;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.TemporarySymbols;
import jdk.nashorn.internal.ir.debug.ClassHistogramElement;
import jdk.nashorn.internal.ir.debug.ObjectSizeCalculator;
import jdk.nashorn.internal.runtime.CodeInstaller;
import jdk.nashorn.internal.runtime.DebugLogger;
import jdk.nashorn.internal.runtime.ScriptEnvironment;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.Timing;
import jdk.nashorn.internal.runtime.options.Options;
import jdk.nashorn.internal.scripts.JS;

public final class Compiler {
    public static final String SCRIPTS_PACKAGE = "jdk/nashorn/internal/scripts";
    public static final String OBJECTS_PACKAGE = "jdk/nashorn/internal/objects";
    private Source source;
    private final Map<String, byte[]> bytecode;
    private final Set<CompileUnit> compileUnits;
    private final ConstantData constantData;
    private final CompilationSequence sequence;
    private final ScriptEnvironment env;
    private String scriptName;
    private boolean strict;
    private final CodeInstaller<ScriptEnvironment> installer;
    private final TemporarySymbols temporarySymbols = new TemporarySymbols();
    public static final DebugLogger LOG = new DebugLogger("compiler");
    private static String[] RESERVED_NAMES = new String[]{CompilerConstants.SCOPE.symbolName(), CompilerConstants.THIS.symbolName(), CompilerConstants.RETURN.symbolName(), CompilerConstants.CALLEE.symbolName(), CompilerConstants.VARARGS.symbolName(), CompilerConstants.ARGUMENTS.symbolName()};
    static final CompilationSequence SEQUENCE_EAGER = new CompilationSequence(CompilationPhase.CONSTANT_FOLDING_PHASE, CompilationPhase.LOWERING_PHASE, CompilationPhase.ATTRIBUTION_PHASE, CompilationPhase.RANGE_ANALYSIS_PHASE, CompilationPhase.SPLITTING_PHASE, CompilationPhase.TYPE_FINALIZATION_PHASE, CompilationPhase.BYTECODE_GENERATION_PHASE);
    static final CompilationSequence SEQUENCE_LAZY = SEQUENCE_EAGER.insertFirst(CompilationPhase.LAZY_INITIALIZATION_PHASE);
    private static final boolean USE_INT_ARITH = Options.getBooleanProperty("nashorn.compiler.intarithmetic");

    private static CompilationSequence sequence(boolean lazy) {
        return lazy ? SEQUENCE_LAZY : SEQUENCE_EAGER;
    }

    boolean isLazy() {
        return this.sequence == SEQUENCE_LAZY;
    }

    private static String lazyTag(FunctionNode functionNode) {
        if (functionNode.isLazy()) {
            return '$' + CompilerConstants.LAZY.symbolName() + '$' + functionNode.getName();
        }
        return "";
    }

    Compiler(ScriptEnvironment env, CodeInstaller<ScriptEnvironment> installer, CompilationSequence sequence, boolean strict) {
        this.env = env;
        this.sequence = sequence;
        this.installer = installer;
        this.constantData = new ConstantData();
        this.compileUnits = new TreeSet<CompileUnit>();
        this.bytecode = new LinkedHashMap<String, byte[]>();
    }

    private void initCompiler(FunctionNode functionNode) {
        this.strict = this.strict || functionNode.isStrict();
        StringBuilder sb = new StringBuilder();
        sb.append(functionNode.uniqueName(CompilerConstants.DEFAULT_SCRIPT_NAME.symbolName() + Compiler.lazyTag(functionNode))).append('$').append(this.safeSourceName(functionNode.getSource()));
        this.source = functionNode.getSource();
        this.scriptName = sb.toString();
    }

    public Compiler(CodeInstaller<ScriptEnvironment> installer, boolean strict) {
        this(installer.getOwner(), installer, Compiler.sequence(installer.getOwner()._lazy_compilation), strict);
    }

    public Compiler(CodeInstaller<ScriptEnvironment> installer) {
        this(installer.getOwner(), installer, Compiler.sequence(installer.getOwner()._lazy_compilation), installer.getOwner()._strict);
    }

    public Compiler(ScriptEnvironment env) {
        this(env, null, Compiler.sequence(env._lazy_compilation), env._strict);
    }

    private static void printMemoryUsage(String phaseName, FunctionNode functionNode) {
        LOG.info(phaseName + " finished. Doing IR size calculation...");
        ObjectSizeCalculator osc = new ObjectSizeCalculator(ObjectSizeCalculator.getEffectiveMemoryLayoutSpecification());
        osc.calculateObjectSize(functionNode);
        List<ClassHistogramElement> list = osc.getClassHistogram();
        StringBuilder sb = new StringBuilder();
        long totalSize = osc.calculateObjectSize(functionNode);
        sb.append(phaseName).append(" Total size = ").append(totalSize / 1024L / 1024L).append("MB");
        LOG.info(sb);
        Collections.sort(list, new Comparator<ClassHistogramElement>(){

            @Override
            public int compare(ClassHistogramElement o1, ClassHistogramElement o2) {
                long diff = o1.getBytes() - o2.getBytes();
                if (diff < 0L) {
                    return 1;
                }
                if (diff > 0L) {
                    return -1;
                }
                return 0;
            }
        });
        for (ClassHistogramElement e : list) {
            String line = String.format("    %-48s %10d bytes (%8d instances)", e.getClazz(), e.getBytes(), e.getInstances());
            LOG.info(line);
            if (e.getBytes() >= totalSize / 200L) continue;
            LOG.info("    ...");
            break;
        }
    }

    public FunctionNode compile(FunctionNode functionNode) throws CompilationException {
        FunctionNode newFunctionNode = functionNode;
        this.initCompiler(newFunctionNode);
        for (String reservedName : RESERVED_NAMES) {
            newFunctionNode.uniqueName(reservedName);
        }
        boolean fine = !LOG.levelAbove(Level.FINE);
        boolean info = !LOG.levelAbove(Level.INFO);
        long time = 0L;
        for (CompilationPhase phase : this.sequence) {
            newFunctionNode = phase.apply(this, newFunctionNode);
            if (this.env._print_mem_usage) {
                Compiler.printMemoryUsage(phase.toString(), newFunctionNode);
            }
            long duration = Timing.isEnabled() ? phase.getEndTime() - phase.getStartTime() : 0L;
            time += duration;
            if (!fine) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(phase.toString()).append(" done for function '").append(newFunctionNode.getName()).append('\'');
            if (duration > 0L) {
                sb.append(" in ").append(duration).append(" ms ");
            }
            LOG.fine(sb);
        }
        if (info) {
            StringBuilder sb = new StringBuilder();
            sb.append("Compile job for '").append(newFunctionNode.getSource()).append(':').append(newFunctionNode.getName()).append("' finished");
            if (time > 0L) {
                sb.append(" in ").append(time).append(" ms");
            }
            LOG.info(sb);
        }
        return newFunctionNode;
    }

    private Class<?> install(String className, byte[] code) {
        LOG.fine("Installing class ", className);
        final Class<?> clazz = this.installer.install(Compiler.binaryName(className), code);
        try {
            final Object[] constants = this.getConstantData().toArray();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Field sourceField = clazz.getDeclaredField(CompilerConstants.SOURCE.symbolName());
                    Field constantsField = clazz.getDeclaredField(CompilerConstants.CONSTANTS.symbolName());
                    sourceField.setAccessible(true);
                    constantsField.setAccessible(true);
                    sourceField.set(null, Compiler.this.source);
                    constantsField.set(null, constants);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    public Class<?> install(FunctionNode functionNode) {
        StringBuilder sb;
        long t0;
        long l = t0 = Timing.isEnabled() ? System.currentTimeMillis() : 0L;
        assert (functionNode.hasState(FunctionNode.CompilationState.EMITTED)) : functionNode.getName() + " has no bytecode and cannot be installed";
        HashMap installedClasses = new HashMap();
        String rootClassName = this.firstCompileUnitName();
        byte[] rootByteCode = this.bytecode.get(rootClassName);
        Class<?> rootClass = this.install(rootClassName, rootByteCode);
        int length = rootByteCode.length;
        installedClasses.put(rootClassName, rootClass);
        for (Map.Entry<String, byte[]> entry : this.bytecode.entrySet()) {
            String className = entry.getKey();
            if (className.equals(rootClassName)) continue;
            byte[] code = entry.getValue();
            length += code.length;
            installedClasses.put(className, this.install(className, code));
        }
        for (CompileUnit unit : this.compileUnits) {
            unit.setCode((Class)installedClasses.get(unit.getUnitClassName()));
        }
        if (LOG.isEnabled()) {
            sb = new StringBuilder();
            sb.append("Installed class '").append(rootClass.getSimpleName()).append('\'').append(" bytes=").append(length).append('.');
            if (this.bytecode.size() > 1) {
                sb.append(' ').append(this.bytecode.size()).append(" compile units.");
            }
        } else {
            sb = null;
        }
        if (Timing.isEnabled()) {
            long duration = System.currentTimeMillis() - t0;
            Timing.accumulateTime("[Code Installation]", duration);
            if (sb != null) {
                sb.append(" Install time: ").append(duration).append(" ms");
            }
        }
        if (sb != null) {
            LOG.fine(sb);
        }
        return rootClass;
    }

    Set<CompileUnit> getCompileUnits() {
        return this.compileUnits;
    }

    boolean getStrictMode() {
        return this.strict;
    }

    void setStrictMode(boolean strict) {
        this.strict = strict;
    }

    ConstantData getConstantData() {
        return this.constantData;
    }

    CodeInstaller<ScriptEnvironment> getCodeInstaller() {
        return this.installer;
    }

    TemporarySymbols getTemporarySymbols() {
        return this.temporarySymbols;
    }

    void addClass(String name, byte[] code) {
        this.bytecode.put(name, code);
    }

    ScriptEnvironment getEnv() {
        return this.env;
    }

    private String safeSourceName(Source src) {
        String mangled;
        String baseName = new File(src.getName()).getName();
        int index = baseName.lastIndexOf(".js");
        if (index != -1) {
            baseName = baseName.substring(0, index);
        }
        baseName = baseName.replace('.', '_').replace('-', '_');
        if (!this.env._loader_per_compile) {
            baseName = baseName + this.installer.getUniqueScriptId();
        }
        return (mangled = NameCodec.encode(baseName)) != null ? mangled : baseName;
    }

    private int nextCompileUnitIndex() {
        return this.compileUnits.size() + 1;
    }

    String firstCompileUnitName() {
        return "jdk/nashorn/internal/scripts/" + this.scriptName;
    }

    private String nextCompileUnitName() {
        return this.firstCompileUnitName() + '$' + this.nextCompileUnitIndex();
    }

    CompileUnit addCompileUnit(long initialWeight) {
        return this.addCompileUnit(this.nextCompileUnitName(), initialWeight);
    }

    CompileUnit addCompileUnit(String unitClassName) {
        return this.addCompileUnit(unitClassName, 0L);
    }

    private CompileUnit addCompileUnit(String unitClassName, long initialWeight) {
        CompileUnit compileUnit = this.initCompileUnit(unitClassName, initialWeight);
        this.compileUnits.add(compileUnit);
        LOG.fine("Added compile unit ", compileUnit);
        return compileUnit;
    }

    private CompileUnit initCompileUnit(String unitClassName, long initialWeight) {
        ClassEmitter classEmitter = new ClassEmitter(this.env, this.source.getName(), unitClassName, this.strict);
        CompileUnit compileUnit = new CompileUnit(unitClassName, classEmitter, initialWeight);
        classEmitter.begin();
        MethodEmitter initMethod = classEmitter.init(EnumSet.of(ClassEmitter.Flag.PRIVATE), new Class[0]);
        initMethod.begin();
        initMethod.load(Type.OBJECT, 0);
        initMethod.newInstance(JS.class);
        initMethod.returnVoid();
        initMethod.end();
        return compileUnit;
    }

    CompileUnit findUnit(long weight) {
        for (CompileUnit unit : this.compileUnits) {
            if (!unit.canHold(weight)) continue;
            unit.addWeight(weight);
            return unit;
        }
        return this.addCompileUnit(weight);
    }

    public static String binaryName(String name) {
        return name.replace('/', '.');
    }

    static boolean shouldUseIntegerArithmetic() {
        return USE_INT_ARITH;
    }

    static {
        assert (!USE_INT_ARITH) : "Integer arithmetic is not enabled";
    }

    public static class Hints {
        private final Type[] paramTypes;
        public static final Hints EMPTY = new Hints();

        private Hints() {
            this.paramTypes = null;
        }

        public Hints(Type[] paramTypes) {
            this.paramTypes = paramTypes;
        }

        public Type getParameterType(int pos) {
            if (this.paramTypes != null && pos < this.paramTypes.length) {
                return this.paramTypes[pos];
            }
            return null;
        }
    }

    static class CompilationSequence
    extends LinkedList<CompilationPhase> {
        CompilationSequence(CompilationPhase ... phases) {
            super(Arrays.asList(phases));
        }

        CompilationSequence(CompilationSequence sequence) {
            this(sequence.toArray(new CompilationPhase[sequence.size()]));
        }

        CompilationSequence insertAfter(CompilationPhase phase, CompilationPhase newPhase) {
            CompilationSequence newSeq = new CompilationSequence(new CompilationPhase[0]);
            for (CompilationPhase elem : this) {
                newSeq.add(phase);
                if (!elem.equals((Object)phase)) continue;
                newSeq.add(newPhase);
            }
            assert (newSeq.contains((Object)newPhase));
            return newSeq;
        }

        CompilationSequence insertBefore(CompilationPhase phase, CompilationPhase newPhase) {
            CompilationSequence newSeq = new CompilationSequence(new CompilationPhase[0]);
            for (CompilationPhase elem : this) {
                if (elem.equals((Object)phase)) {
                    newSeq.add(newPhase);
                }
                newSeq.add(phase);
            }
            assert (newSeq.contains((Object)newPhase));
            return newSeq;
        }

        CompilationSequence insertFirst(CompilationPhase phase) {
            CompilationSequence newSeq = new CompilationSequence(this);
            newSeq.addFirst(phase);
            return newSeq;
        }

        CompilationSequence insertLast(CompilationPhase phase) {
            CompilationSequence newSeq = new CompilationSequence(this);
            newSeq.addLast(phase);
            return newSeq;
        }
    }
}

