/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.Config;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.net.URLPermission;
import java.security.AccessControlContext;
import java.security.Permission;
import java.util.HashSet;
import sun.plugin2.applet.SecurityManagerHelper;

public class FXAppletSecurityManager
extends SecurityManager {
    private AppContext mainAppContext;
    private static Field facc = null;
    private static Field fcontext = null;
    private SecurityManager fxSM = new SecurityManager();
    private HashSet restrictedPackages = new HashSet();

    public FXAppletSecurityManager() {
        SecurityManagerHelper.resetHelper(this.restrictedPackages);
        this.mainAppContext = ToolkitStore.get().getAppContext();
    }

    public void checkConnect(String string, int n) {
        SecurityManagerHelper.checkConnectHelper(this.fxSM, string, n, null, false, this.getClassContext());
    }

    public void checkConnect(String string, int n, Object object) {
        SecurityManagerHelper.checkConnectHelper(this.fxSM, string, n, object, true, this.getClassContext());
    }

    public void checkPermission(Permission permission) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.fxSM, permission, null, false, this.getClassContext());
            return;
        }
        super.checkPermission(permission);
        SecurityManagerHelper.checkPermissionHelper(permission);
    }

    public void checkPermission(Permission permission, Object object) {
        if (Config.isJavaVersionAtLeast18() && permission instanceof URLPermission) {
            SecurityManagerHelper.checkURLPermissionHelper(this.fxSM, permission, object, true, this.getClassContext());
            return;
        }
        super.checkPermission(permission, object);
    }

    public void checkAccess(Thread thread) {
        SecurityManagerHelper.checkAccessHelper(thread, this.fxSM, this.currentClassLoaderSafe(), (Class[])this.getClassContext(), facc, fcontext);
    }

    public void checkAccess(ThreadGroup threadGroup) {
        SecurityManagerHelper.checkAccessHelper(threadGroup, this.fxSM, this.currentClassLoaderSafe(), (Class[])this.getClassContext(), facc, fcontext);
    }

    public void checkAwtEventQueueAccess() {
        SecurityManagerHelper.checkAwtEventQueueAccessHelper(this.fxSM, this.mainAppContext, this.currentClassLoader(), this.getClassContext(), facc, fcontext);
    }

    public void checkPackageAccess(String string) {
        SecurityManagerHelper.checkPackageAccessHelper(this.fxSM, string, this.restrictedPackages);
    }

    public void checkPrintJobAccess() {
        SecurityManagerHelper.checkPrintJobAccessHelper(this.fxSM);
    }

    public void checkSecurityAccess(String string) {
        SecurityManagerHelper.checkSecurityAccessHelper(this.fxSM, string);
    }

    public AppContext getAppContext() {
        return SecurityManagerHelper.getAppContextHelper(this.currentClassLoader(), this.getClassContext(), facc, fcontext);
    }

    public ThreadGroup getThreadGroup() {
        return SecurityManagerHelper.getThreadGroupHelper(this.fxSM, this.currentClassLoaderSafe(), this.getClassContext(), facc, fcontext);
    }

    public boolean checkTopLevelWindow(Object object) {
        if (object == null) {
            throw new NullPointerException("window can't be null");
        }
        return super.checkTopLevelWindow(object);
    }

    private ClassLoader currentClassLoaderSafe() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    static {
        try {
            facc = URLClassLoader.class.getDeclaredField("acc");
            facc.setAccessible(true);
            fcontext = AccessControlContext.class.getDeclaredField("context");
            fcontext.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new UnsupportedOperationException(noSuchFieldException);
        }
    }
}

