/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.ProviderException;
import java.util.Arrays;

final class GHASH {
    private static final byte P128 = -31;
    private final byte[] subkeyH;
    private byte[] state;
    private byte[] stateSave = null;

    private static boolean getBit(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = byArray[n2] >>> 7 - (n %= 8) & 1;
        return n3 != 0;
    }

    private static void shift(byte[] byArray) {
        byte by = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by2 = (byte)((byArray[i] & 1) << 7);
            byArray[i] = (byte)((byArray[i] & 0xFF) >>> 1);
            byArray[i] = (byte)(byArray[i] | by);
            by = by2;
        }
    }

    private static byte[] blockMult(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray.length != 16 || byArray2.length != 16) {
            throw new RuntimeException("illegal input sizes");
        }
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = (byte[])byArray2.clone();
        for (n = 0; n < 127; ++n) {
            int n2;
            if (GHASH.getBit(byArray, n)) {
                for (n2 = 0; n2 < byArray3.length; ++n2) {
                    int n3 = n2;
                    byArray3[n3] = (byte)(byArray3[n3] ^ byArray4[n2]);
                }
            }
            n2 = GHASH.getBit(byArray4, 127);
            GHASH.shift(byArray4);
            if (n2 == 0) continue;
            byArray4[0] = (byte)(byArray4[0] ^ 0xFFFFFFE1);
        }
        if (GHASH.getBit(byArray, 127)) {
            for (n = 0; n < byArray3.length; ++n) {
                int n4 = n;
                byArray3[n4] = (byte)(byArray3[n4] ^ byArray4[n]);
            }
        }
        return byArray3;
    }

    GHASH(byte[] byArray) throws ProviderException {
        if (byArray == null || byArray.length != 16) {
            throw new ProviderException("Internal error");
        }
        this.subkeyH = byArray;
        this.state = new byte[16];
    }

    void reset() {
        Arrays.fill(this.state, (byte)0);
    }

    void save() {
        this.stateSave = (byte[])this.state.clone();
    }

    void restore() {
        this.state = this.stateSave;
    }

    private void processBlock(byte[] byArray, int n) {
        if (byArray.length - n < 16) {
            throw new RuntimeException("need complete block");
        }
        for (int i = 0; i < this.state.length; ++i) {
            int n2 = i;
            this.state[n2] = (byte)(this.state[n2] ^ byArray[n + i]);
        }
        this.state = GHASH.blockMult(this.state, this.subkeyH);
    }

    void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    void update(byte[] byArray, int n, int n2) {
        if (n2 - n > byArray.length) {
            throw new RuntimeException("input length out of bound");
        }
        if (n2 % 16 != 0) {
            throw new RuntimeException("input length unsupported");
        }
        for (int i = n; i < n + n2; i += 16) {
            this.processBlock(byArray, i);
        }
    }

    byte[] digest() {
        try {
            byte[] byArray = (byte[])this.state.clone();
            return byArray;
        }
        finally {
            this.reset();
        }
    }
}

