/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class DeployManifestChecker {
    private static final String PERMISSIONS_ATTR = "Permissions";
    private static final String CODEBASE_ATTR = "Codebase";
    private static final String NAME_ATTR = "Application-Name";
    private static final String LIBRARY_CODEBASE_ATTR = "Application-Library-Allowable-Codebase";
    private static final String SANDBOX_VALUE = "sandbox";
    private static final String ALLPERMS_VALUE = "all-permissions";
    private static final String JARJNLP_SUFFIX = ".jarjnlp";
    private static final String JAR_SUFFIX = ".jar";

    private DeployManifestChecker() {
    }

    public static void verify(DeploymentRuleSet deploymentRuleSet, URL uRL, boolean bl, AppInfo appInfo) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            DeployManifestChecker.verify(deploymentRuleSet, uRL, jarFile.getManifest().getMainAttributes(), bl, appInfo);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    public static void verifyMainJar(DeploymentRuleSet deploymentRuleSet, URL uRL, boolean bl, AppInfo appInfo) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            DeployManifestChecker.verifyMainJar(deploymentRuleSet, uRL, jarFile.getManifest().getMainAttributes(), bl, appInfo);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    static void verifyMainJar(DeploymentRuleSet deploymentRuleSet, URL uRL, Attributes attributes, boolean bl, AppInfo appInfo) {
        String string = attributes.getValue(PERMISSIONS_ATTR);
        if (string == null) {
            if (deploymentRuleSet.isPermissionsManifestRequired()) {
                throw new SecurityException("Missing required Permissions manifest attribute in main jar: " + uRL);
            }
            Trace.println("Missing Permissions manifest attribute in main jar: " + uRL);
        }
    }

    public static int getPermissionRequestType(URL uRL, String string) {
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return 0;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            String string2 = attributes.getValue(PERMISSIONS_ATTR);
            if (string2 != null) {
                if (string2.equals(SANDBOX_VALUE)) {
                    return 1;
                }
                if (string2.equals(ALLPERMS_VALUE)) {
                    return 2;
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return 0;
    }

    static void verify(DeploymentRuleSet deploymentRuleSet, URL uRL, Attributes attributes, boolean bl, AppInfo appInfo) {
        String string;
        if (appInfo != null && !appInfo.hasSignedJNLP()) {
            string = attributes.getValue(NAME_ATTR);
            if (string == null) {
                string = attributes.getValue(Attributes.Name.MAIN_CLASS);
            }
            appInfo.setTitle(string);
        }
        string = attributes.getValue(PERMISSIONS_ATTR);
        if (appInfo != null) {
            appInfo.setPermissionAttr(string != null);
        }
        if (SANDBOX_VALUE.equals(string)) {
            if (bl) {
                throw new SecurityException("JAR manifest requested to run in sandbox only: " + uRL);
            }
        } else if (ALLPERMS_VALUE.equals(string)) {
            if (!bl) {
                throw new SecurityException("JAR manifest requested to run in all-permissons only: " + uRL);
            }
        } else if (string != null) {
            throw new SecurityException("Invalid Permissions value: " + string);
        }
        if ((string = attributes.getValue(CODEBASE_ATTR)) == null) {
            Trace.println("Missing Codebase manifest attribute for: " + uRL, TraceLevel.SECURITY);
        } else if (!DeployManifestChecker.verifyCodebase(uRL, string, false)) {
            throw new SecurityException("JAR manifest codebase mismatch for " + uRL);
        }
        string = attributes.getValue(LIBRARY_CODEBASE_ATTR);
        if (string == null) {
            Trace.println("Missing Application-Library-Allowable-Codebase manifest attribute for: " + uRL, TraceLevel.SECURITY);
        } else if (!DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(uRL, appInfo)) {
            throw new SecurityException("JAR manifest application-library-allowable-codebase  mismatch for " + uRL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean verifyCodebase(URL uRL, String string, boolean bl) {
        String string2 = uRL.getHost();
        String string3 = uRL.getProtocol();
        int n = uRL.getPort();
        String[] stringArray = string.split("\\s");
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            String string4 = null;
            String string5 = null;
            URL uRL2 = null;
            try {
                uRL2 = new URL(stringArray[i]);
                string4 = uRL2.getHost();
                string5 = uRL2.getProtocol();
                n2 = uRL2.getPort();
            }
            catch (MalformedURLException malformedURLException) {
                string4 = stringArray[i];
                int n3 = string4.indexOf(":");
                if (n3 == -1) {
                    n2 = -1;
                }
                string4 = stringArray[i].substring(0, n3);
                n2 = Integer.parseInt(stringArray[i].substring(n3 + 1));
            }
            if (n2 == -1) {
                bl4 = true;
            } else if (n2 == n) {
                bl4 = true;
            }
            if (string5 != null) {
                if (string5.equals(string3)) {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (string4.equals("*")) {
                bl3 = true;
            } else if (string4.indexOf("*") != -1) {
                if (!string4.startsWith("*.")) throw new SecurityException("Invalid Codebase value: " + stringArray[i]);
                String string6 = string4.substring(2);
                if (string2.endsWith(string6)) {
                    bl3 = true;
                }
            } else if (string4.equals(string2)) {
                bl3 = true;
            }
            if (bl2 && bl3 && bl4) {
                if (!bl || !"http".equals(uRL.getProtocol()) || "http".equals(string5)) return true;
                Trace.println("Javascript from a non secure page is accessing privileged code. Consider using HTTPS protocol when using Javascript -> Java liveconnect calls.", TraceLevel.SECURITY);
                return true;
            }
            bl3 = false;
            bl2 = false;
            bl4 = false;
        }
        return false;
    }

    public static boolean verifyApplicationLibraryAllowableCodebase(URL uRL, AppInfo appInfo) {
        String string;
        if (uRL.toString().endsWith(JARJNLP_SUFFIX)) {
            string = uRL.toString();
            try {
                uRL = new URL(string.substring(0, string.length() - JARJNLP_SUFFIX.length()) + JAR_SUFFIX);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
                return false;
            }
        }
        string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return true;
        }
        JarFile jarFile = resource.getJarFile();
        boolean bl = false;
        try {
            String string2 = jarFile.getManifest().getMainAttributes().getValue(LIBRARY_CODEBASE_ATTR);
            if (string2 == null) {
                Trace.println("Missing Application-Library-Allowable-Codebase manifest attribute for: " + uRL, TraceLevel.SECURITY);
            }
            if (string2 != null && string2.trim().length() > 0) {
                URL[] uRLArray = appInfo.getMultiHostUrls();
                for (int i = 0; i < uRLArray.length && (bl = DeployManifestChecker.verifyCodebase(uRLArray[i], string2, false)); ++i) {
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return bl;
    }

    static void printWarningsIfRequired(URL uRL, AppInfo appInfo) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        if (appInfo != null && !appInfo.hasSignedJNLP()) {
            try {
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                String string2 = attributes.getValue(NAME_ATTR);
                if (string2 == null) {
                    Trace.println("Missing Application-Name manifest attribute for: " + uRL);
                }
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
        }
    }
}

