/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.webkit.BackForwardList;
import com.sun.webkit.WebPage;
import com.sun.webkit.event.WCChangeEvent;
import com.sun.webkit.event.WCChangeListener;
import java.net.URL;
import java.util.Date;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public final class WebHistory {
    private final BackForwardList bfl;
    private final ObservableList<Entry> list;
    private final ObservableList<Entry> ulist;
    private final ReadOnlyIntegerWrapper currentIndex = new ReadOnlyIntegerWrapper(this, "currentIndex");
    private IntegerProperty maxSize;

    WebHistory(WebPage webPage) {
        this.list = FXCollections.observableArrayList();
        this.ulist = FXCollections.unmodifiableObservableList(this.list);
        this.bfl = webPage.createBackForwardList();
        this.setMaxSize(this.getMaxSize());
        this.bfl.addChangeListener(new WCChangeListener(){

            @Override
            public void stateChanged(WCChangeEvent wCChangeEvent) {
                if (WebHistory.this.bfl.size() > WebHistory.this.list.size()) {
                    assert (WebHistory.this.bfl.size() == WebHistory.this.list.size() + 1);
                    WebHistory.this.list.add(new Entry(WebHistory.this.bfl.getCurrentEntry()));
                    WebHistory.this.setCurrentIndex(WebHistory.this.list.size() - 1);
                    return;
                }
                if (WebHistory.this.bfl.size() == WebHistory.this.list.size()) {
                    if (WebHistory.this.list.size() == 0) {
                        return;
                    }
                    assert (WebHistory.this.list.size() > 0);
                    BackForwardList.Entry entry = WebHistory.this.bfl.get(WebHistory.this.list.size() - 1);
                    BackForwardList.Entry entry2 = WebHistory.this.bfl.get(0);
                    if (((Entry)WebHistory.this.list.get(WebHistory.this.list.size() - 1)).isPeer(entry)) {
                        WebHistory.this.setCurrentIndex(WebHistory.this.bfl.getCurrentIndex());
                        return;
                    }
                    if (!((Entry)WebHistory.this.list.get(0)).isPeer(entry2)) {
                        WebHistory.this.list.remove(0);
                        WebHistory.this.list.add(new Entry(entry));
                        WebHistory.this.setCurrentIndex(WebHistory.this.bfl.getCurrentIndex());
                        return;
                    }
                }
                assert (WebHistory.this.bfl.size() <= WebHistory.this.list.size());
                WebHistory.this.list.remove(WebHistory.this.bfl.size(), WebHistory.this.list.size());
                int n = WebHistory.this.list.size() - 1;
                if (n >= 0 && !((Entry)WebHistory.this.list.get(n)).isPeer(WebHistory.this.bfl.get(n))) {
                    WebHistory.this.list.remove(n);
                    WebHistory.this.list.add(new Entry(WebHistory.this.bfl.get(n)));
                }
                WebHistory.this.setCurrentIndex(WebHistory.this.bfl.getCurrentIndex());
            }
        });
    }

    public ReadOnlyIntegerProperty currentIndexProperty() {
        return this.currentIndex.getReadOnlyProperty();
    }

    public int getCurrentIndex() {
        return this.currentIndexProperty().get();
    }

    private void setCurrentIndex(int n) {
        this.currentIndex.set(n);
    }

    public IntegerProperty maxSizeProperty() {
        if (this.maxSize == null) {
            this.maxSize = new SimpleIntegerProperty(this, "maxSize", 100){

                @Override
                public void set(int n) {
                    if (n < 0) {
                        throw new IllegalArgumentException("value cannot be negative.");
                    }
                    super.set(n);
                }
            };
        }
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSizeProperty().set(n);
        this.bfl.setMaximumSize(n);
    }

    public int getMaxSize() {
        return this.maxSizeProperty().get();
    }

    public ObservableList<Entry> getEntries() {
        return this.ulist;
    }

    public void go(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return;
        }
        int n2 = this.getCurrentIndex() + n;
        if (n2 < 0 || n2 >= this.list.size()) {
            throw new IndexOutOfBoundsException("the effective index " + n2 + " is out of the range [0.." + (this.list.size() - 1) + "]");
        }
        this.bfl.setCurrentIndex(n2);
    }

    public final class Entry {
        private final URL url;
        private final ReadOnlyObjectWrapper<String> title = new ReadOnlyObjectWrapper(this, "title");
        private final ReadOnlyObjectWrapper<Date> lastVisitedDate = new ReadOnlyObjectWrapper(this, "lastVisitedDate");
        private final BackForwardList.Entry peer;

        private Entry(final BackForwardList.Entry entry) {
            this.url = entry.getURL();
            this.title.set(entry.getTitle());
            this.lastVisitedDate.set(entry.getLastVisitedDate());
            this.peer = entry;
            entry.addChangeListener(new WCChangeListener(){

                @Override
                public void stateChanged(WCChangeEvent wCChangeEvent) {
                    Date date;
                    String string = entry.getTitle();
                    if (string == null || !string.equals(Entry.this.getTitle())) {
                        Entry.this.title.set(string);
                    }
                    if ((date = entry.getLastVisitedDate()) != null && !date.equals(Entry.this.getLastVisitedDate())) {
                        Entry.this.lastVisitedDate.set(date);
                    }
                }
            });
        }

        public String getUrl() {
            assert (this.url != null);
            return this.url.toString();
        }

        public ReadOnlyObjectProperty<String> titleProperty() {
            return this.title.getReadOnlyProperty();
        }

        public String getTitle() {
            return (String)this.title.get();
        }

        public ReadOnlyObjectProperty<Date> lastVisitedDateProperty() {
            return this.lastVisitedDate.getReadOnlyProperty();
        }

        public Date getLastVisitedDate() {
            return (Date)this.lastVisitedDate.get();
        }

        boolean isPeer(BackForwardList.Entry entry) {
            return this.peer == entry;
        }

        public String toString() {
            return "[url: " + this.getUrl() + ", title: " + this.getTitle() + ", date: " + this.getLastVisitedDate() + "]";
        }
    }
}

