/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import javafx.beans.NamedArg;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableView;

public class TablePosition<S, T>
extends TablePositionBase<TableColumn<S, T>> {
    private final WeakReference<TableView<S>> controlRef;

    public TablePosition(@NamedArg(value="tableView") TableView<S> tableView, @NamedArg(value="row") int n, @NamedArg(value="tableColumn") TableColumn<S, T> tableColumn) {
        super(n, tableColumn);
        this.controlRef = new WeakReference<TableView<S>>(tableView);
    }

    @Override
    public int getColumn() {
        TableView<S> tableView = this.getTableView();
        TableColumnBase tableColumnBase = this.getTableColumn();
        return tableView == null || tableColumnBase == null ? -1 : tableView.getVisibleLeafIndex((TableColumn<S, ?>)tableColumnBase);
    }

    public final TableView<S> getTableView() {
        return (TableView)this.controlRef.get();
    }

    @Override
    public final TableColumn<S, T> getTableColumn() {
        return (TableColumn)super.getTableColumn();
    }

    public String toString() {
        return "TablePosition [ row: " + this.getRow() + ", column: " + this.getTableColumn() + ", " + "tableView: " + this.getTableView() + " ]";
    }
}

