/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.TableCellSkin;
import java.lang.ref.WeakReference;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;

public class TableCell<S, T>
extends IndexedCell<T> {
    boolean lockItemOnEdit = false;
    private boolean itemDirty = false;
    private ListChangeListener<TablePosition> selectedListener = new ListChangeListener<TablePosition>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TablePosition> change) {
            TableCell.this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCell.this.updateFocus();
        }
    };
    private final InvalidationListener tableRowUpdateObserver = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCell.this.itemDirty = true;
            TableCell.this.requestLayout();
        }
    };
    private final InvalidationListener editingListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableCell.this.updateEditing();
        }
    };
    private ListChangeListener<TableColumn<S, ?>> visibleLeafColumnsListener = new ListChangeListener<TableColumn<S, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<S, ?>> change) {
            TableCell.this.updateColumnIndex();
        }
    };
    private ListChangeListener<String> columnStyleClassListener = new ListChangeListener<String>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends String> change) {
            while (change.next()) {
                if (change.wasRemoved()) {
                    TableCell.this.getStyleClass().removeAll((Collection<?>)change.getRemoved());
                }
                if (!change.wasAdded()) continue;
                TableCell.this.getStyleClass().addAll((Collection<String>)change.getAddedSubList());
            }
        }
    };
    private final WeakListChangeListener<TablePosition> weakSelectedListener = new WeakListChangeListener<TablePosition>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weaktableRowUpdateObserver = new WeakInvalidationListener(this.tableRowUpdateObserver);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakListChangeListener<TableColumn<S, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakColumnStyleClassListener = new WeakListChangeListener<String>(this.columnStyleClassListener);
    private ReadOnlyObjectWrapper<TableColumn<S, T>> tableColumn = new ReadOnlyObjectWrapper<TableColumn<S, T>>(){

        @Override
        protected void invalidated() {
            TableCell.this.updateColumnIndex();
        }

        @Override
        public Object getBean() {
            return TableCell.this;
        }

        @Override
        public String getName() {
            return "tableColumn";
        }
    };
    private ReadOnlyObjectWrapper<TableView<S>> tableView;
    private ReadOnlyObjectWrapper<TableRow> tableRow = new ReadOnlyObjectWrapper(this, "tableRow");
    private boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private boolean updateEditingIndex = true;
    private ObservableValue<T> currentObservableValue = null;
    private boolean isFirstRun = true;
    private static final String DEFAULT_STYLE_CLASS = "table-cell";
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TableCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.updateColumnIndex();
    }

    public final ReadOnlyObjectProperty<TableColumn<S, T>> tableColumnProperty() {
        return this.tableColumn.getReadOnlyProperty();
    }

    private void setTableColumn(TableColumn<S, T> tableColumn) {
        this.tableColumn.set(tableColumn);
    }

    public final TableColumn<S, T> getTableColumn() {
        return (TableColumn)this.tableColumn.get();
    }

    private void setTableView(TableView<S> tableView) {
        this.tableViewPropertyImpl().set(tableView);
    }

    public final TableView<S> getTableView() {
        return this.tableView == null ? null : (TableView)this.tableView.get();
    }

    public final ReadOnlyObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableView<S>> tableViewPropertyImpl() {
        if (this.tableView == null) {
            this.tableView = new ReadOnlyObjectWrapper<TableView<S>>(){
                private WeakReference<TableView<S>> weakTableViewRef;

                @Override
                protected void invalidated() {
                    if (this.weakTableViewRef != null) {
                        TableCell.this.cleanUpTableViewListeners((TableView)this.weakTableViewRef.get());
                    }
                    if (this.get() != null) {
                        TableView.TableViewFocusModel tableViewFocusModel;
                        TableView.TableViewSelectionModel tableViewSelectionModel = ((TableView)this.get()).getSelectionModel();
                        if (tableViewSelectionModel != null) {
                            tableViewSelectionModel.getSelectedCells().addListener(TableCell.this.weakSelectedListener);
                        }
                        if ((tableViewFocusModel = ((TableView)this.get()).getFocusModel()) != null) {
                            tableViewFocusModel.focusedCellProperty().addListener(TableCell.this.weakFocusedListener);
                        }
                        ((TableView)this.get()).editingCellProperty().addListener(TableCell.this.weakEditingListener);
                        ((TableView)this.get()).getVisibleLeafColumns().addListener(TableCell.this.weakVisibleLeafColumnsListener);
                        this.weakTableViewRef = new WeakReference(this.get());
                    }
                    TableCell.this.updateColumnIndex();
                }

                @Override
                public Object getBean() {
                    return TableCell.this;
                }

                @Override
                public String getName() {
                    return "tableView";
                }
            };
        }
        return this.tableView;
    }

    private void setTableRow(TableRow tableRow) {
        this.tableRow.set(tableRow);
    }

    public final TableRow getTableRow() {
        return (TableRow)this.tableRow.get();
    }

    public final ReadOnlyObjectProperty<TableRow> tableRowProperty() {
        return this.tableRow;
    }

    @Override
    public void startEdit() {
        TableView<S> tableView = this.getTableView();
        TableColumn<S, T> tableColumn = this.getTableColumn();
        if (!this.isEditable() || tableView != null && !tableView.isEditable() || tableColumn != null && !this.getTableColumn().isEditable()) {
            return;
        }
        if (!this.lockItemOnEdit) {
            this.updateItem();
        }
        super.startEdit();
        if (tableColumn != null) {
            TableColumn.CellEditEvent<S, Object> cellEditEvent = new TableColumn.CellEditEvent<S, Object>(tableView, tableView.getEditingCell(), TableColumn.editStartEvent(), null);
            Event.fireEvent(tableColumn, cellEditEvent);
        }
    }

    @Override
    public void commitEdit(T t) {
        if (!this.isEditing()) {
            return;
        }
        TableView tableView = this.getTableView();
        if (tableView != null) {
            TableColumn.CellEditEvent cellEditEvent = new TableColumn.CellEditEvent(tableView, tableView.getEditingCell(), TableColumn.editCommitEvent(), t);
            Event.fireEvent(this.getTableColumn(), cellEditEvent);
        }
        super.commitEdit(t);
        this.updateItem(t, false);
        if (tableView != null) {
            tableView.edit(-1, null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(tableView);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TableView tableView = this.getTableView();
        super.cancelEdit();
        if (tableView != null) {
            TablePosition<S, ?> tablePosition = tableView.getEditingCell();
            if (this.updateEditingIndex) {
                tableView.edit(-1, null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(tableView);
            TableColumn.CellEditEvent<S, Object> cellEditEvent = new TableColumn.CellEditEvent<S, Object>(tableView, tablePosition, TableColumn.editCancelEvent(), null);
            Event.fireEvent(this.getTableColumn(), cellEditEvent);
        }
    }

    @Override
    public void updateSelected(boolean bl) {
        if (this.getTableRow() == null || this.getTableRow().isEmpty()) {
            return;
        }
        this.setSelected(bl);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TableCellSkin(this);
    }

    private void cleanUpTableViewListeners(TableView<S> tableView) {
        if (tableView != null) {
            TableView.TableViewFocusModel<S> tableViewFocusModel;
            TableView.TableViewSelectionModel<S> tableViewSelectionModel = tableView.getSelectionModel();
            if (tableViewSelectionModel != null) {
                tableViewSelectionModel.getSelectedCells().removeListener(this.weakSelectedListener);
            }
            if ((tableViewFocusModel = tableView.getFocusModel()) != null) {
                tableViewFocusModel.focusedCellProperty().removeListener(this.weakFocusedListener);
            }
            tableView.editingCellProperty().removeListener(this.weakEditingListener);
            tableView.getVisibleLeafColumns().removeListener(this.weakVisibleLeafColumnsListener);
        }
    }

    @Override
    void indexChanged() {
        super.indexChanged();
        this.updateItem();
        this.updateSelection();
        this.updateFocus();
    }

    private void updateColumnIndex() {
        TableView<S> tableView = this.getTableView();
        TableColumn<S, T> tableColumn = this.getTableColumn();
        this.columnIndex = tableView == null || tableColumn == null ? -1 : tableView.getVisibleLeafIndex(tableColumn);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == this.getTableView().getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        boolean bl = this.isSelected();
        if (!this.isInCellSelectionMode()) {
            if (bl) {
                this.updateSelected(false);
            }
            return;
        }
        TableView<S> tableView = this.getTableView();
        if (this.getIndex() == -1 || tableView == null) {
            return;
        }
        TableView.TableViewSelectionModel<S> tableViewSelectionModel = tableView.getSelectionModel();
        if (tableViewSelectionModel == null) {
            return;
        }
        boolean bl2 = ((TableSelectionModel)tableViewSelectionModel).isSelected(this.getIndex(), this.getTableColumn());
        if (bl == bl2) {
            return;
        }
        this.updateSelected(bl2);
    }

    private void updateFocus() {
        boolean bl = this.isFocused();
        if (!this.isInCellSelectionMode()) {
            if (bl) {
                this.setFocused(false);
            }
            return;
        }
        TableView<S> tableView = this.getTableView();
        if (this.getIndex() == -1 || tableView == null) {
            return;
        }
        TableView.TableViewFocusModel<S> tableViewFocusModel = tableView.getFocusModel();
        if (tableViewFocusModel == null) {
            return;
        }
        boolean bl2 = tableViewFocusModel != null && tableViewFocusModel.isFocused(this.getIndex(), this.getTableColumn());
        this.setFocused(bl2);
    }

    private void updateEditing() {
        if (this.getIndex() == -1 || this.getTableView() == null) {
            return;
        }
        TablePosition<S, ?> tablePosition = this.getTableView().getEditingCell();
        boolean bl = this.match(tablePosition);
        if (bl && !this.isEditing()) {
            this.startEdit();
        } else if (!bl && this.isEditing()) {
            this.updateEditingIndex = false;
            this.cancelEdit();
            this.updateEditingIndex = true;
        }
    }

    private boolean match(TablePosition tablePosition) {
        return tablePosition != null && tablePosition.getRow() == this.getIndex() && tablePosition.getTableColumn() == this.getTableColumn();
    }

    private boolean isInCellSelectionMode() {
        TableView<S> tableView = this.getTableView();
        if (tableView == null) {
            return false;
        }
        TableView.TableViewSelectionModel<S> tableViewSelectionModel = tableView.getSelectionModel();
        return tableViewSelectionModel != null && tableViewSelectionModel.isCellSelectionEnabled();
    }

    private void updateItem() {
        boolean bl;
        TableView<S> tableView;
        if (this.currentObservableValue != null) {
            this.currentObservableValue.removeListener(this.weaktableRowUpdateObserver);
        }
        ObservableList<Object> observableList = (tableView = this.getTableView()) == null ? FXCollections.emptyObservableList() : tableView.getItems();
        TableColumn<int, T> tableColumn = this.getTableColumn();
        int n = observableList == null ? -1 : observableList.size();
        int n2 = this.getIndex();
        boolean bl2 = this.isEmpty();
        Object t = this.getItem();
        boolean bl3 = bl = n2 >= n;
        if (bl || n2 < 0 || this.columnIndex < 0 || !this.isVisible() || tableColumn == null || !tableColumn.isVisible()) {
            if (!bl2 && t != null || this.isFirstRun || bl) {
                this.updateItem(null, true);
                this.isFirstRun = false;
            }
            return;
        }
        this.currentObservableValue = tableColumn.getCellObservableValue(n2);
        Object t2 = this.currentObservableValue == null ? null : (Object)this.currentObservableValue.getValue();
        this.updateItem(t2, false);
        if (this.currentObservableValue == null) {
            return;
        }
        this.currentObservableValue.addListener(this.weaktableRowUpdateObserver);
    }

    @Override
    protected void layoutChildren() {
        if (this.itemDirty) {
            this.updateItem();
            this.itemDirty = false;
        }
        super.layoutChildren();
    }

    public final void updateTableView(TableView tableView) {
        this.setTableView(tableView);
    }

    public final void updateTableRow(TableRow tableRow) {
        this.setTableRow(tableRow);
    }

    public final void updateTableColumn(TableColumn tableColumn) {
        TableColumn<S, T> tableColumn2 = this.getTableColumn();
        if (tableColumn2 != null) {
            tableColumn2.getStyleClass().removeListener(this.weakColumnStyleClassListener);
            this.getStyleClass().removeAll((Collection<?>)tableColumn2.getStyleClass());
        }
        this.setTableColumn(tableColumn);
        if (tableColumn != null) {
            this.getStyleClass().addAll((Collection<String>)tableColumn.getStyleClass());
            tableColumn.getStyleClass().addListener(this.weakColumnStyleClassListener);
        }
    }
}

