/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import com.sun.javafx.geom.Quat4f;
import com.sun.javafx.geom.Vec2f;
import com.sun.javafx.geom.Vec3f;
import com.sun.prism.Mesh;
import com.sun.prism.impl.BaseGraphicsResource;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.MeshTempState;
import com.sun.prism.impl.MeshUtil;
import com.sun.prism.impl.MeshVertex;
import java.util.Arrays;
import sun.util.logging.PlatformLogger;

public abstract class BaseMesh
extends BaseGraphicsResource
implements Mesh {
    private int nVerts;
    private int nTVerts;
    private int nFaces;
    private float[] pos;
    private float[] uv;
    private int[] faces;
    private int[] smoothing;
    private boolean allSameSmoothing;
    private boolean allHardEdges;
    protected static final int VERTEX_SIZE = 9;
    public static final int FACE_MEMBERS_SIZE = 7;

    protected BaseMesh(Disposer.Record record) {
        super(record);
    }

    public abstract boolean buildNativeGeometry(float[] var1, int var2, int[] var3, int var4);

    public abstract boolean buildNativeGeometry(float[] var1, int var2, short[] var3, int var4);

    @Override
    public boolean buildGeometry(float[] fArray, float[] fArray2, int[] nArray, int[] nArray2) {
        this.nVerts = fArray.length / 3;
        this.nTVerts = fArray2.length / 2;
        this.nFaces = nArray.length / 6;
        assert (this.nVerts > 0 && this.nFaces > 0 && this.nTVerts > 0);
        this.pos = fArray;
        this.uv = fArray2;
        this.faces = nArray;
        this.smoothing = (int[])(nArray2.length == this.nFaces ? nArray2 : null);
        MeshTempState meshTempState = MeshTempState.getInstance();
        MeshVertex[] meshVertexArray = meshTempState.pool = meshTempState.pool == null || meshTempState.pool.length < this.nFaces * 3 ? new MeshVertex[this.nFaces * 3] : meshTempState.pool;
        if (meshTempState.indexBuffer == null || meshTempState.indexBuffer.length < this.nFaces * 3) {
            meshTempState.indexBuffer = new int[this.nFaces * 3];
        }
        if (meshTempState.pVertex == null || meshTempState.pVertex.length < this.nVerts) {
            meshTempState.pVertex = new MeshVertex[this.nVerts];
        } else {
            Arrays.fill(meshTempState.pVertex, 0, meshTempState.pVertex.length, null);
        }
        this.checkSmoothingGroup();
        this.computeTBNormal(meshTempState.pool, meshTempState.pVertex, meshTempState.indexBuffer);
        int n = MeshVertex.processVertices(meshTempState.pVertex, this.nVerts, this.allHardEdges, this.allSameSmoothing);
        if (meshTempState.vertexBuffer == null || meshTempState.vertexBuffer.length < n * 9) {
            meshTempState.vertexBuffer = new float[n * 9];
        }
        this.buildVertexBuffer(meshTempState.pVertex, meshTempState.vertexBuffer);
        if (n > 65536) {
            this.buildIndexBuffer(meshTempState.pool, meshTempState.indexBuffer, null);
            return this.buildNativeGeometry(meshTempState.vertexBuffer, n * 9, meshTempState.indexBuffer, this.nFaces * 3);
        }
        if (meshTempState.indexBufferShort == null || meshTempState.indexBufferShort.length < this.nFaces * 3) {
            meshTempState.indexBufferShort = new short[this.nFaces * 3];
        }
        this.buildIndexBuffer(meshTempState.pool, meshTempState.indexBuffer, meshTempState.indexBufferShort);
        return this.buildNativeGeometry(meshTempState.vertexBuffer, n * 9, meshTempState.indexBufferShort, this.nFaces * 3);
    }

    private void computeTBNormal(MeshVertex[] meshVertexArray, MeshVertex[] meshVertexArray2, int[] nArray) {
        MeshTempState meshTempState = MeshTempState.getInstance();
        int[] nArray2 = meshTempState.smFace;
        int[] nArray3 = meshTempState.triVerts;
        Vec3f[] vec3fArray = meshTempState.triPoints;
        Vec2f[] vec2fArray = meshTempState.triTexCoords;
        Vec3f[] vec3fArray2 = meshTempState.norm;
        String string = BaseMesh.class.getName();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nFaces; ++i) {
            int n3;
            int n4 = i * 3;
            nArray2 = this.getFace(i, nArray2);
            nArray3[0] = nArray2[FaceMembers.POINT0.ordinal()];
            nArray3[1] = nArray2[FaceMembers.POINT1.ordinal()];
            nArray3[2] = nArray2[FaceMembers.POINT2.ordinal()];
            if (MeshUtil.isDeadFace(nArray3) && PlatformLogger.getLogger(string).isLoggable(PlatformLogger.Level.FINE)) {
                PlatformLogger.getLogger(string).fine("Dead face [" + nArray3[0] + ", " + nArray3[1] + ", " + nArray3[2] + "] @ face group " + i + "; nEmptyFaces = " + ++n);
            }
            for (n3 = 0; n3 < 3; ++n3) {
                vec3fArray[n3] = this.getVertex(nArray3[n3], vec3fArray[n3]);
            }
            nArray3[0] = nArray2[FaceMembers.TEXCOORD0.ordinal()];
            nArray3[1] = nArray2[FaceMembers.TEXCOORD1.ordinal()];
            nArray3[2] = nArray2[FaceMembers.TEXCOORD2.ordinal()];
            for (n3 = 0; n3 < 3; ++n3) {
                vec2fArray[n3] = this.getTVertex(nArray3[n3], vec2fArray[n3]);
            }
            MeshUtil.computeTBNNormalized(vec3fArray[0], vec3fArray[1], vec3fArray[2], vec2fArray[0], vec2fArray[1], vec2fArray[2], vec3fArray2);
            for (n3 = 0; n3 < 3; ++n3) {
                int n5;
                int n6;
                meshVertexArray[n2] = meshVertexArray[n2] == null ? new MeshVertex() : meshVertexArray[n2];
                for (n6 = 0; n6 < 3; ++n6) {
                    meshVertexArray[n2].norm[n6].set(vec3fArray2[n6]);
                }
                meshVertexArray[n2].smGroup = nArray2[FaceMembers.SMOOTHING_GROUP.ordinal()];
                meshVertexArray[n2].fIdx = i;
                meshVertexArray[n2].tVert = nArray3[n3];
                meshVertexArray[n2].index = -1;
                n6 = n3 == 0 ? FaceMembers.POINT0.ordinal() : (n3 == 1 ? FaceMembers.POINT1.ordinal() : FaceMembers.POINT2.ordinal());
                meshVertexArray[n2].pVert = n5 = nArray2[n6];
                nArray[n4 + n3] = n5;
                meshVertexArray[n2].next = meshVertexArray2[n5];
                meshVertexArray2[n5] = meshVertexArray[n2];
                ++n2;
            }
        }
    }

    private void buildVSQuat(Vec3f[] vec3fArray, Quat4f quat4f) {
        Vec3f vec3f = MeshTempState.getInstance().vec3f1;
        vec3f.cross(vec3fArray[1], vec3fArray[2]);
        float f = vec3fArray[0].dot(vec3f);
        if (f < 0.0f) {
            vec3fArray[2].mul(-1.0f);
        }
        MeshUtil.buildQuat(vec3fArray, quat4f);
        if (f < 0.0f) {
            if (quat4f.w == 0.0f) {
                quat4f.w = 1.0E-10f;
            }
            quat4f.scale(-1.0f);
        }
    }

    private void buildVertexBuffer(MeshVertex[] meshVertexArray, float[] fArray) {
        Quat4f quat4f = MeshTempState.getInstance().quat;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nVerts; ++i) {
            MeshVertex meshVertex = meshVertexArray[i];
            while (meshVertex != null) {
                if (meshVertex.index == n) {
                    int n3 = meshVertex.pVert * 3;
                    fArray[n2++] = this.pos[n3];
                    fArray[n2++] = this.pos[n3 + 1];
                    fArray[n2++] = this.pos[n3 + 2];
                    n3 = meshVertex.tVert * 2;
                    fArray[n2++] = this.uv[n3];
                    fArray[n2++] = this.uv[n3 + 1];
                    this.buildVSQuat(meshVertex.norm, quat4f);
                    fArray[n2++] = quat4f.x;
                    fArray[n2++] = quat4f.y;
                    fArray[n2++] = quat4f.z;
                    fArray[n2++] = quat4f.w;
                    ++n;
                }
                meshVertex = meshVertex.next;
            }
        }
    }

    private void buildIndexBuffer(MeshVertex[] meshVertexArray, int[] nArray, short[] sArray) {
        for (int i = 0; i < this.nFaces; ++i) {
            int n;
            int n2 = i * 3;
            if (nArray[n2] != -1) {
                for (n = 0; n < 3; ++n) {
                    assert (meshVertexArray[n2].fIdx == i);
                    if (sArray != null) {
                        sArray[n2 + n] = (short)meshVertexArray[n2 + n].index;
                    } else {
                        nArray[n2 + n] = meshVertexArray[n2 + n].index;
                    }
                    meshVertexArray[n2 + n].next = null;
                }
                continue;
            }
            for (n = 0; n < 3; ++n) {
                if (sArray != null) {
                    sArray[n2 + n] = 0;
                    continue;
                }
                nArray[n2 + n] = 0;
            }
        }
    }

    public int getNumVerts() {
        return this.nVerts;
    }

    public int getNumTVerts() {
        return this.nTVerts;
    }

    public int getNumFaces() {
        return this.nFaces;
    }

    public Vec3f getVertex(int n, Vec3f vec3f) {
        if (vec3f == null) {
            vec3f = new Vec3f();
        }
        int n2 = n * 3;
        vec3f.set(this.pos[n2], this.pos[n2 + 1], this.pos[n2 + 2]);
        return vec3f;
    }

    public Vec2f getTVertex(int n, Vec2f vec2f) {
        if (vec2f == null) {
            vec2f = new Vec2f();
        }
        int n2 = n * 2;
        vec2f.set(this.uv[n2], this.uv[n2 + 1]);
        return vec2f;
    }

    private void checkSmoothingGroup() {
        if (this.smoothing == null || this.smoothing.length == 0) {
            this.allSameSmoothing = true;
            this.allHardEdges = false;
            return;
        }
        int n = 0;
        while (n + 1 < this.smoothing.length) {
            if (this.smoothing[n] != this.smoothing[n + 1]) {
                this.allSameSmoothing = false;
                this.allHardEdges = false;
                return;
            }
            ++n;
        }
        if (this.smoothing[0] == 0) {
            this.allSameSmoothing = false;
            this.allHardEdges = true;
        } else {
            this.allSameSmoothing = true;
            this.allHardEdges = false;
        }
    }

    public int[] getFace(int n, int[] nArray) {
        int n2 = n * 6;
        if (nArray == null || nArray.length < 7) {
            nArray = new int[7];
        }
        for (int i = 0; i < 6; ++i) {
            nArray[i] = this.faces[n2 + i];
        }
        nArray[6] = this.smoothing != null ? this.smoothing[n] : 1;
        return nArray;
    }

    public static enum FaceMembers {
        POINT0,
        TEXCOORD0,
        POINT1,
        TEXCOORD1,
        POINT2,
        TEXCOORD2,
        SMOOTHING_GROUP;

    }
}

