/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import java.nio.Buffer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.UnaryOperator;

public class NGExternalNode
extends NGNode {
    private Texture dsttexture;
    private BufferData bufferData;
    private final AtomicReference<RenderData> renderData = new AtomicReference<Object>(null);
    private RenderData rd;
    private volatile ReentrantLock bufferLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderContent(Graphics graphics) {
        RenderData renderData = this.renderData.getAndSet(null);
        if (renderData != null) {
            this.rd = renderData;
        }
        if (this.rd == null) {
            return;
        }
        int n = this.rd.bdata.srcbounds.x;
        int n2 = this.rd.bdata.srcbounds.y;
        int n3 = this.rd.bdata.srcbounds.width;
        int n4 = this.rd.bdata.srcbounds.height;
        if (this.dsttexture != null) {
            this.dsttexture.lock();
            if (this.dsttexture.isSurfaceLost() || this.dsttexture.getContentWidth() != this.rd.bdata.dstwidth || this.dsttexture.getContentHeight() != this.rd.bdata.dstheight) {
                this.dsttexture.unlock();
                this.dsttexture.dispose();
                this.dsttexture = this.createTexture(graphics, this.rd);
            }
        } else {
            this.dsttexture = this.createTexture(graphics, this.rd);
        }
        if (this.dsttexture == null) {
            return;
        }
        try {
            if (renderData != null) {
                this.bufferLock.lock();
                try {
                    this.dsttexture.update(this.rd.bdata.srcbuffer, PixelFormat.INT_ARGB_PRE, n + this.rd.dirtyRect.x, n2 + this.rd.dirtyRect.y, n + this.rd.dirtyRect.x, n2 + this.rd.dirtyRect.y, this.rd.dirtyRect.width, this.rd.dirtyRect.height, this.rd.bdata.linestride * 4, false);
                }
                finally {
                    this.bufferLock.unlock();
                }
                if (this.rd.clearTarget) {
                    graphics.clear();
                }
            }
            graphics.drawTexture(this.dsttexture, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4);
        }
        finally {
            this.dsttexture.unlock();
        }
    }

    private Texture createTexture(Graphics graphics, RenderData renderData) {
        ResourceFactory resourceFactory = graphics.getResourceFactory();
        if (!resourceFactory.isDeviceReady()) {
            System.err.println("NGExternalNode: graphics device is not ready");
            return null;
        }
        Texture texture = resourceFactory.createTexture(PixelFormat.INT_ARGB_PRE, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_NOT_NEEDED, renderData.bdata.dstwidth, renderData.bdata.dstheight);
        if (texture != null) {
            texture.contentsUseful();
        } else {
            System.err.println("NGExternalNode: failed to create a texture");
        }
        return texture;
    }

    public void setLock(ReentrantLock reentrantLock) {
        this.bufferLock = reentrantLock;
    }

    public void setImageBuffer(Buffer buffer, int n, int n2, int n3, int n4, int n5) {
        this.bufferData = new BufferData(buffer, n5, n, n2, n3, n4);
        this.renderData.set(new RenderData(this.bufferData, n, n2, n3, n4, true));
    }

    public void setImageBounds(final int n, final int n2, final int n3, final int n4) {
        final boolean bl = n3 < this.bufferData.srcbounds.width || n4 < this.bufferData.srcbounds.height;
        this.bufferData = this.bufferData.copyWithBounds(n, n2, n3, n4);
        this.renderData.updateAndGet(new UnaryOperator<RenderData>(){

            @Override
            public RenderData apply(RenderData renderData) {
                boolean bl2 = renderData != null ? renderData.clearTarget : false;
                return new RenderData(NGExternalNode.this.bufferData, n, n2, n3, n4, bl2 | bl);
            }
        });
    }

    public void repaintDirtyRegion(final int n, final int n2, final int n3, final int n4) {
        this.renderData.updateAndGet(new UnaryOperator<RenderData>(){

            @Override
            public RenderData apply(RenderData renderData) {
                if (renderData != null) {
                    return renderData.copyAddDirtyRect(n, n2, n3, n4);
                }
                return new RenderData(NGExternalNode.this.bufferData, n, n2, n3, n4, false);
            }
        });
    }

    public void markContentDirty() {
        this.visualsChanged();
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    private static class BufferData {
        final Buffer srcbuffer;
        final int linestride;
        final Rectangle srcbounds;
        final int dstwidth;
        final int dstheight;

        BufferData(Buffer buffer, int n, int n2, int n3, int n4, int n5) {
            this.srcbuffer = buffer;
            this.linestride = n;
            this.srcbounds = new Rectangle(n2, n3, n4, n5);
            this.dstwidth = n;
            this.dstheight = buffer.capacity() / n;
        }

        BufferData copyWithBounds(int n, int n2, int n3, int n4) {
            return new BufferData(this.srcbuffer, this.linestride, n, n2, n3, n4);
        }
    }

    private static class RenderData {
        final BufferData bdata;
        final Rectangle dirtyRect;
        final boolean clearTarget;

        RenderData(BufferData bufferData, int n, int n2, int n3, int n4, boolean bl) {
            this.bdata = bufferData;
            this.dirtyRect = new Rectangle(n, n2, n3, n4);
            this.clearTarget = bl;
        }

        RenderData copyAddDirtyRect(int n, int n2, int n3, int n4) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            rectangle.add(this.dirtyRect);
            return new RenderData(this.bdata, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.clearTarget);
        }
    }
}

