/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class TreeViewSkin<T>
extends VirtualContainerBase<TreeView<T>, TreeViewBehavior<T>, TreeCell<T>> {
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("com.sun.javafx.scene.control.skin.TreeViewSkin.pannable");
        }
    });
    private boolean needCellsRebuilt = true;
    private boolean needCellsReconfigured = false;
    private EventHandler<TreeItem.TreeModificationEvent> rootListener = new EventHandler<TreeItem.TreeModificationEvent>(){

        @Override
        public void handle(TreeItem.TreeModificationEvent treeModificationEvent) {
            if (treeModificationEvent.wasAdded() && treeModificationEvent.wasRemoved() && treeModificationEvent.getAddedSize() == treeModificationEvent.getRemovedSize()) {
                TreeViewSkin.this.rowCountDirty = true;
                ((TreeView)TreeViewSkin.this.getSkinnable()).requestLayout();
            } else if (treeModificationEvent.getEventType().equals(TreeItem.valueChangedEvent())) {
                TreeViewSkin.this.needCellsRebuilt = true;
                ((TreeView)TreeViewSkin.this.getSkinnable()).requestLayout();
            } else {
                for (EventType<? extends Event> eventType = treeModificationEvent.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
                    if (!eventType.equals(TreeItem.expandedItemCountChangeEvent())) continue;
                    TreeViewSkin.this.rowCountDirty = true;
                    ((TreeView)TreeViewSkin.this.getSkinnable()).requestLayout();
                    break;
                }
            }
        }
    };
    private WeakEventHandler weakRootListener;
    private WeakReference<TreeItem> weakRoot;

    public TreeViewSkin(final TreeView treeView) {
        super(treeView, new TreeViewBehavior(treeView));
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setFocusTraversable(((TreeView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCreateCell(new Callback<VirtualFlow, TreeCell<T>>(){

            @Override
            public TreeCell<T> call(VirtualFlow virtualFlow) {
                return TreeViewSkin.this.createCell();
            }
        });
        this.flow.setFixedCellSize(treeView.getFixedCellSize());
        this.getChildren().add(this.flow);
        this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (treeView.getEditingItem() != null) {
                    treeView.edit(null);
                }
                treeView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        ((TreeViewBehavior)this.getBehavior()).setOnFocusPreviousRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onFocusPreviousCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnFocusNextRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onFocusNextCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onMoveToFirstCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onMoveToLastCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageDown(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return TreeViewSkin.this.onScrollPageDown(n);
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageUp(new Callback<Integer, Integer>(){

            @Override
            public Integer call(Integer n) {
                return TreeViewSkin.this.onScrollPageUp(n);
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onSelectPreviousCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onSelectNextCell();
            }
        });
        this.registerChangeListener(treeView.rootProperty(), "ROOT");
        this.registerChangeListener(treeView.showRootProperty(), "SHOW_ROOT");
        this.registerChangeListener(treeView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(treeView.focusTraversableProperty(), "FOCUS_TRAVERSABLE");
        this.registerChangeListener(treeView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
        this.updateRowCount();
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ROOT".equals(string)) {
            this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        } else if ("SHOW_ROOT".equals(string)) {
            if (!((TreeView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
            }
            this.updateRowCount();
        } else if ("CELL_FACTORY".equals(string)) {
            this.flow.recreateCells();
        } else if ("FOCUS_TRAVERSABLE".equals(string)) {
            this.flow.setFocusTraversable(((TreeView)this.getSkinnable()).isFocusTraversable());
        } else if ("FIXED_CELL_SIZE".equals(string)) {
            this.flow.setFixedCellSize(((TreeView)this.getSkinnable()).getFixedCellSize());
        }
    }

    private TreeItem getRoot() {
        return this.weakRoot == null ? null : (TreeItem)this.weakRoot.get();
    }

    private void setRoot(TreeItem treeItem) {
        if (this.getRoot() != null && this.weakRootListener != null) {
            this.getRoot().removeEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.weakRoot = new WeakReference<TreeItem>(treeItem);
        if (this.getRoot() != null) {
            this.weakRootListener = new WeakEventHandler<TreeItem.TreeModificationEvent>(this.rootListener);
            this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.updateRowCount();
    }

    @Override
    public int getItemCount() {
        return ((TreeView)this.getSkinnable()).getExpandedItemCount();
    }

    @Override
    protected void updateRowCount() {
        int n = this.getItemCount();
        this.flow.setCellCount(n);
        this.needCellsRebuilt = true;
        ((TreeView)this.getSkinnable()).requestLayout();
    }

    @Override
    public TreeCell<T> createCell() {
        TreeCell<T> treeCell = ((TreeView)this.getSkinnable()).getCellFactory() != null ? ((TreeView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : this.createDefaultCellImpl();
        if (treeCell.getDisclosureNode() == null) {
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            StackPane stackPane2 = new StackPane();
            stackPane2.getStyleClass().setAll((String[])new String[]{"arrow"});
            stackPane.getChildren().add(stackPane2);
            treeCell.setDisclosureNode(stackPane);
        }
        treeCell.updateTreeView((TreeView)this.getSkinnable());
        return treeCell;
    }

    private TreeCell<T> createDefaultCellImpl() {
        return new TreeCell<T>(){
            private HBox hbox;
            private WeakReference<TreeItem<T>> treeItemRef;
            private InvalidationListener treeItemGraphicListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    this.updateDisplay(this.getItem(), this.isEmpty());
                }
            };
            private InvalidationListener treeItemListener = new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    TreeItem treeItem;
                    TreeItem treeItem2;
                    TreeItem treeItem3 = treeItem2 = treeItemRef == null ? null : (TreeItem)treeItemRef.get();
                    if (treeItem2 != null) {
                        treeItem2.graphicProperty().removeListener(weakTreeItemGraphicListener);
                    }
                    if ((treeItem = this.getTreeItem()) != null) {
                        treeItem.graphicProperty().addListener(weakTreeItemGraphicListener);
                        treeItemRef = new WeakReference(treeItem);
                    }
                }
            };
            private WeakInvalidationListener weakTreeItemGraphicListener = new WeakInvalidationListener(this.treeItemGraphicListener);
            private WeakInvalidationListener weakTreeItemListener = new WeakInvalidationListener(this.treeItemListener);
            {
                this.treeItemProperty().addListener(this.weakTreeItemListener);
                if (this.getTreeItem() != null) {
                    this.getTreeItem().graphicProperty().addListener(this.weakTreeItemGraphicListener);
                }
            }

            private void updateDisplay(T t, boolean bl) {
                if (t == null || bl) {
                    this.hbox = null;
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    TreeItem treeItem = this.getTreeItem();
                    if (treeItem != null && treeItem.getGraphic() != null) {
                        if (t instanceof Node) {
                            this.setText(null);
                            if (this.hbox == null) {
                                this.hbox = new HBox(3.0);
                            }
                            this.hbox.getChildren().setAll((Node[])new Node[]{treeItem.getGraphic(), (Node)t});
                            this.setGraphic(this.hbox);
                        } else {
                            this.hbox = null;
                            this.setText(t.toString());
                            this.setGraphic(treeItem.getGraphic());
                        }
                    } else {
                        this.hbox = null;
                        if (t instanceof Node) {
                            this.setText(null);
                            this.setGraphic((Node)t);
                        } else {
                            this.setText(t.toString());
                            this.setGraphic(null);
                        }
                    }
                }
            }

            @Override
            public void updateItem(T t, boolean bl) {
                super.updateItem(t, bl);
                this.updateDisplay(t, bl);
            }
        };
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        return this.computePrefHeight(-1.0, d2, d3, d4, d5) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return 400.0;
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        super.layoutChildren(d, d2, d3, d4);
        if (this.needCellsRebuilt) {
            this.flow.rebuildCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRebuilt = false;
        this.needCellsReconfigured = false;
        this.flow.resizeRelocate(d, d2, d3, d4);
    }

    private void onFocusPreviousCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (focusModel == null) {
            return;
        }
        this.flow.show(focusModel.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onSelectNextCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        this.flow.show(this.getItemCount());
        this.flow.setPosition(1.0);
    }

    public int onScrollPageDown(int n) {
        TreeCell treeCell = (TreeCell)this.flow.getLastVisibleCellWithinViewPort();
        if (treeCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = treeCell.getIndex();
        if (multipleSelectionModel.isSelected(n2) || focusModel.isFocused(n2) || n2 == n) {
            this.flow.showAsFirst(treeCell);
            TreeCell treeCell2 = (TreeCell)this.flow.getLastVisibleCellWithinViewPort();
            treeCell = treeCell2 == null ? treeCell : treeCell2;
        }
        int n3 = treeCell.getIndex();
        this.flow.show(treeCell);
        return n3;
    }

    public int onScrollPageUp(int n) {
        TreeCell treeCell = (TreeCell)this.flow.getFirstVisibleCellWithinViewPort();
        if (treeCell == null) {
            return -1;
        }
        MultipleSelectionModel multipleSelectionModel = ((TreeView)this.getSkinnable()).getSelectionModel();
        FocusModel focusModel = ((TreeView)this.getSkinnable()).getFocusModel();
        if (multipleSelectionModel == null || focusModel == null) {
            return -1;
        }
        int n2 = treeCell.getIndex();
        if (multipleSelectionModel.isSelected(n2) || focusModel.isFocused(n2) || n2 == n) {
            this.flow.showAsLast(treeCell);
            TreeCell treeCell2 = (TreeCell)this.flow.getFirstVisibleCellWithinViewPort();
            treeCell = treeCell2 == null ? treeCell : treeCell2;
        }
        int n3 = treeCell.getIndex();
        this.flow.show(treeCell);
        return n3;
    }
}

