/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.MultiplePropertyChangeListenerHandler;
import com.sun.javafx.scene.control.TableColumnSortTypeWrapper;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.DoubleProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class TableColumnHeader
extends Region {
    private static final double DEFAULT_WIDTH = 80.0;
    private boolean autoSizeComplete = false;
    private double dragOffset;
    private final TableViewSkinBase skin;
    private NestedTableColumnHeader nestedColumnHeader;
    private final TableColumnBase<?, ?> column;
    private TableHeaderRow tableHeaderRow;
    private NestedTableColumnHeader parentHeader;
    private Label label;
    private int sortPos = -1;
    private Region arrow;
    private Label sortOrderLabel;
    private HBox sortOrderDots;
    private Node sortArrow;
    private boolean isSortColumn;
    private boolean isSizeDirty = false;
    private boolean sortOrderDotsDirty = false;
    boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private int newColumnPos;
    protected final Region columnReorderLine;
    protected final MultiplePropertyChangeListenerHandler changeListenerHandler;
    private ListChangeListener<TableColumnBase<?, ?>> sortOrderListener = new ListChangeListener<TableColumnBase<?, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumnBase<?, ?>> change) {
            TableColumnHeader.this.updateSortPosition();
        }
    };
    private ListChangeListener<TableColumnBase<?, ?>> visibleLeafColumnsListener = new ListChangeListener<TableColumnBase<?, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumnBase<?, ?>> change) {
            TableColumnHeader.this.updateColumnIndex();
        }
    };
    private ListChangeListener<String> styleClassListener = new ListChangeListener<String>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends String> change) {
            TableColumnHeader.this.updateStyleClass();
        }
    };
    private WeakListChangeListener<TableColumnBase<?, ?>> weakSortOrderListener = new WeakListChangeListener(this.sortOrderListener);
    private final WeakListChangeListener<TableColumnBase<?, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakStyleClassListener = new WeakListChangeListener<String>(this.styleClassListener);
    private static final EventHandler<MouseEvent> mousePressedHandler = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            TableColumnHeader tableColumnHeader = (TableColumnHeader)mouseEvent.getSource();
            ((Node)((Object)tableColumnHeader.getTableViewSkin().getSkinnable())).requestFocus();
            if (mouseEvent.isPrimaryButtonDown() && tableColumnHeader.isColumnReorderingEnabled()) {
                tableColumnHeader.columnReorderingStarted(mouseEvent);
            }
            mouseEvent.consume();
        }
    };
    private static final EventHandler<MouseEvent> mouseDraggedHandler = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            TableColumnHeader tableColumnHeader = (TableColumnHeader)mouseEvent.getSource();
            if (mouseEvent.isPrimaryButtonDown() && tableColumnHeader.isColumnReorderingEnabled()) {
                tableColumnHeader.columnReordering(mouseEvent);
            }
            mouseEvent.consume();
        }
    };
    private static final EventHandler<MouseEvent> mouseReleasedHandler = new EventHandler<MouseEvent>(){

        @Override
        public void handle(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
            TableColumnHeader tableColumnHeader = (TableColumnHeader)mouseEvent.getSource();
            TableColumnBase tableColumnBase = tableColumnHeader.getTableColumn();
            ContextMenu contextMenu = tableColumnBase.getContextMenu();
            if (contextMenu != null && contextMenu.isShowing()) {
                return;
            }
            if (tableColumnHeader.getTableHeaderRow().isReordering() && tableColumnHeader.isColumnReorderingEnabled()) {
                tableColumnHeader.columnReorderingComplete(mouseEvent);
            } else if (mouseEvent.isStillSincePress()) {
                tableColumnHeader.sortColumn(mouseEvent.isShiftDown());
            }
            mouseEvent.consume();
        }
    };
    private static final EventHandler<ContextMenuEvent> contextMenuRequestedHandler = new EventHandler<ContextMenuEvent>(){

        @Override
        public void handle(ContextMenuEvent contextMenuEvent) {
            TableColumnHeader tableColumnHeader = (TableColumnHeader)contextMenuEvent.getSource();
            TableColumnBase tableColumnBase = tableColumnHeader.getTableColumn();
            ContextMenu contextMenu = tableColumnBase.getContextMenu();
            if (contextMenu != null) {
                contextMenu.show(tableColumnHeader, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                contextMenuEvent.consume();
            }
        }
    };
    private DoubleProperty size;
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TableColumnHeader(TableViewSkinBase tableViewSkinBase, TableColumnBase tableColumnBase) {
        this.skin = tableViewSkinBase;
        this.column = tableColumnBase;
        this.columnReorderLine = tableViewSkinBase.getColumnReorderLine();
        this.setFocusTraversable(false);
        this.updateColumnIndex();
        this.initUI();
        this.changeListenerHandler = new MultiplePropertyChangeListenerHandler(new Callback<String, Void>(){

            @Override
            public Void call(String string) {
                TableColumnHeader.this.handlePropertyChanged(string);
                return null;
            }
        });
        this.changeListenerHandler.registerChangeListener(this.sceneProperty(), "SCENE");
        if (this.column != null && tableViewSkinBase != null) {
            this.updateSortPosition();
            tableViewSkinBase.getSortOrder().addListener(this.weakSortOrderListener);
            tableViewSkinBase.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        }
        if (this.column != null) {
            this.changeListenerHandler.registerChangeListener(this.column.idProperty(), "TABLE_COLUMN_ID");
            this.changeListenerHandler.registerChangeListener(this.column.styleProperty(), "TABLE_COLUMN_STYLE");
            this.changeListenerHandler.registerChangeListener(this.column.widthProperty(), "TABLE_COLUMN_WIDTH");
            this.changeListenerHandler.registerChangeListener(this.column.visibleProperty(), "TABLE_COLUMN_VISIBLE");
            this.changeListenerHandler.registerChangeListener(this.column.sortNodeProperty(), "TABLE_COLUMN_SORT_NODE");
            this.changeListenerHandler.registerChangeListener(this.column.sortableProperty(), "TABLE_COLUMN_SORTABLE");
            this.changeListenerHandler.registerChangeListener(this.column.textProperty(), "TABLE_COLUMN_TEXT");
            this.changeListenerHandler.registerChangeListener(this.column.graphicProperty(), "TABLE_COLUMN_GRAPHIC");
            this.column.getStyleClass().addListener(this.weakStyleClassListener);
            this.updateStyleClass();
        }
    }

    private double getSize() {
        return this.size == null ? 20.0 : this.size.doubleValue();
    }

    private DoubleProperty sizeProperty() {
        if (this.size == null) {
            this.size = new StyleableDoubleProperty(20.0){

                @Override
                protected void invalidated() {
                    double d = this.get();
                    if (d <= 0.0) {
                        if (this.isBound()) {
                            this.unbind();
                        }
                        this.set(20.0);
                        throw new IllegalArgumentException("Size cannot be 0 or negative");
                    }
                }

                @Override
                public Object getBean() {
                    return TableColumnHeader.this;
                }

                @Override
                public String getName() {
                    return "size";
                }

                @Override
                public CssMetaData<TableColumnHeader, Number> getCssMetaData() {
                    return StyleableProperties.SIZE;
                }
            };
        }
        return this.size;
    }

    protected void handlePropertyChanged(String string) {
        if ("SCENE".equals(string)) {
            this.updateScene();
        } else if ("TABLE_COLUMN_VISIBLE".equals(string)) {
            this.setVisible(this.getTableColumn().isVisible());
        } else if ("TABLE_COLUMN_WIDTH".equals(string)) {
            this.isSizeDirty = true;
            this.requestLayout();
        } else if ("TABLE_COLUMN_ID".equals(string)) {
            this.setId(this.column.getId());
        } else if ("TABLE_COLUMN_STYLE".equals(string)) {
            this.setStyle(this.column.getStyle());
        } else if ("TABLE_COLUMN_SORT_TYPE".equals(string)) {
            this.updateSortGrid();
            if (this.arrow != null) {
                this.arrow.setRotate(TableColumnSortTypeWrapper.isAscending(this.column) ? 180.0 : 0.0);
            }
        } else if ("TABLE_COLUMN_SORT_NODE".equals(string)) {
            this.updateSortGrid();
        } else if ("TABLE_COLUMN_SORTABLE".equals(string)) {
            if (this.skin.getSortOrder().contains(this.getTableColumn())) {
                NestedTableColumnHeader nestedTableColumnHeader = this.getTableHeaderRow().getRootHeader();
                this.updateAllHeaders(nestedTableColumnHeader);
            }
        } else if ("TABLE_COLUMN_TEXT".equals(string)) {
            this.label.setText(this.column.getText());
        } else if ("TABLE_COLUMN_GRAPHIC".equals(string)) {
            this.label.setGraphic(this.column.getGraphic());
        }
    }

    protected TableViewSkinBase getTableViewSkin() {
        return this.skin;
    }

    NestedTableColumnHeader getNestedColumnHeader() {
        return this.nestedColumnHeader;
    }

    void setNestedColumnHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        this.nestedColumnHeader = nestedTableColumnHeader;
    }

    public TableColumnBase getTableColumn() {
        return this.column;
    }

    TableHeaderRow getTableHeaderRow() {
        return this.tableHeaderRow;
    }

    void setTableHeaderRow(TableHeaderRow tableHeaderRow) {
        this.tableHeaderRow = tableHeaderRow;
    }

    NestedTableColumnHeader getParentHeader() {
        return this.parentHeader;
    }

    void setParentHeader(NestedTableColumnHeader nestedTableColumnHeader) {
        this.parentHeader = nestedTableColumnHeader;
    }

    @Override
    protected void layoutChildren() {
        if (this.isSizeDirty) {
            this.resize(this.getTableColumn().getWidth(), this.getHeight());
            this.isSizeDirty = false;
        } else if (this.sortOrderDotsDirty) {
            this.updateSortOrderDots(this.sortPos);
            this.sortOrderDotsDirty = false;
        }
        double d = 0.0;
        double d2 = this.snapSize(this.getWidth()) - (this.snappedLeftInset() + this.snappedRightInset());
        double d3 = this.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double d4 = d2;
        if (this.arrow != null) {
            this.arrow.setMaxSize(this.arrow.prefWidth(-1.0), this.arrow.prefHeight(-1.0));
        }
        if (this.sortArrow != null && this.sortArrow.isVisible()) {
            d = this.sortArrow.prefWidth(-1.0);
            this.sortArrow.resize(d, this.sortArrow.prefHeight(-1.0));
            this.positionInArea(this.sortArrow, d4 -= d, this.snappedTopInset(), d, d3, 0.0, HPos.CENTER, VPos.CENTER);
        }
        if (this.label != null) {
            double d5 = d2 - d;
            this.label.resizeRelocate(this.snappedLeftInset(), 0.0, d5, this.getHeight());
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        if (this.getNestedColumnHeader() != null) {
            double d2 = this.getNestedColumnHeader().prefWidth(d);
            if (this.column != null) {
                this.column.impl_setWidth(d2);
            }
            return d2;
        }
        if (this.column != null && this.column.isVisible()) {
            return this.column.getWidth();
        }
        return 0.0;
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.label == null ? 0.0 : this.label.minHeight(d);
    }

    @Override
    protected double computePrefHeight(double d) {
        if (this.getTableColumn() == null) {
            return 0.0;
        }
        return Math.max(this.getSize(), this.label.prefHeight(-1.0));
    }

    private void updateAllHeaders(TableColumnHeader tableColumnHeader) {
        if (tableColumnHeader instanceof NestedTableColumnHeader) {
            ObservableList<TableColumnHeader> observableList = ((NestedTableColumnHeader)tableColumnHeader).getColumnHeaders();
            for (int i = 0; i < observableList.size(); ++i) {
                this.updateAllHeaders((TableColumnHeader)observableList.get(i));
            }
        } else {
            tableColumnHeader.updateSortPosition();
        }
    }

    private void updateStyleClass() {
        this.getStyleClass().setAll((String[])new String[]{"column-header"});
        this.getStyleClass().addAll((Collection<String>)this.column.getStyleClass());
    }

    private void updateScene() {
        if (!this.autoSizeComplete) {
            if (this.getTableColumn() == null || this.getTableColumn().getWidth() != 80.0 || this.getScene() == null) {
                return;
            }
            this.getTableViewSkin().resizeColumnToFitContent(this.getTableColumn(), 30);
            this.autoSizeComplete = true;
        }
    }

    void dispose() {
        TableViewSkinBase tableViewSkinBase = this.getTableViewSkin();
        if (tableViewSkinBase != null) {
            tableViewSkinBase.getVisibleLeafColumns().removeListener(this.weakVisibleLeafColumnsListener);
            tableViewSkinBase.getSortOrder().removeListener(this.weakSortOrderListener);
        }
        this.changeListenerHandler.dispose();
    }

    private boolean isSortingEnabled() {
        return true;
    }

    private boolean isColumnReorderingEnabled() {
        return !BehaviorSkinBase.IS_TOUCH_SUPPORTED && this.getTableViewSkin().getVisibleLeafColumns().size() > 1;
    }

    private void initUI() {
        if (this.column == null) {
            return;
        }
        this.setOnMousePressed(mousePressedHandler);
        this.setOnMouseDragged(mouseDraggedHandler);
        this.setOnContextMenuRequested(contextMenuRequestedHandler);
        this.setOnMouseReleased(mouseReleasedHandler);
        this.label = new Label();
        this.label.setText(this.column.getText());
        this.label.setGraphic(this.column.getGraphic());
        this.label.setVisible(this.column.isVisible());
        if (this.isSortingEnabled()) {
            this.updateSortGrid();
        }
    }

    private void updateSortPosition() {
        this.sortPos = !this.column.isSortable() ? -1 : this.getSortPosition();
        this.updateSortGrid();
    }

    private void updateSortGrid() {
        if (this instanceof NestedTableColumnHeader) {
            return;
        }
        this.getChildren().clear();
        this.getChildren().add(this.label);
        if (!this.isSortingEnabled()) {
            return;
        }
        boolean bl = this.isSortColumn = this.sortPos != -1;
        if (!this.isSortColumn) {
            if (this.sortArrow != null) {
                this.sortArrow.setVisible(false);
            }
            return;
        }
        int n = this.skin.getVisibleLeafIndex(this.getTableColumn());
        if (n == -1) {
            return;
        }
        int n2 = this.getSortColumnCount();
        boolean bl2 = this.sortPos <= 3 && n2 > 1;
        Node node = null;
        if (this.getTableColumn().getSortNode() != null) {
            node = this.getTableColumn().getSortNode();
            this.getChildren().add(node);
        } else {
            GridPane gridPane = new GridPane();
            node = gridPane;
            gridPane.setPadding(new Insets(0.0, 3.0, 0.0, 0.0));
            this.getChildren().add(gridPane);
            if (this.arrow == null) {
                this.arrow = new Region();
                this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
                this.arrow.setVisible(true);
                this.arrow.setRotate(TableColumnSortTypeWrapper.isAscending(this.column) ? 180.0 : 0.0);
                this.changeListenerHandler.registerChangeListener(TableColumnSortTypeWrapper.getSortTypeProperty(this.column), "TABLE_COLUMN_SORT_TYPE");
            }
            this.arrow.setVisible(this.isSortColumn);
            if (this.sortPos > 2) {
                if (this.sortOrderLabel == null) {
                    this.sortOrderLabel = new Label();
                    this.sortOrderLabel.getStyleClass().add("sort-order");
                }
                this.sortOrderLabel.setText("" + (this.sortPos + 1));
                this.sortOrderLabel.setVisible(n2 > 1);
                gridPane.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.NEVER);
                gridPane.add(this.sortOrderLabel, 2, 1);
            } else if (bl2) {
                boolean bl3;
                if (this.sortOrderDots == null) {
                    this.sortOrderDots = new HBox(1.0);
                    this.sortOrderDots.getStyleClass().add("sort-order-dots-container");
                }
                int n3 = (bl3 = TableColumnSortTypeWrapper.isAscending(this.column)) ? 1 : 2;
                int n4 = bl3 ? 2 : 1;
                gridPane.add(this.arrow, 1, n3);
                GridPane.setHalignment(this.arrow, HPos.CENTER);
                gridPane.add(this.sortOrderDots, 1, n4);
                this.sortOrderDotsDirty = true;
            } else {
                gridPane.add(this.arrow, 1, 1);
                GridPane.setHgrow(this.arrow, Priority.NEVER);
                GridPane.setVgrow(this.arrow, Priority.ALWAYS);
            }
        }
        this.sortArrow = node;
        if (this.sortArrow != null) {
            this.sortArrow.setVisible(this.isSortColumn);
        }
        this.requestLayout();
    }

    private void updateSortOrderDots(int n) {
        double d = this.arrow.prefWidth(-1.0);
        if (d == 0.0) {
            this.arrow.impl_processCSS(true);
            d = this.arrow.prefWidth(-1.0);
        }
        this.sortOrderDots.getChildren().clear();
        for (int i = 0; i <= n; ++i) {
            Region region = new Region();
            region.getStyleClass().add("sort-order-dot");
            String string = TableColumnSortTypeWrapper.getSortTypeName(this.column);
            if (string != null && !string.isEmpty()) {
                region.getStyleClass().add(string.toLowerCase(Locale.ROOT));
            }
            this.sortOrderDots.getChildren().add(region);
        }
        this.sortOrderDots.setAlignment(Pos.TOP_CENTER);
        this.sortOrderDots.setMaxWidth(d);
    }

    private void moveColumn(TableColumnBase tableColumnBase, int n) {
        if (tableColumnBase == null || n < 0) {
            return;
        }
        ObservableList<Object> observableList = tableColumnBase.getParentColumn() == null ? this.getTableViewSkin().getColumns() : tableColumnBase.getParentColumn().getColumns();
        int n2 = observableList.indexOf(tableColumnBase);
        if (n == n2) {
            return;
        }
        if (n >= observableList.size()) {
            n = observableList.size() - 1;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(observableList);
        arrayList.remove(tableColumnBase);
        arrayList.add(n, tableColumnBase);
        observableList.setAll((Collection<Object>)arrayList);
    }

    private void updateColumnIndex() {
        TableViewSkinBase tableViewSkinBase = this.getTableViewSkin();
        TableColumnBase tableColumnBase = this.getTableColumn();
        this.columnIndex = tableViewSkinBase == null || tableColumnBase == null ? -1 : tableViewSkinBase.getVisibleLeafIndex(tableColumnBase);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == this.getTableViewSkin().getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void sortColumn(boolean bl) {
        if (!this.isSortingEnabled()) {
            return;
        }
        if (this.column == null || this.column.getColumns().size() != 0 || this.column.getComparator() == null || !this.column.isSortable()) {
            return;
        }
        ObservableList observableList = this.getTableViewSkin().getSortOrder();
        if (bl) {
            if (!this.isSortColumn) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.ASCENDING);
                observableList.add(this.column);
            } else if (TableColumnSortTypeWrapper.isAscending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.DESCENDING);
            } else {
                int n = observableList.indexOf(this.column);
                if (n != -1) {
                    observableList.remove(n);
                }
            }
        } else if (this.isSortColumn && observableList.size() == 1) {
            if (TableColumnSortTypeWrapper.isAscending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.DESCENDING);
            } else {
                observableList.remove(this.column);
            }
        } else if (this.isSortColumn) {
            if (TableColumnSortTypeWrapper.isAscending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.DESCENDING);
            } else if (TableColumnSortTypeWrapper.isDescending(this.column)) {
                TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.ASCENDING);
            }
            ArrayList arrayList = new ArrayList(observableList);
            arrayList.remove(this.column);
            arrayList.add(0, this.column);
            observableList.setAll(this.column);
        } else {
            TableColumnSortTypeWrapper.setSortType(this.column, TableColumn.SortType.ASCENDING);
            observableList.setAll(this.column);
        }
    }

    private int getSortPosition() {
        if (this.column == null) {
            return -1;
        }
        ObservableList observableList = this.getTableViewSkin().getSortOrder();
        int n = 0;
        for (int i = 0; i < observableList.size(); ++i) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get(i);
            if (tableColumnBase == null || !tableColumnBase.isSortable()) continue;
            if (this.column.equals(tableColumnBase)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private int getSortColumnCount() {
        ObservableList observableList = this.getTableViewSkin().getSortOrder();
        int n = 0;
        for (int i = 0; i < observableList.size(); ++i) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get(i);
            if (tableColumnBase == null || !tableColumnBase.isSortable()) continue;
            ++n;
        }
        return n;
    }

    private void columnReorderingStarted(MouseEvent mouseEvent) {
        if (!this.column.impl_isReorderable()) {
            return;
        }
        this.dragOffset = mouseEvent.getX();
        this.getTableHeaderRow().setReorderingColumn(this.column);
        this.getTableHeaderRow().setReorderingRegion(this);
    }

    private void columnReordering(MouseEvent mouseEvent) {
        if (!this.column.impl_isReorderable()) {
            return;
        }
        this.getTableHeaderRow().setReordering(true);
        TableColumnHeader tableColumnHeader = null;
        double d = this.getParentHeader().sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX();
        double d2 = ((Node)((Object)this.getTableViewSkin().getSkinnable())).sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getX() - this.dragOffset;
        this.getTableHeaderRow().setDragHeaderX(d2);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        this.newColumnPos = 0;
        for (TableColumnHeader tableColumnHeader2 : this.getParentHeader().getColumnHeaders()) {
            double d6 = tableColumnHeader2.prefWidth(-1.0);
            d5 += d6;
            d3 = tableColumnHeader2.getBoundsInParent().getMinX();
            d4 = d3 + d6;
            if (d >= d3 && d < d4) {
                tableColumnHeader = tableColumnHeader2;
                break;
            }
            ++this.newColumnPos;
        }
        if (tableColumnHeader == null) {
            this.newColumnPos = d > d5 ? this.getParentHeader().getColumns().size() - 1 : 0;
            return;
        }
        double d7 = d3 + (d4 - d3) / 2.0;
        boolean bl = d <= d7;
        int n = this.getIndex();
        this.newColumnPos += this.newColumnPos > n && bl ? -1 : (this.newColumnPos < n && !bl ? 1 : 0);
        double d8 = this.getTableHeaderRow().sceneToLocal(tableColumnHeader.localToScene(tableColumnHeader.getBoundsInLocal())).getMinX();
        if ((d8 += bl ? 0.0 : tableColumnHeader.getWidth()) >= -0.5 && d8 <= ((Region)((Object)this.getTableViewSkin().getSkinnable())).getWidth()) {
            this.columnReorderLine.setTranslateX(d8);
            this.columnReorderLine.setVisible(true);
        }
        this.getTableHeaderRow().setReordering(true);
    }

    private int getIndex() {
        return this.column.getParentColumn() == null ? this.getTableViewSkin().getColumns().indexOf(this.column) : this.column.getParentColumn().getColumns().indexOf(this.column);
    }

    protected void columnReorderingComplete(MouseEvent mouseEvent) {
        if (!this.column.impl_isReorderable()) {
            return;
        }
        this.moveColumn(this.getTableColumn(), this.newColumnPos);
        this.columnReorderLine.setTranslateX(0.0);
        this.columnReorderLine.setLayoutX(0.0);
        this.newColumnPos = 0;
        this.getTableHeaderRow().setReordering(false);
        this.columnReorderLine.setVisible(false);
        this.getTableHeaderRow().setReorderingColumn(null);
        this.getTableHeaderRow().setReorderingRegion(null);
        this.dragOffset = 0.0;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TableColumnHeader.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<TableColumnHeader, Number> SIZE = new CssMetaData<TableColumnHeader, Number>("-fx-size", SizeConverter.getInstance(), (Number)20.0){

            @Override
            public boolean isSettable(TableColumnHeader tableColumnHeader) {
                return tableColumnHeader.size == null || !tableColumnHeader.size.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TableColumnHeader tableColumnHeader) {
                return (StyleableProperty)((Object)tableColumnHeader.sizeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Region.getClassCssMetaData());
            arrayList.add(SIZE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

