/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.collections.ListListenerHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class ReadOnlyUnbackedObservableList<E>
implements ObservableList<E> {
    private ListListenerHelper<E> listenerHelper;

    @Override
    public abstract E get(int var1);

    @Override
    public abstract int size();

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, invalidationListener);
    }

    @Override
    public void addListener(ListChangeListener<? super E> listChangeListener) {
        this.listenerHelper = ListListenerHelper.addListener(this.listenerHelper, listChangeListener);
    }

    @Override
    public void removeListener(ListChangeListener<? super E> listChangeListener) {
        this.listenerHelper = ListListenerHelper.removeListener(this.listenerHelper, listChangeListener);
    }

    public void callObservers(ListChangeListener.Change<E> change) {
        ListListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            E e = this.get(i);
            if (!object.equals(e)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            E e = this.get(i);
            if (!object.equals(e)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new SelectionListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new SelectionListIterator(this, n);
    }

    @Override
    public Iterator<E> iterator() {
        return new SelectionListIterator(this);
    }

    @Override
    public List<E> subList(final int n, final int n2) {
        if (n >= n2) {
            return Collections.emptyList();
        }
        final ReadOnlyUnbackedObservableList readOnlyUnbackedObservableList = this;
        return new ReadOnlyUnbackedObservableList<E>(){

            @Override
            public E get(int n3) {
                return readOnlyUnbackedObservableList.get(n3 + n);
            }

            @Override
            public int size() {
                return n2 - n;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            objectArray[i] = this.get(i);
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = this.toArray();
        int n = objectArray.length;
        if (TArray.length < n) {
            return Arrays.copyOf(objectArray, n, TArray.getClass());
        }
        System.arraycopy(objectArray, 0, TArray, 0, n);
        if (TArray.length > n) {
            TArray[n] = null;
        }
        return TArray;
    }

    public String toString() {
        Iterator<E> iterator = this.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        while (true) {
            E e;
            stringBuilder.append((Object)((e = iterator.next()) == this ? "(this Collection)" : e));
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
        }
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void add(int n, E e) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public E set(int n, E e) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean setAll(Collection<? extends E> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean setAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public E remove(int n) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void remove(int n, int n2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(E ... EArray) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private static class SelectionListIterator<E>
    implements ListIterator<E> {
        private int pos;
        private final ReadOnlyUnbackedObservableList<E> list;

        public SelectionListIterator(ReadOnlyUnbackedObservableList<E> readOnlyUnbackedObservableList) {
            this(readOnlyUnbackedObservableList, 0);
        }

        public SelectionListIterator(ReadOnlyUnbackedObservableList<E> readOnlyUnbackedObservableList, int n) {
            this.list = readOnlyUnbackedObservableList;
            this.pos = n;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.list.size();
        }

        @Override
        public E next() {
            return this.list.get(this.pos++);
        }

        @Override
        public boolean hasPrevious() {
            return this.pos > 0;
        }

        @Override
        public E previous() {
            return this.list.get(this.pos--);
        }

        @Override
        public int nextIndex() {
            return this.pos + 1;
        }

        @Override
        public int previousIndex() {
            return this.pos - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

