/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.freetype.OSPango;
import com.sun.javafx.font.freetype.PangoGlyphInfo;
import com.sun.javafx.font.freetype.PangoGlyphString;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.PrismTextLayout;
import com.sun.javafx.text.TextRun;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

class PangoGlyphLayout
extends GlyphLayout {
    PangoGlyphLayout() {
    }

    private int getSlot(PGFont pGFont, PangoGlyphString pangoGlyphString) {
        CompositeFontResource compositeFontResource = (CompositeFontResource)pGFont.getFontResource();
        long l = pangoGlyphString.font;
        long l2 = OSPango.pango_font_describe(l);
        String string = OSPango.pango_font_description_get_family(l2);
        int n = OSPango.pango_font_description_get_style(l2);
        int n2 = OSPango.pango_font_description_get_weight(l2);
        OSPango.pango_font_description_free(l2);
        boolean bl = n2 == 700;
        boolean bl2 = n != 0;
        PrismFontFactory prismFontFactory = PrismFontFactory.getFontFactory();
        PGFont pGFont2 = prismFontFactory.createFont(string, bl, bl2, pGFont.getSize());
        String string2 = pGFont2.getFullName();
        String string3 = compositeFontResource.getSlotResource(0).getFullName();
        int n3 = 0;
        if (!string2.equalsIgnoreCase(string3)) {
            n3 = compositeFontResource.getSlotForFont(string2);
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tFallback font= " + string2 + " slot=" + (n3 >> 24));
            }
        }
        return n3;
    }

    @Override
    protected TextRun addTextRun(PrismTextLayout prismTextLayout, char[] cArray, int n, int n2, PGFont pGFont, TextSpan textSpan, byte by) {
        long l;
        FontResource fontResource;
        boolean bl;
        int n3;
        ByteBuffer byteBuffer;
        CharBuffer charBuffer;
        TextRun textRun = null;
        Charset charset = StandardCharsets.UTF_8;
        CharsetEncoder charsetEncoder = charset.newEncoder();
        CoderResult coderResult = charsetEncoder.encode(charBuffer = CharBuffer.wrap(cArray, n, n2), byteBuffer = ByteBuffer.allocateDirect(n3 = (int)((double)n2 * (double)charsetEncoder.averageBytesPerChar())), true);
        if (coderResult.isOverflow()) {
            n3 = (int)((double)n2 * (double)charsetEncoder.maxBytesPerChar());
            charBuffer.rewind();
            byteBuffer = ByteBuffer.allocateDirect(n3);
            charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (PrismFontFactory.debugFonts) {
                System.err.println("[PANGO] ByteBuffer capacity increased " + byteBuffer);
            }
        }
        if (bl = (fontResource = pGFont.getFontResource()) instanceof CompositeFontResource) {
            fontResource = ((CompositeFontResource)fontResource).getSlotResource(0);
        }
        long l2 = OSPango.pango_ft2_font_map_new();
        long l3 = OSPango.pango_font_map_create_context(l2);
        float f = pGFont.getSize();
        int n4 = fontResource.isItalic() ? 2 : 0;
        int n5 = fontResource.isBold() ? 700 : 400;
        long l4 = OSPango.pango_font_description_new();
        OSPango.pango_font_description_set_family(l4, fontResource.getFamilyName());
        OSPango.pango_font_description_set_absolute_size(l4, f * 1024.0f);
        OSPango.pango_font_description_set_stretch(l4, 4);
        OSPango.pango_font_description_set_style(l4, n4);
        OSPango.pango_font_description_set_weight(l4, n5);
        long l5 = OSPango.pango_attr_list_new();
        long l6 = OSPango.pango_attr_font_desc_new(l4);
        OSPango.pango_attr_list_insert(l5, l6);
        if (!bl) {
            l6 = OSPango.pango_attr_fallback_new(false);
            OSPango.pango_attr_list_insert(l5, l6);
        }
        if ((l = OSPango.pango_itemize(l3, byteBuffer, 0, byteBuffer.position(), l5, 0L)) != 0L) {
            int n6 = OSPango.g_list_length(l);
            int n7 = n;
            for (int i = 0; i < n6; ++i) {
                int n8;
                long l7 = OSPango.g_list_nth_data(l, i);
                PangoGlyphString pangoGlyphString = OSPango.pango_shape(byteBuffer, l7);
                OSPango.pango_item_free(l7);
                if (pangoGlyphString == null) continue;
                int n9 = bl ? this.getSlot(pGFont, pangoGlyphString) : 0;
                int n10 = pangoGlyphString.num_glyphs;
                int[] nArray = new int[n10];
                float[] fArray = new float[n10 * 2 + 2];
                PangoGlyphInfo pangoGlyphInfo = null;
                int n11 = 2;
                int n12 = 0;
                for (n8 = 0; n8 < n10; ++n8) {
                    pangoGlyphInfo = pangoGlyphString.glyphs[n8];
                    if (n9 != -1) {
                        nArray[n8] = n9 << 24 | pangoGlyphInfo.glyph;
                    }
                    if (f != 0.0f) {
                        n12 += pangoGlyphInfo.width;
                    }
                    fArray[n11] = (float)n12 / 1024.0f;
                    n11 += 2;
                }
                n8 = pangoGlyphString.num_chars;
                textRun = new TextRun(n7, n8, by, true, 0, textSpan, 0, false);
                textRun.shape(n10, nArray, fArray, pangoGlyphString.log_clusters);
                prismTextLayout.addTextRun(textRun);
                n7 += n8;
            }
            OSPango.g_list_free(l);
        }
        OSPango.pango_attr_list_unref(l5);
        OSPango.pango_font_description_free(l4);
        OSPango.g_object_unref(l3);
        OSPango.g_object_unref(l2);
        return textRun;
    }

    @Override
    public void layout(TextRun textRun, PGFont pGFont, FontStrike fontStrike, char[] cArray) {
    }
}

