/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.jmx.MXExtension;
import com.sun.javafx.runtime.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javafx.application.Application;
import javafx.application.Preloader;
import javafx.stage.Stage;
import sun.misc.BASE64Decoder;

public class LauncherImpl {
    public static final String LAUNCH_MODE_CLASS = "LM_CLASS";
    public static final String LAUNCH_MODE_JAR = "LM_JAR";
    private static final boolean trace = false;
    private static boolean verbose = false;
    private static final String MF_MAIN_CLASS = "Main-Class";
    private static final String MF_JAVAFX_MAIN = "JavaFX-Application-Class";
    private static final String MF_JAVAFX_PRELOADER = "JavaFX-Preloader-Class";
    private static final String MF_JAVAFX_CLASS_PATH = "JavaFX-Class-Path";
    private static final String MF_JAVAFX_FEATURE_PROXY = "JavaFX-Feature-Proxy";
    private static final String MF_JAVAFX_ARGUMENT_PREFIX = "JavaFX-Argument-";
    private static final String MF_JAVAFX_PARAMETER_NAME_PREFIX = "JavaFX-Parameter-Name-";
    private static final String MF_JAVAFX_PARAMETER_VALUE_PREFIX = "JavaFX-Parameter-Value-";
    private static final boolean simulateSlowProgress = false;
    private static AtomicBoolean launchCalled = new AtomicBoolean(false);
    private static final AtomicBoolean toolkitStarted = new AtomicBoolean(false);
    private static volatile RuntimeException launchException = null;
    private static Preloader currentPreloader = null;
    private static Class<? extends Preloader> savedPreloaderClass = null;
    private static volatile boolean error = false;
    private static volatile Throwable pConstructorError = null;
    private static volatile Throwable pInitError = null;
    private static volatile Throwable pStartError = null;
    private static volatile Throwable pStopError = null;
    private static volatile Throwable constructorError = null;
    private static volatile Throwable initError = null;
    private static volatile Throwable startError = null;
    private static volatile Throwable stopError = null;
    private static Method notifyMethod = null;

    public static void launchApplication(Class<? extends Application> clazz, String[] stringArray) {
        LauncherImpl.launchApplication(clazz, savedPreloaderClass, stringArray);
    }

    public static void launchApplication(final Class<? extends Application> clazz, final Class<? extends Preloader> clazz2, final String[] stringArray) {
        if (launchCalled.getAndSet(true)) {
            throw new IllegalStateException("Application launch must not be called more than once");
        }
        if (!Application.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Error: " + clazz.getName() + " is not a subclass of javafx.application.Application");
        }
        if (clazz2 != null && !Preloader.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("Error: " + clazz2.getName() + " is not a subclass of javafx.application.Preloader");
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LauncherImpl.launchApplication1(clazz, clazz2, stringArray);
                }
                catch (RuntimeException runtimeException) {
                    launchException = runtimeException;
                }
                catch (Exception exception) {
                    launchException = new RuntimeException("Application launch exception", exception);
                }
                catch (Error error) {
                    launchException = new RuntimeException("Application launch error", error);
                }
                finally {
                    countDownLatch.countDown();
                }
            }
        });
        thread.setName("JavaFX-Launcher");
        thread.start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Unexpected exception: ", interruptedException);
        }
        if (launchException != null) {
            throw launchException;
        }
    }

    public static void launchApplication(String string, String string2, String[] stringArray) {
        Object object;
        Object object2;
        if (verbose) {
            System.err.println("Java 8 launchApplication method: launchMode=" + string2);
        }
        String string3 = null;
        String string4 = null;
        String[] stringArray2 = stringArray;
        ClassLoader classLoader = null;
        verbose = Boolean.getBoolean("javafx.verbose");
        if (string2.equals(LAUNCH_MODE_JAR)) {
            String string5;
            object2 = LauncherImpl.getJarAttributes(string);
            if (object2 == null) {
                LauncherImpl.abort(null, "Can't get manifest attributes from jar", new Object[0]);
            }
            if ((object = ((Attributes)object2).getValue(MF_JAVAFX_CLASS_PATH)) != null) {
                if (((String)object).trim().length() == 0) {
                    object = null;
                } else {
                    if (verbose) {
                        System.err.println("WARNING: Application jar uses deprecated JavaFX-Class-Path attribute. Please use Class-Path instead.");
                    }
                    classLoader = LauncherImpl.setupJavaFXClassLoader(new File(string), (String)object);
                }
            }
            if ((string5 = ((Attributes)object2).getValue(MF_JAVAFX_FEATURE_PROXY)) != null && "auto".equals(string5.toLowerCase())) {
                LauncherImpl.trySetAutoProxy();
            }
            if (stringArray.length == 0) {
                stringArray2 = LauncherImpl.getAppArguments((Attributes)object2);
            }
            if ((string3 = ((Attributes)object2).getValue(MF_JAVAFX_MAIN)) == null && (string3 = ((Attributes)object2).getValue(MF_MAIN_CLASS)) == null) {
                LauncherImpl.abort(null, "JavaFX jar manifest requires a valid JavaFX-Appliation-Class or Main-Class entry", new Object[0]);
            }
            string3 = string3.trim();
            string4 = ((Attributes)object2).getValue(MF_JAVAFX_PRELOADER);
            if (string4 != null) {
                string4 = string4.trim();
            }
        } else if (string2.equals(LAUNCH_MODE_CLASS)) {
            string3 = string;
            string4 = System.getProperty("javafx.preloader");
        } else {
            LauncherImpl.abort(new IllegalArgumentException("The launchMode argument must be one of LM_CLASS or LM_JAR"), "Invalid launch mode: %1$s", string2);
        }
        if (string3 == null) {
            LauncherImpl.abort(null, "No main JavaFX class to launch", new Object[0]);
        }
        if (classLoader != null) {
            try {
                object2 = classLoader.loadClass(LauncherImpl.class.getName());
                object = ((Class)object2).getMethod("launchApplicationWithArgs", String.class, String.class, new String[0].getClass());
                Thread.currentThread().setContextClassLoader(classLoader);
                ((Method)object).invoke(null, string3, string4, stringArray2);
            }
            catch (Exception exception) {
                LauncherImpl.abort(exception, "Exception while launching application", new Object[0]);
            }
        } else {
            LauncherImpl.launchApplicationWithArgs(string3, string4, stringArray2);
        }
    }

    public static void launchApplicationWithArgs(final String string, final String string2, String[] stringArray) {
        try {
            LauncherImpl.startToolkit();
        }
        catch (InterruptedException interruptedException) {
            LauncherImpl.abort(interruptedException, "Toolkit initialization error", string);
        }
        Class clazz = null;
        Class clazz2 = null;
        final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicReference atomicReference2 = new AtomicReference();
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LauncherImpl.abort(classNotFoundException, "Missing JavaFX application class %1$s", new Object[]{string});
                }
                atomicReference.set(clazz);
                if (string2 != null) {
                    try {
                        clazz = Class.forName(string2, true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LauncherImpl.abort(classNotFoundException, "Missing JavaFX preloader class %1$s", new Object[]{string2});
                    }
                    if (!Preloader.class.isAssignableFrom(clazz)) {
                        LauncherImpl.abort(null, "JavaFX preloader class %1$s does not extend javafx.application.Preloader", new Object[]{clazz.getName()});
                    }
                    atomicReference2.set(clazz.asSubclass(Preloader.class));
                }
            }
        });
        clazz = (Class)atomicReference2.get();
        clazz2 = (Class)atomicReference.get();
        savedPreloaderClass = clazz;
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Method method = clazz2.getMethod("main", new String[0].getClass());
            if (verbose) {
                System.err.println("Calling main(String[]) method");
            }
            method.invoke(null, new Object[]{stringArray});
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException2) {
            reflectiveOperationException = reflectiveOperationException2;
            savedPreloaderClass = null;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            LauncherImpl.abort(null, "Exception running application %1$s", clazz2.getName());
            return;
        }
        if (!Application.class.isAssignableFrom(clazz2)) {
            LauncherImpl.abort(reflectiveOperationException, "JavaFX application class %1$s does not extend javafx.application.Application", clazz2.getName());
        }
        Class<Application> clazz3 = clazz2.asSubclass(Application.class);
        if (verbose) {
            System.err.println("Launching application directly");
        }
        LauncherImpl.launchApplication(clazz3, clazz, stringArray);
    }

    private static URL fileToURL(File file) throws IOException {
        return file.getCanonicalFile().toURI().toURL();
    }

    private static ClassLoader setupJavaFXClassLoader(File file, String string) {
        try {
            URL[] uRLArray;
            File file2 = file.getParentFile();
            ArrayList<URL> arrayList = new ArrayList<URL>();
            String string2 = string;
            if (string2 != null) {
                while (string2.length() > 0) {
                    String string3;
                    int n = string2.indexOf(" ");
                    if (n < 0) {
                        string3 = string2;
                        URL[] uRLArray2 = uRLArray = file2 == null ? new File(string3) : new File(file2, string3);
                        if (uRLArray.exists()) {
                            arrayList.add(LauncherImpl.fileToURL((File)uRLArray));
                            break;
                        }
                        if (!verbose) break;
                        System.err.println("Class Path entry \"" + string3 + "\" does not exist, ignoring");
                        break;
                    }
                    if (n > 0) {
                        string3 = string2.substring(0, n);
                        URL[] uRLArray3 = uRLArray = file2 == null ? new File(string3) : new File(file2, string3);
                        if (uRLArray.exists()) {
                            arrayList.add(LauncherImpl.fileToURL((File)uRLArray));
                        } else if (verbose) {
                            System.err.println("Class Path entry \"" + string3 + "\" does not exist, ignoring");
                        }
                    }
                    string2 = string2.substring(n + 1);
                }
            }
            if (!arrayList.isEmpty()) {
                ArrayList<URL> arrayList2 = new ArrayList<URL>();
                string2 = System.getProperty("java.class.path");
                if (string2 != null) {
                    while (string2.length() > 0) {
                        int n = string2.indexOf(File.pathSeparatorChar);
                        if (n < 0) {
                            uRLArray = string2;
                            arrayList2.add(LauncherImpl.fileToURL(new File((String)uRLArray)));
                            break;
                        }
                        if (n > 0) {
                            uRLArray = string2.substring(0, n);
                            arrayList2.add(LauncherImpl.fileToURL(new File((String)uRLArray)));
                        }
                        string2 = string2.substring(n + 1);
                    }
                }
                URL uRL = LauncherImpl.class.getProtectionDomain().getCodeSource().getLocation();
                arrayList2.add(uRL);
                arrayList2.addAll(arrayList);
                uRLArray = arrayList2.toArray(new URL[0]);
                if (verbose) {
                    System.err.println("===== URL list");
                    for (int i = 0; i < uRLArray.length; ++i) {
                        System.err.println("" + uRLArray[i]);
                    }
                    System.err.println("=====");
                }
                return new URLClassLoader(uRLArray, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void trySetAutoProxy() {
        block9: {
            URL[] uRLArray;
            if (System.getProperty("http.proxyHost") != null || System.getProperty("https.proxyHost") != null || System.getProperty("ftp.proxyHost") != null || System.getProperty("socksProxyHost") != null) {
                if (verbose) {
                    System.out.println("Explicit proxy settings detected. Skip autoconfig.");
                    System.out.println("  http.proxyHost=" + System.getProperty("http.proxyHost"));
                    System.out.println("  https.proxyHost=" + System.getProperty("https.proxyHost"));
                    System.out.println("  ftp.proxyHost=" + System.getProperty("ftp.proxyHost"));
                    System.out.println("  socksProxyHost=" + System.getProperty("socksProxyHost"));
                }
                return;
            }
            if (System.getProperty("javafx.autoproxy.disable") != null) {
                if (verbose) {
                    System.out.println("Disable autoproxy on request.");
                }
                return;
            }
            String string = System.getProperty("java.home");
            File file = new File(string, "lib");
            File file2 = new File(file, "deploy.jar");
            try {
                uRLArray = new URL[]{file2.toURI().toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                return;
            }
            try {
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
                Class<?> clazz = Class.forName("com.sun.deploy.services.ServiceManager", true, uRLClassLoader);
                Class[] classArray = new Class[]{Integer.TYPE};
                Method method = clazz.getDeclaredMethod("setService", classArray);
                String string2 = System.getProperty("os.name");
                String string3 = string2.startsWith("Win") ? "STANDALONE_TIGER_WIN32" : (string2.contains("Mac") ? "STANDALONE_TIGER_MACOSX" : "STANDALONE_TIGER_UNIX");
                Object[] objectArray = new Object[1];
                Class<?> clazz2 = Class.forName("com.sun.deploy.services.PlatformType", true, uRLClassLoader);
                objectArray[0] = clazz2.getField(string3).get(null);
                method.invoke(null, objectArray);
                Class<?> clazz3 = Class.forName("com.sun.deploy.net.proxy.DeployProxySelector", true, uRLClassLoader);
                Method method2 = clazz3.getDeclaredMethod("reset", new Class[0]);
                method2.invoke(null, new Object[0]);
                if (verbose) {
                    System.out.println("Autoconfig of proxy is completed.");
                }
            }
            catch (Exception exception) {
                if (!verbose) break block9;
                System.err.println("Failed to autoconfig proxy due to " + exception);
            }
        }
    }

    private static String decodeBase64(String string) throws IOException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        byte[] byArray = bASE64Decoder.decodeBuffer(string);
        return new String(byArray);
    }

    private static String[] getAppArguments(Attributes attributes) {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            int n = 1;
            String string = MF_JAVAFX_ARGUMENT_PREFIX;
            while (attributes.getValue(string + n) != null) {
                linkedList.add(LauncherImpl.decodeBase64(attributes.getValue(string + n)));
                ++n;
            }
            String string2 = MF_JAVAFX_PARAMETER_NAME_PREFIX;
            String string3 = MF_JAVAFX_PARAMETER_VALUE_PREFIX;
            n = 1;
            while (attributes.getValue(string2 + n) != null) {
                String string4 = LauncherImpl.decodeBase64(attributes.getValue(string2 + n));
                String string5 = null;
                if (attributes.getValue(string3 + n) != null) {
                    string5 = LauncherImpl.decodeBase64(attributes.getValue(string3 + n));
                }
                linkedList.add("--" + string4 + "=" + (string5 != null ? string5 : ""));
                ++n;
            }
        }
        catch (IOException iOException) {
            if (verbose) {
                System.err.println("Failed to extract application parameters");
            }
            iOException.printStackTrace();
        }
        return linkedList.toArray(new String[0]);
    }

    private static void abort(Throwable throwable, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        if (string2 != null) {
            System.err.println(string2);
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getJarAttributes(String string) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(string);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                LauncherImpl.abort(null, "No manifest in jar file %1$s", string);
            }
            Attributes attributes = manifest.getMainAttributes();
            return attributes;
        }
        catch (IOException iOException) {
            LauncherImpl.abort(iOException, "Error launching jar file %1%s", string);
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void startToolkit() throws InterruptedException {
        if (toolkitStarted.getAndSet(true)) {
            return;
        }
        if (SystemProperties.isDebug()) {
            MXExtension.initializeIfAvailable();
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        PlatformImpl.startup(new Runnable(){

            @Override
            public void run() {
                countDownLatch.countDown();
            }
        });
        countDownLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchApplication1(final Class<? extends Application> clazz, final Class<? extends Preloader> clazz2, final String[] stringArray) throws Exception {
        boolean bl;
        PlatformImpl.FinishListener finishListener;
        block32: {
            LauncherImpl.startToolkit();
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            final AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
            final AtomicBoolean atomicBoolean3 = new AtomicBoolean(false);
            AtomicBoolean atomicBoolean4 = new AtomicBoolean(false);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            final CountDownLatch countDownLatch2 = new CountDownLatch(1);
            finishListener = new PlatformImpl.FinishListener(){

                @Override
                public void idle(boolean bl) {
                    if (!bl) {
                        return;
                    }
                    if (atomicBoolean2.get()) {
                        countDownLatch.countDown();
                    } else if (atomicBoolean.get()) {
                        countDownLatch2.countDown();
                    }
                }

                @Override
                public void exitCalled() {
                    atomicBoolean3.set(true);
                    countDownLatch.countDown();
                }
            };
            PlatformImpl.addListener(finishListener);
            try {
                String string;
                final AtomicReference atomicReference = new AtomicReference();
                if (clazz2 != null) {
                    PlatformImpl.runAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Constructor constructor = clazz2.getConstructor(new Class[0]);
                                atomicReference.set(constructor.newInstance(new Object[0]));
                                ParametersImpl.registerParameters((Application)atomicReference.get(), new ParametersImpl(stringArray));
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Preloader constructor");
                                pConstructorError = throwable;
                                error = true;
                            }
                        }
                    });
                }
                if ((currentPreloader = (Preloader)atomicReference.get()) != null && !error && !atomicBoolean3.get()) {
                    try {
                        currentPreloader.init();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in Preloader init method");
                        pInitError = throwable;
                        error = true;
                    }
                }
                if (currentPreloader != null && !error && !atomicBoolean3.get()) {
                    PlatformImpl.runAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                atomicBoolean.set(true);
                                Stage stage = new Stage();
                                stage.impl_setPrimary(true);
                                currentPreloader.start(stage);
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Preloader start method");
                                pStartError = throwable;
                                error = true;
                            }
                        }
                    });
                    if (!error && !atomicBoolean3.get()) {
                        LauncherImpl.notifyProgress(currentPreloader, 0.0);
                    }
                }
                final AtomicReference atomicReference2 = new AtomicReference();
                if (!error && !atomicBoolean3.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyProgress(currentPreloader, 1.0);
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_LOAD, null);
                    }
                    PlatformImpl.runAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Constructor constructor = clazz.getConstructor(new Class[0]);
                                atomicReference2.set(constructor.newInstance(new Object[0]));
                                ParametersImpl.registerParameters((Application)atomicReference2.get(), new ParametersImpl(stringArray));
                                PlatformImpl.setApplicationName(clazz);
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Application constructor");
                                constructorError = throwable;
                                error = true;
                            }
                        }
                    });
                }
                final Application application = (Application)atomicReference2.get();
                if (!error && !atomicBoolean3.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_INIT, application);
                    }
                    try {
                        application.init();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in Application init method");
                        initError = throwable;
                        error = true;
                    }
                }
                if (!error && !atomicBoolean3.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_START, application);
                    }
                    PlatformImpl.runAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                atomicBoolean2.set(true);
                                Stage stage = new Stage();
                                stage.impl_setPrimary(true);
                                application.start(stage);
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Application start method");
                                startError = throwable;
                                error = true;
                            }
                        }
                    });
                }
                if (!error) {
                    countDownLatch.await();
                }
                if (atomicBoolean2.get()) {
                    PlatformImpl.runAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                application.stop();
                            }
                            catch (Throwable throwable) {
                                System.err.println("Exception in Application stop method");
                                stopError = throwable;
                                error = true;
                            }
                        }
                    });
                }
                if (!error) break block32;
                if (pConstructorError != null) {
                    throw new RuntimeException("Unable to construct Preloader instance: " + clazz, pConstructorError);
                }
                if (pInitError != null) {
                    throw new RuntimeException("Exception in Preloader init method", pInitError);
                }
                if (pStartError != null) {
                    throw new RuntimeException("Exception in Preloader start method", pStartError);
                }
                if (pStopError != null) {
                    throw new RuntimeException("Exception in Preloader stop method", pStopError);
                }
                if (constructorError != null) {
                    String string2 = "Unable to construct Application instance: " + clazz;
                    if (!LauncherImpl.notifyError(string2, constructorError)) {
                        throw new RuntimeException(string2, constructorError);
                    }
                    break block32;
                }
                if (initError != null) {
                    String string3 = "Exception in Application init method";
                    if (!LauncherImpl.notifyError(string3, initError)) {
                        throw new RuntimeException(string3, initError);
                    }
                    break block32;
                }
                if (startError != null) {
                    String string4 = "Exception in Application start method";
                    if (!LauncherImpl.notifyError(string4, startError)) {
                        throw new RuntimeException(string4, startError);
                    }
                    break block32;
                }
                if (stopError == null || LauncherImpl.notifyError(string = "Exception in Application stop method", stopError)) break block32;
                throw new RuntimeException(string, stopError);
            }
            catch (Throwable throwable) {
                boolean bl2;
                PlatformImpl.removeListener(finishListener);
                boolean bl3 = bl2 = System.getSecurityManager() != null;
                if (error && bl2) {
                    System.err.println("Workaround until RT-13281 is implemented: keep toolkit alive");
                } else {
                    PlatformImpl.tkExit();
                }
                throw throwable;
            }
        }
        PlatformImpl.removeListener(finishListener);
        boolean bl4 = bl = System.getSecurityManager() != null;
        if (error && bl) {
            System.err.println("Workaround until RT-13281 is implemented: keep toolkit alive");
        } else {
            PlatformImpl.tkExit();
        }
    }

    private static void notifyStateChange(final Preloader preloader, final Preloader.StateChangeNotification.Type type, final Application application) {
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                preloader.handleStateChangeNotification(new Preloader.StateChangeNotification(type, application));
            }
        });
    }

    private static void notifyProgress(final Preloader preloader, final double d) {
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                preloader.handleProgressNotification(new Preloader.ProgressNotification(d));
            }
        });
    }

    private static boolean notifyError(final String string, final Throwable throwable) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (currentPreloader != null) {
                    try {
                        Preloader.ErrorNotification errorNotification = new Preloader.ErrorNotification(null, string, throwable);
                        boolean bl = currentPreloader.handleErrorNotification(errorNotification);
                        atomicBoolean.set(bl);
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                }
            }
        });
        return atomicBoolean.get();
    }

    private static void notifyCurrentPreloader(final Preloader.PreloaderNotification preloaderNotification) {
        PlatformImpl.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (currentPreloader != null) {
                    currentPreloader.handleApplicationNotification(preloaderNotification);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPreloader(Application application, Preloader.PreloaderNotification preloaderNotification) {
        if (launchCalled.get()) {
            LauncherImpl.notifyCurrentPreloader(preloaderNotification);
            return;
        }
        Class<LauncherImpl> clazz = LauncherImpl.class;
        synchronized (LauncherImpl.class) {
            if (notifyMethod == null) {
                try {
                    Class<?> clazz2 = Class.forName("com.sun.deploy.uitoolkit.impl.fx.FXPreloader");
                    notifyMethod = clazz2.getMethod("notifyCurrentPreloader", Preloader.PreloaderNotification.class);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                notifyMethod.invoke(null, preloaderNotification);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
    }

    private LauncherImpl() {
        throw new InternalError();
    }
}

